/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.filters.FiltersAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class FiltersAggregatorFactory
extends AggregatorFactory<FiltersAggregatorFactory> {
    private final String[] keys;
    final Weight[] weights;
    private final boolean keyed;
    private final boolean otherBucket;
    private final String otherBucketKey;

    public FiltersAggregatorFactory(String name, List<FiltersAggregator.KeyedFilter> filters, boolean keyed, boolean otherBucket, String otherBucketKey, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactories, metaData);
        this.keyed = keyed;
        this.otherBucket = otherBucket;
        this.otherBucketKey = otherBucketKey;
        ContextIndexSearcher contextSearcher = context.searcher();
        this.weights = new Weight[filters.size()];
        this.keys = new String[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            FiltersAggregator.KeyedFilter keyedFilter = filters.get(i);
            this.keys[i] = keyedFilter.key();
            Query filter = keyedFilter.filter().toFilter(context.getQueryShardContext());
            this.weights[i] = ((IndexSearcher)contextSearcher).createNormalizedWeight(filter, false);
        }
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new FiltersAggregator(this.name, this.factories, this.keys, this.weights, this.keyed, this.otherBucket ? this.otherBucketKey : null, this.context, parent, pipelineAggregators, metaData);
    }
}

