/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.AbstractLatLonPointDVIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;

public class GeoDistanceSortBuilder
extends SortBuilder<GeoDistanceSortBuilder> {
    public static final String NAME = "_geo_distance";
    public static final String ALTERNATIVE_NAME = "_geoDistance";
    public static final GeoValidationMethod DEFAULT_VALIDATION = GeoValidationMethod.DEFAULT;
    private static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    private static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField IGNORE_MALFORMED_FIELD = new ParseField("ignore_malformed", new String[0]).withAllDeprecated("validation_method");
    private static final ParseField COERCE_FIELD = new ParseField("coerce", "normalize").withAllDeprecated("validation_method");
    private static final ParseField SORTMODE_FIELD = new ParseField("mode", "sort_mode");
    private final String fieldName;
    private final List<GeoPoint> points = new ArrayList<GeoPoint>();
    private GeoDistance geoDistance = GeoDistance.ARC;
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private SortMode sortMode = null;
    private QueryBuilder nestedFilter;
    private String nestedPath;
    private GeoValidationMethod validation = DEFAULT_VALIDATION;

    public GeoDistanceSortBuilder(String fieldName, GeoPoint ... points) {
        this.fieldName = fieldName;
        if (points.length == 0) {
            throw new IllegalArgumentException("Geo distance sorting needs at least one point.");
        }
        this.points.addAll(Arrays.asList(points));
    }

    public GeoDistanceSortBuilder(String fieldName, double lat, double lon) {
        this(fieldName, new GeoPoint(lat, lon));
    }

    public GeoDistanceSortBuilder(String fieldName, String ... geohashes) {
        if (geohashes.length == 0) {
            throw new IllegalArgumentException("Geo distance sorting needs at least one point.");
        }
        for (String geohash : geohashes) {
            this.points.add(GeoPoint.fromGeohash(geohash));
        }
        this.fieldName = fieldName;
    }

    GeoDistanceSortBuilder(GeoDistanceSortBuilder original) {
        this.fieldName = original.fieldName();
        this.points.addAll(original.points);
        this.geoDistance = original.geoDistance;
        this.unit = original.unit;
        this.order = original.order;
        this.sortMode = original.sortMode;
        this.nestedFilter = original.nestedFilter;
        this.nestedPath = original.nestedPath;
        this.validation = original.validation;
    }

    public GeoDistanceSortBuilder(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        this.points.addAll((List)in.readGenericValue());
        this.geoDistance = GeoDistance.readFromStream(in);
        this.unit = DistanceUnit.readFromStream(in);
        this.order = SortOrder.readFromStream(in);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        this.nestedFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nestedPath = in.readOptionalString();
        this.validation = GeoValidationMethod.readFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.points);
        this.geoDistance.writeTo(out);
        this.unit.writeTo(out);
        this.order.writeTo(out);
        out.writeOptionalWriteable(this.sortMode);
        out.writeOptionalNamedWriteable(this.nestedFilter);
        out.writeOptionalString(this.nestedPath);
        this.validation.writeTo(out);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoDistanceSortBuilder point(double lat, double lon) {
        this.points.add(new GeoPoint(lat, lon));
        return this;
    }

    public GeoDistanceSortBuilder points(GeoPoint ... points) {
        this.points.addAll(Arrays.asList(points));
        return this;
    }

    public GeoPoint[] points() {
        return this.points.toArray(new GeoPoint[this.points.size()]);
    }

    @Deprecated
    public GeoDistanceSortBuilder geohashes(String ... geohashes) {
        for (String geohash : geohashes) {
            this.points.add(GeoPoint.fromGeohash(geohash));
        }
        return this;
    }

    public GeoDistanceSortBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public GeoDistanceSortBuilder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    public DistanceUnit unit() {
        return this.unit;
    }

    public GeoDistanceSortBuilder validation(GeoValidationMethod method) {
        this.validation = method;
        return this;
    }

    public GeoValidationMethod validation() {
        return this.validation;
    }

    public GeoDistanceSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null");
        if (sortMode == SortMode.SUM) {
            throw new IllegalArgumentException("sort_mode [sum] isn't supported for sorting by geo distance");
        }
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    public GeoDistanceSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        this.nestedFilter = nestedFilter;
        return this;
    }

    public QueryBuilder getNestedFilter() {
        return this.nestedFilter;
    }

    public GeoDistanceSortBuilder setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
        return this;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.startArray(this.fieldName);
        for (GeoPoint point : this.points) {
            builder.value(point);
        }
        builder.endArray();
        builder.field(UNIT_FIELD.getPreferredName(), this.unit);
        builder.field(DISTANCE_TYPE_FIELD.getPreferredName(), this.geoDistance.name().toLowerCase(Locale.ROOT));
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        if (this.sortMode != null) {
            builder.field(SORTMODE_FIELD.getPreferredName(), this.sortMode);
        }
        if (this.nestedPath != null) {
            builder.field(NESTED_PATH_FIELD.getPreferredName(), this.nestedPath);
        }
        if (this.nestedFilter != null) {
            builder.field(NESTED_FILTER_FIELD.getPreferredName(), this.nestedFilter, params);
        }
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), this.validation);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GeoDistanceSortBuilder other = (GeoDistanceSortBuilder)object;
        return Objects.equals(this.fieldName, other.fieldName) && Objects.deepEquals(this.points, other.points) && Objects.equals(this.geoDistance, other.geoDistance) && Objects.equals(this.unit, other.unit) && Objects.equals(this.sortMode, other.sortMode) && Objects.equals(this.order, other.order) && Objects.equals(this.nestedFilter, other.nestedFilter) && Objects.equals(this.nestedPath, other.nestedPath) && Objects.equals(this.validation, other.validation);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.points, this.geoDistance, this.unit, this.sortMode, this.order, this.nestedFilter, this.nestedPath, this.validation);
    }

    public static GeoDistanceSortBuilder fromXContent(QueryParseContext context, String elementName) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        String fieldName = null;
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance geoDistance = GeoDistance.ARC;
        SortOrder order = SortOrder.ASC;
        SortMode sortMode = null;
        Optional<Object> nestedFilter = Optional.empty();
        String nestedPath = null;
        boolean coerce = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        boolean ignoreMalformed = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        GeoValidationMethod validation = null;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            GeoPoint point;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                GeoDistanceSortBuilder.parseGeoPoints(parser, geoPoints);
                fieldName = currentName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (NESTED_FILTER_FIELD.match(currentName)) {
                    nestedFilter = context.parseInnerQueryBuilder();
                    continue;
                }
                if (fieldName != null && !fieldName.equals(currentName)) {
                    throw new ParsingException(parser.getTokenLocation(), "Trying to reset fieldName to [{}], already set to [{}].", currentName, fieldName);
                }
                fieldName = currentName;
                point = new GeoPoint();
                GeoUtils.parseGeoPoint(parser, point);
                geoPoints.add(point);
                continue;
            }
            if (!token.isValue()) continue;
            if (ORDER_FIELD.match(currentName)) {
                order = SortOrder.fromString(parser.text());
                continue;
            }
            if (UNIT_FIELD.match(currentName)) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (DISTANCE_TYPE_FIELD.match(currentName)) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (COERCE_FIELD.match(currentName)) {
                coerce = parser.booleanValue();
                if (!coerce) continue;
                ignoreMalformed = true;
                continue;
            }
            if (IGNORE_MALFORMED_FIELD.match(currentName)) {
                boolean ignore_malformed_value = parser.booleanValue();
                if (coerce) continue;
                ignoreMalformed = ignore_malformed_value;
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentName)) {
                validation = GeoValidationMethod.fromString(parser.text());
                continue;
            }
            if (SORTMODE_FIELD.match(currentName)) {
                sortMode = SortMode.fromString(parser.text());
                continue;
            }
            if (NESTED_PATH_FIELD.match(currentName)) {
                nestedPath = parser.text();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (fieldName != null && !fieldName.equals(currentName)) {
                    throw new ParsingException(parser.getTokenLocation(), "Trying to reset fieldName to [{}], already set to [{}].", currentName, fieldName);
                }
                point = new GeoPoint();
                point.resetFromString(parser.text());
                geoPoints.add(point);
                fieldName = currentName;
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Only geohashes of type string supported for field [{}]", currentName);
        }
        GeoDistanceSortBuilder result = new GeoDistanceSortBuilder(fieldName, geoPoints.toArray(new GeoPoint[geoPoints.size()]));
        result.geoDistance(geoDistance);
        result.unit(unit);
        result.order(order);
        if (sortMode != null) {
            result.sortMode(sortMode);
        }
        nestedFilter.ifPresent(result::setNestedFilter);
        result.setNestedPath(nestedPath);
        if (validation == null) {
            result.validation(GeoValidationMethod.infer(coerce, ignoreMalformed));
        } else {
            result.validation(validation);
        }
        return result;
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) throws IOException {
        boolean reverse;
        boolean indexCreatedBeforeV2_0 = context.indexVersionCreated().before(Version.V_2_0_0);
        final GeoPoint[] localPoints = this.points.toArray(new GeoPoint[this.points.size()]);
        if (!indexCreatedBeforeV2_0 && !GeoValidationMethod.isIgnoreMalformed(this.validation)) {
            for (GeoPoint point : localPoints) {
                if (!GeoUtils.isValidLatitude(point.lat())) {
                    throw new ElasticsearchParseException("illegal latitude value [{}] for [GeoDistanceSort] for field [{}].", point.lat(), this.fieldName);
                }
                if (GeoUtils.isValidLongitude(point.lon())) continue;
                throw new ElasticsearchParseException("illegal longitude value [{}] for [GeoDistanceSort] for field [{}].", point.lon(), this.fieldName);
            }
        }
        if (GeoValidationMethod.isCoerce(this.validation)) {
            for (GeoPoint point : localPoints) {
                GeoUtils.normalizePoint(point, true, true);
            }
        }
        boolean bl = reverse = this.order == SortOrder.DESC;
        final MultiValueMode finalSortMode = this.sortMode == null ? (reverse ? MultiValueMode.MAX : MultiValueMode.MIN) : MultiValueMode.fromString(this.sortMode.toString());
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            throw new IllegalArgumentException("failed to find mapper for [" + this.fieldName + "] for geo distance based sort");
        }
        final IndexGeoPointFieldData geoIndexFieldData = (IndexGeoPointFieldData)context.getForField(fieldType);
        final IndexFieldData.XFieldComparatorSource.Nested nested = GeoDistanceSortBuilder.resolveNested(context, this.nestedPath, this.nestedFilter);
        if (geoIndexFieldData.getClass() == AbstractLatLonPointDVIndexFieldData.LatLonPointDVIndexFieldData.class && nested == null && finalSortMode == MultiValueMode.MIN && this.unit == DistanceUnit.METERS && !reverse && localPoints.length == 1) {
            return new SortFieldAndFormat(LatLonDocValuesField.newDistanceSort(this.fieldName, localPoints[0].lat(), localPoints[0].lon()), DocValueFormat.RAW);
        }
        IndexFieldData.XFieldComparatorSource geoDistanceComparatorSource = new IndexFieldData.XFieldComparatorSource(){

            @Override
            public SortField.Type reducedType() {
                return SortField.Type.DOUBLE;
            }

            @Override
            public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
                return new FieldComparator.DoubleComparator(numHits, null, null){

                    @Override
                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        NumericDoubleValues selectedValues;
                        MultiGeoPointValues geoPointValues = ((AtomicGeoPointFieldData)geoIndexFieldData.load(context)).getGeoPointValues();
                        SortedNumericDoubleValues distanceValues = GeoUtils.distanceValues(GeoDistanceSortBuilder.this.geoDistance, GeoDistanceSortBuilder.this.unit, geoPointValues, localPoints);
                        if (nested == null) {
                            selectedValues = finalSortMode.select(distanceValues, Double.POSITIVE_INFINITY);
                        } else {
                            BitSet rootDocs = nested.rootDocs(context);
                            DocIdSetIterator innerDocs = nested.innerDocs(context);
                            selectedValues = finalSortMode.select(distanceValues, Double.POSITIVE_INFINITY, rootDocs, innerDocs, context.reader().maxDoc());
                        }
                        return selectedValues.getRawDoubleValues();
                    }
                };
            }
        };
        return new SortFieldAndFormat(new SortField(this.fieldName, geoDistanceComparatorSource, reverse), DocValueFormat.RAW);
    }

    static void parseGeoPoints(XContentParser parser, List<GeoPoint> geoPoints) throws IOException {
        while (!parser.nextToken().equals((Object)XContentParser.Token.END_ARRAY)) {
            if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                double lon = parser.doubleValue();
                parser.nextToken();
                if (!parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER)) {
                    throw new ElasticsearchParseException("geo point parsing: expected second number but got [{}] instead", new Object[]{parser.currentToken()});
                }
                double lat = parser.doubleValue();
                GeoPoint point = new GeoPoint();
                point.reset(lat, lon);
                geoPoints.add(point);
                continue;
            }
            GeoPoint point = new GeoPoint();
            GeoUtils.parseGeoPoint(parser, point);
            geoPoints.add(point);
        }
    }
}

