/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.ElSqlConfig;
import com.opengamma.elsql.EmptySqlParams;
import com.opengamma.elsql.MapSqlParams;
import com.opengamma.elsql.SqlFragments;
import com.opengamma.elsql.SqlParams;
import java.net.URL;
import java.util.Map;

public final class ElSql {
    private final SqlFragments _fragments;

    public static ElSql of(ElSqlConfig config, Class<?> type) {
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        URL baseResource = type.getResource(type.getSimpleName() + ".elsql");
        URL configResource = type.getResource(type.getSimpleName() + "-" + config.getName() + ".elsql");
        return ElSql.parse(config, baseResource, configResource);
    }

    public static ElSql parse(ElSqlConfig config, URL ... resources) {
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null");
        }
        if (resources == null) {
            throw new IllegalArgumentException("Resources must not be null");
        }
        return new ElSql(SqlFragments.parseResource(resources, config));
    }

    private ElSql(SqlFragments fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException("Fragment map must not be null");
        }
        this._fragments = fragments;
    }

    public ElSqlConfig getConfig() {
        return this._fragments.getConfig();
    }

    public ElSql withConfig(ElSqlConfig config) {
        return new ElSql(this._fragments.withConfig(config));
    }

    public String getSql(String name) {
        return this._fragments.getSql(name, EmptySqlParams.INSTANCE);
    }

    public String getSql(String name, SqlParams params) {
        return this._fragments.getSql(name, params);
    }

    public String getSql(String name, Map<String, Object> params) {
        return this._fragments.getSql(name, new MapSqlParams(params));
    }
}

