/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.SqlParams;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MapSqlParams
implements SqlParams {
    private final Map<String, Object> _map;

    public MapSqlParams(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        this._map = map;
    }

    public MapSqlParams(String key, Object value) {
        this._map = Collections.singletonMap(key, value);
    }

    public MapSqlParams with(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>(this._map);
        map.put(key, value);
        return new MapSqlParams(map);
    }

    @Override
    public boolean contains(String variable) {
        return this._map.containsKey(variable);
    }

    @Override
    public Object get(String variable) {
        return this._map.get(variable);
    }
}

