/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.ElSqlConfig;
import com.opengamma.elsql.ElSqlParser;
import com.opengamma.elsql.NameSqlFragment;
import com.opengamma.elsql.SqlParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class SqlFragments {
    private static final int[] NO_LOOP = new int[]{-1};
    private final Map<String, NameSqlFragment> _map;
    private final ElSqlConfig _config;

    static SqlFragments parseResource(URL[] resources, ElSqlConfig config) {
        ArrayList<List<String>> files = new ArrayList<List<String>>();
        boolean resourceFound = false;
        for (URL resource : resources) {
            if (resource == null) continue;
            resourceFound = true;
            List<String> lines = SqlFragments.loadResource(resource);
            files.add(lines);
        }
        if (!resourceFound) {
            throw new IllegalArgumentException("No matching resource was found");
        }
        return SqlFragments.parse(files, config);
    }

    static List<String> loadResource(URL resource) {
        InputStream in = null;
        try {
            in = resource.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            ArrayList<String> list = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                list.add(line);
                line = reader.readLine();
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    static SqlFragments parse(List<String> lines) {
        ArrayList<List<String>> files = new ArrayList<List<String>>();
        files.add(lines);
        return SqlFragments.parse(files, ElSqlConfig.DEFAULT);
    }

    static SqlFragments parse(List<List<String>> files, ElSqlConfig config) {
        LinkedHashMap<String, NameSqlFragment> parsed = new LinkedHashMap<String, NameSqlFragment>();
        for (List<String> lines : files) {
            ElSqlParser parser = new ElSqlParser(lines);
            parsed.putAll(parser.parse());
        }
        return new SqlFragments(parsed, config);
    }

    SqlFragments(Map<String, NameSqlFragment> map, ElSqlConfig config) {
        if (map == null) {
            throw new IllegalArgumentException("Fragment map must not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null");
        }
        this._map = map;
        this._config = config;
    }

    ElSqlConfig getConfig() {
        return this._config;
    }

    SqlFragments withConfig(ElSqlConfig config) {
        return new SqlFragments(this._map, config);
    }

    String getSql(String name, SqlParams params) {
        if (name == null) {
            throw new IllegalArgumentException("Fragment name must not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("SqlParams must not be null");
        }
        NameSqlFragment fragment = this.getFragment(name);
        StringBuilder buf = new StringBuilder(1024);
        fragment.toSQL(buf, this, params, NO_LOOP);
        return buf.toString();
    }

    NameSqlFragment getFragment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Fragment name must not be null");
        }
        NameSqlFragment fragment = this._map.get(name);
        if (fragment == null) {
            throw new IllegalArgumentException("Unknown fragment name: " + name);
        }
        return fragment;
    }
}

