/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringQuoteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.util.CompositeIterator;

public class DefaultSqlPrepareStatementStrategy
implements SqlPrepareStatementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSqlPrepareStatementStrategy.class);
    private static final Pattern REPLACE_IN_PATTERN = Pattern.compile("\\:\\?in\\:(\\w+|\\$\\{[^\\}]+\\}|\\$simple\\{[^\\}]+\\})", 8);
    private static final Pattern REPLACE_PATTERN = Pattern.compile("\\:\\?\\w+|\\:\\?\\$\\{[^\\}]+\\}|\\:\\?\\$simple\\{[^\\}]+\\}", 8);
    private static final Pattern NAME_PATTERN = Pattern.compile("\\:\\?((in\\:(\\w+|\\$\\{[^\\}]+\\}|\\$simple\\{[^\\}]+\\}))|(\\w+|\\$\\{[^\\}]+\\}|\\$simple\\{[^\\}]+\\}))", 8);
    private final char separator;

    public DefaultSqlPrepareStatementStrategy() {
        this(',');
    }

    public DefaultSqlPrepareStatementStrategy(char separator) {
        this.separator = separator;
    }

    @Override
    public String prepareQuery(String query2, boolean allowNamedParameters, Exchange exchange) throws SQLException {
        String answer;
        if (allowNamedParameters && this.hasNamedParameters(query2)) {
            if (exchange != null) {
                Matcher matcher = REPLACE_IN_PATTERN.matcher(query2);
                while (matcher.find()) {
                    String found = matcher.group(1);
                    Object parameter = DefaultSqlPrepareStatementStrategy.lookupParameter(found, exchange, exchange.getIn().getBody());
                    if (parameter == null) continue;
                    CompositeIterator it = DefaultSqlPrepareStatementStrategy.createInParameterIterator(parameter);
                    CollectionStringBuffer csb = new CollectionStringBuffer(",");
                    while (it.hasNext()) {
                        it.next();
                        csb.append((Object)"\\?");
                    }
                    String replace = csb.toString();
                    String foundEscaped = found.replace("$", "\\$").replace("{", "\\{").replace("}", "\\}");
                    Matcher paramMatcher = Pattern.compile("\\:\\?in\\:" + foundEscaped, 8).matcher(query2);
                    query2 = paramMatcher.replaceAll(replace);
                }
            }
            answer = REPLACE_PATTERN.matcher(query2).replaceAll("\\?");
        } else {
            answer = query2;
        }
        LOG.trace("Prepared query: {}", (Object)answer);
        return answer;
    }

    @Override
    public Iterator<?> createPopulateIterator(String query2, String preparedQuery, int expectedParams, Exchange exchange, Object value) throws SQLException {
        if (this.hasNamedParameters(query2)) {
            return new PopulateIterator(query2, exchange, value);
        }
        if (expectedParams == 1 && value instanceof String) {
            return Collections.singletonList(value).iterator();
        }
        if (value instanceof String) {
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)((String)value), (char)this.separator, (boolean)true);
            List<String> list = Arrays.asList(tokens);
            return list.iterator();
        }
        return (Iterator)exchange.getContext().getTypeConverter().convertTo(Iterator.class, value);
    }

    @Override
    public void populateStatement(PreparedStatement ps, Iterator<?> iterator, int expectedParams) throws SQLException {
        if (expectedParams <= 0) {
            return;
        }
        Object[] args = new Object[expectedParams];
        int i = 0;
        int argNumber = 1;
        while (iterator != null && iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof CompositeIterator) {
                Iterator it = (Iterator)value;
                while (it.hasNext()) {
                    Object val = it.next();
                    LOG.trace("Setting parameter #{} with value: {}", (Object)argNumber, val);
                    if (argNumber <= expectedParams) {
                        args[i] = val;
                    }
                    ++argNumber;
                    ++i;
                }
                continue;
            }
            LOG.trace("Setting parameter #{} with value: {}", (Object)argNumber, value);
            if (argNumber <= expectedParams) {
                args[i] = value;
            }
            ++argNumber;
            ++i;
        }
        if (argNumber - 1 != expectedParams) {
            throw new SQLException("Number of parameters mismatch. Expected: " + expectedParams + ", was: " + (argNumber - 1));
        }
        ArgumentPreparedStatementSetter setter = new ArgumentPreparedStatementSetter(args);
        setter.setValues(ps);
    }

    protected boolean hasNamedParameters(String query2) {
        NamedQueryParser parser = new NamedQueryParser(query2);
        return parser.next() != null;
    }

    protected static Object lookupParameter(String nextParam, Exchange exchange, Object body) {
        Map<?, ?> bodyMap = DefaultSqlPrepareStatementStrategy.safeMap((Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, body));
        Map<?, ?> headersMap = DefaultSqlPrepareStatementStrategy.safeMap(exchange.getIn().getHeaders());
        Object answer = null;
        if ((nextParam.startsWith("$simple{") || nextParam.startsWith("${")) && nextParam.endsWith("}")) {
            answer = SimpleLanguage.expression((String)nextParam).evaluate(exchange, Object.class);
        } else if (bodyMap.containsKey(nextParam)) {
            answer = bodyMap.get(nextParam);
        } else if (headersMap.containsKey(nextParam)) {
            answer = headersMap.get(nextParam);
        }
        return answer;
    }

    protected static boolean hasParameter(String nextParam, Exchange exchange, Object body) {
        Map<?, ?> bodyMap = DefaultSqlPrepareStatementStrategy.safeMap((Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, body));
        Map<?, ?> headersMap = DefaultSqlPrepareStatementStrategy.safeMap(exchange.getIn().getHeaders());
        if ((nextParam.startsWith("$simple{") || nextParam.startsWith("${")) && nextParam.endsWith("}")) {
            return true;
        }
        if (bodyMap.containsKey(nextParam)) {
            return true;
        }
        return headersMap.containsKey(nextParam);
    }

    private static Map<?, ?> safeMap(Map<?, ?> map) {
        return map == null || map.isEmpty() ? Collections.emptyMap() : map;
    }

    protected static CompositeIterator createInParameterIterator(Object value) {
        Iterator<String> it;
        if (value instanceof String) {
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)((String)value), (char)',', (boolean)true);
            List<String> list = Arrays.asList(tokens);
            it = list.iterator();
        } else {
            it = ObjectHelper.createIterator((Object)value, null);
        }
        CompositeIterator ci = new CompositeIterator();
        ci.add((Iterator)it);
        return ci;
    }

    private static final class PopulateIterator
    implements Iterator<Object> {
        private static final String MISSING_PARAMETER_EXCEPTION = "Cannot find key [%s] in message body or headers to use when setting named parameter in query [%s]";
        private final String query;
        private final NamedQueryParser parser;
        private final Exchange exchange;
        private final Object body;
        private String nextParam;

        private PopulateIterator(String query2, Exchange exchange, Object body) {
            this.query = query2;
            this.exchange = exchange;
            this.body = body;
            this.parser = new NamedQueryParser(query2);
            this.nextParam = this.parser.next();
        }

        @Override
        public boolean hasNext() {
            return this.nextParam != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() {
            Object next;
            block7: {
                if (this.nextParam == null) {
                    throw new NoSuchElementException();
                }
                boolean in = false;
                if (this.nextParam.startsWith("in:")) {
                    in = true;
                    this.nextParam = this.nextParam.substring(3);
                }
                next = null;
                try {
                    boolean hasNext = DefaultSqlPrepareStatementStrategy.hasParameter(this.nextParam, this.exchange, this.body);
                    if (hasNext) {
                        next = DefaultSqlPrepareStatementStrategy.lookupParameter(this.nextParam, this.exchange, this.body);
                        if (in && next != null) {
                            next = DefaultSqlPrepareStatementStrategy.createInParameterIterator(next);
                        }
                        break block7;
                    }
                    throw new RuntimeExchangeException(String.format(MISSING_PARAMETER_EXCEPTION, this.nextParam, this.query), this.exchange);
                }
                finally {
                    this.nextParam = this.parser.next();
                }
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class NamedQueryParser {
        private final Matcher matcher;

        private NamedQueryParser(String query2) {
            this.matcher = NAME_PATTERN.matcher(query2);
        }

        public String next() {
            if (this.matcher.find()) {
                return this.matcher.group(1);
            }
            return null;
        }
    }
}

