/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.sql.stored.template.ast.InParameter;
import org.apache.camel.component.sql.stored.template.ast.Template;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.CallableStatementCreatorFactory;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.StatementCreatorUtils;

public class BatchCallableStatementCreatorFactory {
    final CallableStatementCreatorFactory callableStatementCreatorFactory;
    final List<SqlParameter> sqlParameterList;
    final Template template;

    public BatchCallableStatementCreatorFactory(Template template) {
        this.template = template;
        this.sqlParameterList = this.createParams();
        this.callableStatementCreatorFactory = new CallableStatementCreatorFactory(this.formatSql(), this.createParams());
    }

    public void addParameter(CallableStatement callableStatement, Map batchRow) throws SQLException {
        int i = 1;
        for (SqlParameter parameter : this.getSqlParameterList()) {
            StatementCreatorUtils.setParameterValue((PreparedStatement)callableStatement, i, parameter, batchRow.get(parameter.getName()));
            ++i;
        }
    }

    private String formatSql() {
        return "{call " + this.template.getProcedureName() + "(" + this.repeatParameter(this.template.getParameterList().size()) + ")}";
    }

    private String repeatParameter(int size) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            ret.append('?');
            if (i + 1 >= size) continue;
            ret.append(',');
        }
        return ret.toString();
    }

    private List<SqlParameter> createParams() {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        for (Object parameter : this.template.getParameterList()) {
            if (parameter instanceof InParameter) {
                InParameter inputParameter = (InParameter)parameter;
                SqlParameter sqlParameter = inputParameter.getScale() != null ? new SqlParameter(inputParameter.getName(), inputParameter.getSqlType(), inputParameter.getScale()) : (inputParameter.getTypeName() != null ? new SqlParameter(inputParameter.getName(), inputParameter.getSqlType(), inputParameter.getTypeName()) : new SqlParameter(inputParameter.getName(), inputParameter.getSqlType()));
                params.add(sqlParameter);
                continue;
            }
            throw new UnsupportedOperationException("Only IN parameters supported by batch!");
        }
        return params;
    }

    public CallableStatementCreator newCallableStatementCreator(Map<String, ?> params) {
        return this.callableStatementCreatorFactory.newCallableStatementCreator(params);
    }

    public List<SqlParameter> getSqlParameterList() {
        return this.sqlParameterList;
    }

    public Template getTemplate() {
        return this.template;
    }
}

