/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elsql;

import com.opengamma.elsql.ElSql;
import com.opengamma.elsql.SpringSqlParams;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.camel.Exchange;
import org.apache.camel.component.elsql.ElsqlSqlMapSource;
import org.apache.camel.component.sql.DefaultSqlEndpoint;
import org.apache.camel.component.sql.SqlNamedProcessingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ElsqlSqlProcessingStrategy
implements SqlNamedProcessingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ElsqlSqlProcessingStrategy.class);
    private final ElSql elSql;

    public ElsqlSqlProcessingStrategy(ElSql elSql) {
        this.elSql = elSql;
    }

    @Override
    public int commit(DefaultSqlEndpoint defaultSqlEndpoint, Exchange exchange, Object data, NamedParameterJdbcTemplate jdbcTemplate, SqlParameterSource parameterSource, String query2) throws Exception {
        ElsqlSqlMapSource param = new ElsqlSqlMapSource(exchange, data);
        String sql = this.elSql.getSql(query2, new SpringSqlParams(param));
        LOG.debug("commit @{} using sql: {}", (Object)query2, (Object)sql);
        return jdbcTemplate.execute(sql, param, new PreparedStatementCallback<Integer>(){

            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ps.execute();
                int updateCount = ps.getUpdateCount();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Update count {}", (Object)updateCount);
                }
                return updateCount;
            }
        });
    }

    @Override
    public int commitBatchComplete(DefaultSqlEndpoint endpoint, NamedParameterJdbcTemplate namedJdbcTemplate, SqlParameterSource parameterSource, String query2) throws Exception {
        EmptySqlParameterSource param = new EmptySqlParameterSource();
        String sql = this.elSql.getSql(query2, new SpringSqlParams(param));
        LOG.debug("commitBatchComplete @{} using sql: {}", (Object)query2, (Object)sql);
        return namedJdbcTemplate.execute(sql, param, new PreparedStatementCallback<Integer>(){

            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ps.execute();
                int updateCount = ps.getUpdateCount();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Update count {}", (Object)updateCount);
                }
                return updateCount;
            }
        });
    }

    @Override
    public int commit(DefaultSqlEndpoint defaultSqlEndpoint, Exchange exchange, Object data, JdbcTemplate jdbcTemplate, String query2) throws Exception {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public int commitBatchComplete(DefaultSqlEndpoint defaultSqlEndpoint, JdbcTemplate jdbcTemplate, String query2) throws Exception {
        throw new UnsupportedOperationException("Should not be called");
    }
}

