/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elytron;

import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.security.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.elytron.ElytronSercurityConfiguration;
import org.apache.camel.component.undertow.spi.UndertowSecurityProvider;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronRunAsHandler;
import org.wildfly.security.WildFlyElytronBaseProvider;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.http.HttpAuthenticationFactory;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.SecurityProviderServerMechanismFactory;

public class ElytronSecurityProvider
implements UndertowSecurityProvider {
    public static final String SECURITY_IDENTITY_HEADER = "securityIdentity";
    private SecurityDomain securityDomain;
    private WildFlyElytronBaseProvider elytronProvider;
    private String mechanismName;

    @Override
    public void addHeader(BiConsumer<String, Object> consumer, HttpServerExchange httpExchange) throws Exception {
        SecurityIdentity securityIdentity = this.securityDomain.getCurrentSecurityIdentity();
        consumer.accept(SECURITY_IDENTITY_HEADER, securityIdentity);
    }

    @Override
    public int authenticate(HttpServerExchange httpExchange, List<String> allowedRoles) throws Exception {
        SecurityIdentity identity = this.securityDomain.getCurrentSecurityIdentity();
        if (identity != null) {
            HashSet<String> roles = new HashSet<String>();
            Roles identityRoles = identity.getRoles();
            if (identityRoles != null) {
                for (String roleName : identityRoles) {
                    roles.add(roleName);
                }
            }
            if (this.isAllowed(roles, allowedRoles)) {
                return 200;
            }
        }
        return 403;
    }

    @Override
    public boolean acceptConfiguration(Object configuration, String endpointUri) throws Exception {
        if (configuration instanceof ElytronSercurityConfiguration) {
            ElytronSercurityConfiguration conf = (ElytronSercurityConfiguration)configuration;
            this.securityDomain = conf.getDomainBuilder().build();
            this.mechanismName = conf.getMechanismName();
            this.elytronProvider = conf.getElytronProvider();
            return true;
        }
        return false;
    }

    @Override
    public HttpHandler wrapHttpHandler(HttpHandler httpHandler) throws Exception {
        HttpAuthenticationFactory httpAuthenticationFactory = this.createHttpAuthenticationFactory(this.securityDomain);
        HttpHandler rootHandler = new ElytronRunAsHandler(httpHandler);
        rootHandler = new AuthenticationCallHandler(rootHandler);
        rootHandler = new AuthenticationConstraintHandler(rootHandler);
        return ElytronContextAssociationHandler.builder().setNext(rootHandler).setMechanismSupplier(() -> {
            try {
                return Collections.singletonList((HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(this.mechanismName));
            }
            catch (HttpAuthenticationException e) {
                throw new RuntimeCamelException(e);
            }
        }).build();
    }

    private HttpAuthenticationFactory createHttpAuthenticationFactory(SecurityDomain securityDomain) {
        SecurityProviderServerMechanismFactory providerFactory = new SecurityProviderServerMechanismFactory(() -> new Provider[]{this.elytronProvider});
        FilterServerMechanismFactory httpServerMechanismFactory = new FilterServerMechanismFactory((HttpServerAuthenticationMechanismFactory)providerFactory, true, this.mechanismName);
        return HttpAuthenticationFactory.builder().setSecurityDomain(securityDomain).setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector(MechanismConfiguration.builder().addMechanismRealm(MechanismRealmConfiguration.builder().setRealmName("Elytron Realm").build()).build())).setFactory(httpServerMechanismFactory).build();
    }

    public boolean isAllowed(Set<String> roles, List<String> allowedRoles) {
        for (String role : allowedRoles) {
            if (!roles.contains(role)) continue;
            return true;
        }
        return false;
    }
}

