/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.component.properties.EnvPropertiesFunction;
import org.apache.camel.component.properties.PropertiesFunctionResolver;
import org.apache.camel.component.properties.ServiceHostPropertiesFunction;
import org.apache.camel.component.properties.ServicePortPropertiesFunction;
import org.apache.camel.component.properties.ServicePropertiesFunction;
import org.apache.camel.component.properties.SysPropertiesFunction;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesFunctionResolver
extends ServiceSupport
implements PropertiesFunctionResolver,
CamelContextAware,
NonManagedService,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPropertiesFunctionResolver.class);
    private CamelContext camelContext;
    private FactoryFinder factoryFinder;
    private final Map<String, PropertiesFunction> functions = new LinkedHashMap<String, PropertiesFunction>();

    public DefaultPropertiesFunctionResolver() {
        this.addPropertiesFunction(new EnvPropertiesFunction());
        this.addPropertiesFunction(new SysPropertiesFunction());
        this.addPropertiesFunction(new ServicePropertiesFunction());
        this.addPropertiesFunction(new ServiceHostPropertiesFunction());
        this.addPropertiesFunction(new ServicePortPropertiesFunction());
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void addPropertiesFunction(PropertiesFunction function) {
        this.functions.put(function.getName(), function);
    }

    @Override
    public Map<String, PropertiesFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public boolean hasFunction(String name) {
        return this.functions.containsKey(name);
    }

    @Override
    public PropertiesFunction resolvePropertiesFunction(String name) {
        PropertiesFunction answer = this.functions.get(name);
        if (answer == null && (answer = this.resolve(this.camelContext, name)) != null) {
            this.functions.put(name, answer);
        }
        return answer;
    }

    private PropertiesFunction resolve(CamelContext context, String name) {
        Class<?> type = null;
        try {
            type = this.findFactory(name, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found PropertiesFunction: {} via: {}{}", type.getName(), this.factoryFinder.getResourcePath(), name);
            }
            if (PropertiesFunction.class.isAssignableFrom(type)) {
                PropertiesFunction answer = (PropertiesFunction)context.getInjector().newInstance(type, false);
                CamelContextAware.trySetCamelContext(answer, this.camelContext);
                ServiceHelper.startService((Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a PropertiesFunction implementation. Found: " + type.getName());
        }
        return null;
    }

    private Class<?> findFactory(String name, CamelContext context) {
        if (this.factoryFinder == null) {
            this.factoryFinder = context.adapt(ExtendedCamelContext.class).getFactoryFinder("META-INF/services/org/apache/camel/properties-function/");
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService(this.functions.values());
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.functions.values());
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.functions.values());
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.functions.values());
    }
}

