/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLRUCacheFactory
extends LRUCacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLRUCacheFactory.class);

    @Override
    public <K, V> Map<K, V> createLRUCache(int maximumCacheSize) {
        LOG.trace("Creating LRUCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new SimpleLRUCache(maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int maximumCacheSize, Consumer<V> onEvict) {
        LOG.trace("Creating LRUCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new SimpleLRUCache(16, maximumCacheSize, onEvict);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", initialCapacity, maximumCacheSize, stopOnEviction);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int maximumCacheSize) {
        LOG.trace("Creating LRUSoftCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new SimpleLRUCache(maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", initialCapacity, maximumCacheSize, stopOnEviction);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    @Override
    public <K, V> Map<K, V> createLRUWeakCache(int maximumCacheSize) {
        LOG.trace("Creating LRUWeakCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new SimpleLRUCache(maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUWeakCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUWeakCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", initialCapacity, maximumCacheSize, stopOnEviction);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    <V> void doNothing(V value) {
    }

    <V> void doStop(V value) {
        try {
            ServiceHelper.stopService(value);
        }
        catch (Exception e) {
            LOG.warn("Error stopping service: {}. This exception will be ignored.", (Object)value, (Object)e);
        }
    }

    private class SimpleLRUCache<K, V>
    extends LinkedHashMap<K, V> {
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final int maximumCacheSize;
        private final Consumer<V> evict;

        public SimpleLRUCache(int maximumCacheSize) {
            this(16, maximumCacheSize, maximumCacheSize > 0);
        }

        public SimpleLRUCache(int initialCapacity, int maximumCacheSize) {
            this(initialCapacity, maximumCacheSize, maximumCacheSize > 0);
        }

        public SimpleLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
            this(initialCapacity, maximumCacheSize, stopOnEviction ? defaultLRUCacheFactory::doStop : defaultLRUCacheFactory::doNothing);
        }

        public SimpleLRUCache(int initialCapacity, int maximumCacheSize, Consumer<V> evicted) {
            super(initialCapacity, 0.75f, true);
            this.maximumCacheSize = maximumCacheSize;
            this.evict = Objects.requireNonNull(evicted);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() > this.maximumCacheSize) {
                V value = eldest.getValue();
                this.evict.accept(value);
                return true;
            }
            return false;
        }
    }
}

