/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.component.ApiMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiMethodHelper<T extends Enum<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(ApiMethodHelper.class);
    private final Map<String, List<T>> methodMap;
    private final Map<String, List<Object>> argumentsMap;
    private final Map<String, Class<?>> validArguments;
    private final Map<String, Set<String>> aliasesMap;
    private final List<String> nullableArguments;

    public ApiMethodHelper(Class<T> apiMethodEnum, Map<String, String> aliases, List<String> nullableArguments) {
        Enum[] methods;
        HashMap<String, ArrayList<Enum>> tmpMethodMap = new HashMap<String, ArrayList<Enum>>();
        HashMap tmpArgumentsMap = new HashMap();
        HashMap<String, Class> tmpValidArguments = new HashMap<String, Class>();
        HashMap<String, HashSet<String>> tmpAliasesMap = new HashMap<String, HashSet<String>>();
        if (apiMethodEnum == null) {
            throw new IllegalArgumentException("ApiMethod enumeration cannot be null");
        }
        this.nullableArguments = nullableArguments != null && !nullableArguments.isEmpty() ? Collections.unmodifiableList(new ArrayList<String>(nullableArguments)) : Collections.emptyList();
        HashMap<Pattern, String> aliasPatterns = new HashMap<Pattern, String>();
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("Alias pattern and replacement cannot be null");
            }
            aliasPatterns.put(Pattern.compile(entry.getKey()), entry.getValue());
        }
        LOG.debug("Processing {}", (Object)apiMethodEnum.getName());
        for (Enum method : methods = (Enum[])apiMethodEnum.getEnumConstants()) {
            String name = ((ApiMethod)((Object)method)).getName();
            for (Map.Entry aliasEntry : aliasPatterns.entrySet()) {
                HashSet<String> names;
                Matcher matcher = ((Pattern)aliasEntry.getKey()).matcher(name);
                if (!matcher.find()) continue;
                String alias = matcher.replaceAll((String)aliasEntry.getValue());
                assert (alias.length() > 1);
                char firstChar = alias.charAt(0);
                if (!Character.isLowerCase(firstChar)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(Character.toLowerCase(firstChar)).append(alias, 1, alias.length());
                    alias = builder.toString();
                }
                if ((names = (HashSet<String>)tmpAliasesMap.get(alias)) == null) {
                    names = new HashSet<String>();
                    tmpAliasesMap.put(alias, names);
                }
                names.add(name);
            }
            ArrayList<Enum> overloads = (ArrayList<Enum>)tmpMethodMap.get(name);
            if (overloads == null) {
                overloads = new ArrayList<Enum>();
                tmpMethodMap.put(((ApiMethod)((Object)method)).getName(), overloads);
            }
            overloads.add(method);
            ArrayList<Object> arguments = (ArrayList<Object>)tmpArgumentsMap.get(name);
            if (arguments == null) {
                arguments = new ArrayList<Object>();
                tmpArgumentsMap.put(name, arguments);
            }
            int nArgs = ((ApiMethod)((Object)method)).getArgNames().size();
            String[] argNames = ((ApiMethod)((Object)method)).getArgNames().toArray(new String[nArgs]);
            Class[] argTypes = ((ApiMethod)((Object)method)).getArgTypes().toArray(new Class[nArgs]);
            for (int i = 0; i < nArgs; ++i) {
                Class previousType;
                String argName = argNames[i];
                Class argType = argTypes[i];
                if (!arguments.contains(argName)) {
                    arguments.add(argType);
                    arguments.add(argName);
                }
                if ((previousType = (Class)tmpValidArguments.get(argName)) != null && previousType != argType) {
                    throw new IllegalArgumentException(String.format("Argument %s has ambiguous types (%s, %s) across methods!", name, previousType, argType));
                }
                if (previousType != null) continue;
                tmpValidArguments.put(argName, argType);
            }
        }
        if (!tmpValidArguments.keySet().containsAll(this.nullableArguments)) {
            ArrayList<String> arrayList = new ArrayList<String>(this.nullableArguments);
            arrayList.removeAll(tmpValidArguments.keySet());
            throw new IllegalArgumentException("Unknown nullable arguments " + ((Object)arrayList).toString());
        }
        for (Map.Entry entry : tmpAliasesMap.entrySet()) {
            Set methodNames = (Set)entry.getValue();
            if (methodNames.size() <= 1) continue;
            ArrayList aliasedMethods = new ArrayList();
            for (String methodName : methodNames) {
                List mappedMethods = (List)tmpMethodMap.get(methodName);
                aliasedMethods.addAll(mappedMethods);
            }
            for (Enum method : aliasedMethods) {
                ArrayList<String> argNames = new ArrayList<String>(((ApiMethod)((Object)method)).getArgNames());
                argNames.removeAll(this.nullableArguments);
                HashSet<Enum> ambiguousMethods = new HashSet<Enum>();
                for (Enum otherMethod : aliasedMethods) {
                    if (method == otherMethod) continue;
                    ArrayList<String> otherArgsNames = new ArrayList<String>(((ApiMethod)((Object)otherMethod)).getArgNames());
                    otherArgsNames.removeAll(this.nullableArguments);
                    if (!argNames.equals(otherArgsNames)) continue;
                    ambiguousMethods.add(method);
                    ambiguousMethods.add(otherMethod);
                }
                if (ambiguousMethods.isEmpty()) continue;
                throw new IllegalArgumentException(String.format("Ambiguous alias %s for methods %s", entry.getKey(), ambiguousMethods));
            }
        }
        this.methodMap = Collections.unmodifiableMap(tmpMethodMap);
        this.argumentsMap = Collections.unmodifiableMap(tmpArgumentsMap);
        this.validArguments = Collections.unmodifiableMap(tmpValidArguments);
        this.aliasesMap = Collections.unmodifiableMap(tmpAliasesMap);
        LOG.debug("Found {} unique method names in {} methods", (Object)tmpMethodMap.size(), (Object)methods.length);
    }

    public List<ApiMethod> getCandidateMethods(String name) {
        return this.getCandidateMethods(name, Collections.emptyList());
    }

    public List<ApiMethod> getCandidateMethods(String name, Collection<String> argNames) {
        int nArgs;
        List<T> methods = this.methodMap.get(name);
        if (methods == null && this.aliasesMap.containsKey(name)) {
            methods = new ArrayList<T>();
            for (String method : this.aliasesMap.get(name)) {
                methods.addAll((Collection)this.methodMap.get(method));
            }
        }
        if (methods == null) {
            LOG.debug("No matching method for method {}", (Object)name);
            return Collections.emptyList();
        }
        int n = nArgs = argNames != null ? argNames.size() : 0;
        if (nArgs == 0) {
            LOG.debug("Found {} methods for method {}", (Object)methods.size(), (Object)name);
            return Collections.unmodifiableList(methods);
        }
        List<ApiMethod> filteredSet = this.filterMethods(methods, MatchType.SUBSET, argNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} filtered methods for {}", (Object)filteredSet.size(), (Object)(name + argNames.toString().replace('[', '(').replace(']', ')')));
        }
        return filteredSet;
    }

    public List<ApiMethod> filterMethods(List<? extends ApiMethod> methods, MatchType matchType) {
        return this.filterMethods(methods, matchType, Collections.emptyList());
    }

    public List<ApiMethod> filterMethods(List<? extends ApiMethod> methods, MatchType matchType, Collection<String> argNames) {
        ArrayList<String> withNullableArgsList;
        if (!this.nullableArguments.isEmpty()) {
            withNullableArgsList = new ArrayList<String>(argNames);
            withNullableArgsList.addAll(this.nullableArguments);
        } else {
            withNullableArgsList = null;
        }
        ArrayList<ApiMethod> result = new ArrayList<ApiMethod>();
        ArrayList<ApiMethod> extraArgs = null;
        ArrayList<ApiMethod> nullArgs = null;
        block4: for (ApiMethod apiMethod : methods) {
            List<String> methodArgs = apiMethod.getArgNames();
            switch (matchType) {
                case EXACT: {
                    if (!methodArgs.containsAll(argNames) || !argNames.containsAll(methodArgs)) continue block4;
                    result.add(apiMethod);
                    continue block4;
                }
                case SUBSET: {
                    if (!methodArgs.containsAll(argNames)) continue block4;
                    result.add(apiMethod);
                    continue block4;
                }
            }
            if (argNames.containsAll(methodArgs)) {
                if (methodArgs.containsAll(argNames)) {
                    result.add(apiMethod);
                    continue;
                }
                if (!result.isEmpty()) continue;
                if (extraArgs == null) {
                    extraArgs = new ArrayList<ApiMethod>();
                }
                extraArgs.add(apiMethod);
                continue;
            }
            if (!result.isEmpty() || extraArgs != null || withNullableArgsList == null || !withNullableArgsList.containsAll(methodArgs)) continue;
            if (nullArgs == null) {
                nullArgs = new ArrayList<ApiMethod>();
            }
            nullArgs.add(apiMethod);
        }
        ArrayList<ApiMethod> methodList = result.isEmpty() ? (extraArgs == null ? nullArgs : extraArgs) : result;
        return methodList != null ? Collections.unmodifiableList(methodList) : Collections.emptyList();
    }

    public List<Object> getArguments(String name) throws IllegalArgumentException {
        List<Object> arguments = this.argumentsMap.get(name);
        if (arguments == null && this.aliasesMap.containsKey(name)) {
            arguments = new ArrayList<Object>();
            for (String method : this.aliasesMap.get(name)) {
                arguments.addAll((Collection<Object>)this.argumentsMap.get(method));
            }
        }
        if (arguments == null) {
            throw new IllegalArgumentException(name);
        }
        return Collections.unmodifiableList(arguments);
    }

    public Set<String> getMissingProperties(String methodName, Set<String> argNames) {
        List<Object> argsWithTypes = this.getArguments(methodName);
        HashSet<String> missingArgs = new HashSet<String>();
        for (int i = 1; i < argsWithTypes.size(); i += 2) {
            String name = (String)argsWithTypes.get(i);
            if (argNames.contains(name)) continue;
            missingArgs.add(name);
        }
        return missingArgs;
    }

    public Map<String, Set<String>> getAliases() {
        return this.aliasesMap;
    }

    public Map<String, Class<?>> allArguments() {
        return this.validArguments;
    }

    public List<String> getNullableArguments() {
        return this.nullableArguments;
    }

    public Class<?> getType(String argName) throws IllegalArgumentException {
        Class<?> type = this.validArguments.get(argName);
        if (type == null) {
            throw new IllegalArgumentException(argName);
        }
        return type;
    }

    public static ApiMethod getHighestPriorityMethod(List<? extends ApiMethod> filteredMethods) {
        Comparable highest = null;
        for (ApiMethod apiMethod : filteredMethods) {
            if (highest != null && highest.compareTo(apiMethod) > 0) continue;
            highest = (Comparable)((Object)apiMethod);
        }
        return (ApiMethod)((Object)highest);
    }

    public static Object invokeMethod(Object proxy, ApiMethod method, Map<String, Object> properties) throws RuntimeCamelException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking {} with arguments {}", (Object)method.getName(), (Object)properties);
        }
        List<String> argNames = method.getArgNames();
        Object[] values = new Object[argNames.size()];
        List<Class<?>> argTypes = method.getArgTypes();
        Class[] types = argTypes.toArray(new Class[argTypes.size()]);
        int index = 0;
        for (String name : argNames) {
            Object value = properties.get(name);
            if (value != null && types[index].isArray()) {
                int i;
                Object array;
                Class type = types[index];
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    array = Array.newInstance(type.getComponentType(), collection.size());
                    if (array instanceof Object[]) {
                        collection.toArray((Object[])array);
                    } else {
                        i = 0;
                        for (Object el : collection) {
                            Array.set(array, i++, el);
                        }
                    }
                    value = array;
                } else if (value.getClass().isArray() && type.getComponentType().isAssignableFrom(value.getClass().getComponentType())) {
                    if (type.getComponentType() != value.getClass().getComponentType()) {
                        int size = Array.getLength(value);
                        array = Array.newInstance(type.getComponentType(), size);
                        for (i = 0; i < size; ++i) {
                            Array.set(array, i, Array.get(value, i));
                        }
                        value = array;
                    }
                } else {
                    throw new IllegalArgumentException(String.format("Cannot convert %s to %s", value.getClass(), type));
                }
            }
            values[index++] = value;
        }
        try {
            return method.getMethod().invoke(proxy, values);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            String message = cause != null ? cause.getMessage() : e.getMessage();
            throw new RuntimeCamelException(String.format("Error invoking %s with %s: %s", method.getName(), properties, message), cause != null ? cause : e);
        }
        catch (Throwable e) {
            throw new RuntimeCamelException(String.format("Error invoking %s with %s: %s", method.getName(), properties, e.getMessage()), e);
        }
    }

    public static enum MatchType {
        EXACT,
        SUBSET,
        SUPER_SET;

    }
}

