/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizedScheduledExecutorService
implements ScheduledExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(SizedScheduledExecutorService.class);
    private final ScheduledThreadPoolExecutor delegate;
    private final long queueSize;

    public SizedScheduledExecutorService(ScheduledThreadPoolExecutor delegate, long queueSize) {
        this.delegate = delegate;
        this.queueSize = queueSize;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.delegate;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit timeUnit) {
        if (this.canScheduleOrExecute()) {
            return this.delegate.schedule(task, delay, timeUnit);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit timeUnit) {
        if (this.canScheduleOrExecute()) {
            return this.delegate.schedule(task, delay, timeUnit);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit timeUnit) {
        if (this.canScheduleOrExecute()) {
            return this.delegate.scheduleAtFixedRate(task, initialDelay, period, timeUnit);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long period, TimeUnit timeUnit) {
        if (this.canScheduleOrExecute()) {
            return this.delegate.scheduleWithFixedDelay(task, initialDelay, period, timeUnit);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, timeUnit);
    }

    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    public long getCompletedTaskCount() {
        return this.delegate.getCompletedTaskCount();
    }

    public int getCorePoolSize() {
        return this.delegate.getCorePoolSize();
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return this.delegate.getKeepAliveTime(timeUnit);
    }

    public int getLargestPoolSize() {
        return this.delegate.getLargestPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.delegate.getMaximumPoolSize();
    }

    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.delegate.getRejectedExecutionHandler();
    }

    public long getTaskCount() {
        return this.delegate.getTaskCount();
    }

    public ThreadFactory getThreadFactory() {
        return this.delegate.getThreadFactory();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (this.canScheduleOrExecute()) {
            return this.delegate.invokeAll(tasks);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.canScheduleOrExecute()) {
            return this.delegate.invokeAll(tasks, timeout, timeUnit);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (this.canScheduleOrExecute()) {
            return this.delegate.invokeAny(tasks);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.canScheduleOrExecute()) {
            return this.delegate.invokeAny(tasks, timeout, timeUnit);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean isTerminating() {
        return this.delegate.isTerminating();
    }

    public int prestartAllCoreThreads() {
        return this.delegate.prestartAllCoreThreads();
    }

    public boolean prestartCoreThread() {
        return this.delegate.prestartCoreThread();
    }

    public void purge() {
        this.delegate.purge();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.delegate.setCorePoolSize(corePoolSize);
    }

    public void setKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.delegate.setKeepAliveTime(keepAliveTime, timeUnit);
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.delegate.setMaximumPoolSize(maximumPoolSize);
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.delegate.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.delegate.setThreadFactory(threadFactory);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this.canScheduleOrExecute()) {
            return this.delegate.submit(task);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.canScheduleOrExecute()) {
            return this.delegate.submit(task);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (this.canScheduleOrExecute()) {
            return this.delegate.submit(task, result);
        }
        throw new RejectedExecutionException("Task rejected due queue size limit reached");
    }

    @Override
    public void execute(Runnable task) {
        if (!this.canScheduleOrExecute()) {
            throw new RejectedExecutionException("Task rejected due queue size limit reached");
        }
        this.delegate.execute(task);
    }

    public void allowCoreThreadTimeOut(boolean value) {
        this.delegate.allowCoreThreadTimeOut(value);
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.delegate.allowsCoreThreadTimeOut();
    }

    protected boolean canScheduleOrExecute() {
        boolean answer;
        if (this.queueSize <= 0L) {
            return true;
        }
        int size = this.delegate.getQueue().size();
        boolean bl = answer = (long)size < this.queueSize;
        if (LOG.isTraceEnabled()) {
            LOG.trace("canScheduleOrExecute {} < {} -> {}", size, this.queueSize, answer);
        }
        return answer;
    }

    public String toString() {
        if (this.delegate.getThreadFactory() instanceof CamelThreadFactory) {
            String name = ((CamelThreadFactory)this.delegate.getThreadFactory()).getName();
            return super.toString() + "[" + name + "]";
        }
        return super.toString();
    }
}

