/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.undertow.util.Headers;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Date;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.wildfly.elytron.web.undertow.common.AbstractHttpServerMechanismTest;
import org.wildfly.elytron.web.undertow.common.UndertowServer;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.permission.PermissionVerifier;

public abstract class BearerTokenAuthenticationBase
extends AbstractHttpServerMechanismTest {
    @Rule
    public UndertowServer server = this.createUndertowServer();
    private KeyPair keyPair;

    protected BearerTokenAuthenticationBase() throws Exception {
    }

    @Test
    public void testNoBearerToken() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri());
        HttpResponse result = httpClient.execute(get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"Bearer realm=\"Elytron Realm\"", (Object)result.getFirstHeader("WWW-Authenticate").getValue());
    }

    @Test
    public void testSuccessfulAuthentication() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri());
        this.setBearerToken(get, this.createToken("alice", new Date(new Date().getTime() + 10000L)));
        HttpResponse result = httpClient.execute(get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        this.assertSuccessfulResponse(result, "alice");
    }

    @Test
    public void testTokenWithInvalidExpirationTime() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri());
        this.setBearerToken(get, this.createToken("alice", new Date(new Date().getTime() - 10000L)));
        HttpResponse result = httpClient.execute(get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
    }

    @Test
    public void testTokenWithInvalidSignature() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri());
        this.setBearerToken(get, this.createToken("alice", new Date(new Date().getTime() + 10000L), this.generateKeyPair().getPrivate()));
        HttpResponse result = httpClient.execute(get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
    }

    @Override
    protected String getMechanismName() {
        return "BEARER_TOKEN";
    }

    @Override
    protected SecurityDomain doCreateSecurityDomain() throws Exception {
        SecurityDomain.Builder builder = SecurityDomain.builder().setDefaultRealmName("TestRealm");
        builder.addRealm("TestRealm", TokenSecurityRealm.builder().principalClaimName("username").validator(JwtValidator.builder().publicKey(this.getKeyPair().getPublic()).build()).build()).build();
        builder.setPermissionMapper((principal, roles) -> PermissionVerifier.from(new LoginPermission()));
        return builder.build();
    }

    private void setBearerToken(HttpGet get, String token) throws JOSEException {
        get.addHeader(Headers.AUTHORIZATION.toString(), "Bearer " + token);
    }

    private String createToken(String userName, Date expirationDate) throws JOSEException, NoSuchAlgorithmException {
        return this.createToken(userName, expirationDate, this.getKeyPair().getPrivate());
    }

    private String createToken(String userName, Date expirationDate, PrivateKey signingKey) throws JOSEException, NoSuchAlgorithmException {
        JWTClaimsSet.Builder claimsSet = new JWTClaimsSet.Builder();
        claimsSet.subject("123445667");
        claimsSet.claim("username", userName);
        claimsSet.audience("resource-server");
        claimsSet.issuer("elytron.org");
        claimsSet.expirationTime(expirationDate);
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet.build());
        signedJWT.sign(new RSASSASigner(signingKey));
        return signedJWT.serialize();
    }

    private KeyPair getKeyPair() throws NoSuchAlgorithmException {
        if (this.keyPair == null) {
            this.keyPair = this.generateKeyPair();
        }
        return this.keyPair;
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance("RSA").generateKeyPair();
    }

    protected abstract UndertowServer createUndertowServer() throws Exception;
}

