/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.idm.Account;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;

public class ElytronAccount
implements Account {
    private final SecurityIdentity securityIdentity;
    private final Set<String> roles;

    private ElytronAccount(SecurityIdentity securityIdentity, Roles roles) {
        this.securityIdentity = securityIdentity;
        this.roles = Collections.unmodifiableSet(StreamSupport.stream(roles.spliterator(), false).collect(Collectors.toSet()));
    }

    ElytronAccount(SecurityIdentity securityIdentity) {
        this(Assert.checkNotNullParam("securityIdentity", securityIdentity), securityIdentity.getRoles());
    }

    ElytronAccount(SecurityIdentity securityIdentity, String rolesCategory) {
        this(Assert.checkNotNullParam("securityIdentity", securityIdentity), securityIdentity.getRoles(rolesCategory, true));
    }

    @Override
    public Principal getPrincipal() {
        return this.securityIdentity.getPrincipal();
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }
}

