/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.AbstractSecurityContext;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronAccount;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.security.auth.server.FlexibleIdentityAssociation;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpAuthenticator;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

public class SecurityContextImpl
extends AbstractSecurityContext {
    private static final Logger log = Logger.getLogger("org.wildfly.security.http");
    private final ElytronHttpExchange httpExchange;
    protected final SecurityDomain securityDomain;
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final String programmaticMechanismName;
    private Supplier<IdentityCache> identityCacheSupplier;
    private final FlexibleIdentityAssociation flexibleIdentityAssociation;
    private volatile HttpAuthenticator httpAuthenticator;
    private Runnable logoutHandler;
    private AuthenticationMode authMode;

    protected SecurityContextImpl(Builder builder) {
        super(Assert.checkNotNullParam("exchange", builder.exchange));
        this.httpExchange = Assert.checkNotNullParam("httpExchange", builder.httpExchange);
        this.securityDomain = builder.securityDomain;
        this.mechanismSupplier = builder.mechanismSupplier;
        this.programmaticMechanismName = builder.programmaticMechanismName;
        this.authMode = builder.authMode;
        this.identityCacheSupplier = builder.identityCacheSupplier;
        this.flexibleIdentityAssociation = this.securityDomain != null ? this.securityDomain.getAnonymousSecurityIdentity().createFlexibleAssociation() : null;
    }

    private HttpAuthenticator getHttpAuthenticator() {
        if (this.httpAuthenticator == null) {
            this.httpAuthenticator = HttpAuthenticator.builder().setMechanismSupplier(Assert.checkNotNullParam("mechanismSupplier", this.mechanismSupplier)).setIdentityCacheSupplier(this.identityCacheSupplier).setProgrammaticMechanismName(Assert.checkNotNullParam("programmaticMechanismName", this.programmaticMechanismName)).setSecurityDomain(this.securityDomain).setHttpExchangeSpi(this.httpExchange).setRequired(this.isAuthenticationRequired()).setIgnoreOptionalFailures(false).registerLogoutHandler(this::setLogoutHandler).build();
        }
        return this.httpAuthenticator;
    }

    @Override
    public boolean authenticate() {
        if (this.isAuthenticated() || this.authMode == AuthenticationMode.CONSTRAINT_DRIVEN && !this.isAuthenticationRequired()) {
            return true;
        }
        HttpAuthenticator httpAuthenticator = this.getHttpAuthenticator();
        try {
            return httpAuthenticator.authenticate();
        }
        catch (HttpAuthenticationException e) {
            log.trace((Object)"Authentication failed.", e);
            this.exchange.setStatusCode(500);
            return false;
        }
    }

    protected void setLogoutHandler(Runnable runnable) {
        this.logoutHandler = runnable;
    }

    @Override
    public boolean login(String username, String password) {
        HttpAuthenticator httpAuthenticator = this.getHttpAuthenticator();
        SecurityIdentity securityIdentity = httpAuthenticator.login(username, password);
        if (securityIdentity != null) {
            this.flexibleIdentityAssociation.setIdentity(securityIdentity);
        }
        return securityIdentity != null;
    }

    @Override
    public void logout() {
        super.logout();
        if (this.logoutHandler != null) {
            this.logoutHandler.run();
        }
        if (this.flexibleIdentityAssociation != null) {
            this.flexibleIdentityAssociation.setIdentity(this.securityDomain.getAnonymousSecurityIdentity());
        }
    }

    protected void authenticationComplete(SecurityIdentity securityIdentity, String mechanism) {
        this.flexibleIdentityAssociation.setIdentity(securityIdentity);
        this.authenticationComplete(new ElytronAccount(securityIdentity), mechanism, false);
    }

    @Override
    public void addAuthenticationMechanism(AuthenticationMechanism mechanism) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IdentityManager getIdentityManager() {
        throw new UnsupportedOperationException();
    }

    FlexibleIdentityAssociation getFlexibleIdentityAssociation() {
        return this.flexibleIdentityAssociation;
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        HttpServerExchange exchange;
        String programmaticMechanismName;
        SecurityDomain securityDomain;
        Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        ElytronHttpExchange httpExchange;
        AuthenticationMode authMode;
        Supplier<IdentityCache> identityCacheSupplier;

        protected Builder() {
        }

        Builder setExchange(HttpServerExchange exchange) {
            this.exchange = Assert.checkNotNullParam("exchange", exchange);
            return this;
        }

        @Deprecated
        Builder setProgramaticMechanismName(String programmaticMechanismName) {
            return this.setProgrammaticMechanismName(programmaticMechanismName);
        }

        Builder setProgrammaticMechanismName(String programmaticMechanismName) {
            this.programmaticMechanismName = programmaticMechanismName;
            return this;
        }

        public Builder setAuthMode(AuthenticationMode authMode) {
            this.authMode = authMode;
            return this;
        }

        Builder setSecurityDomain(SecurityDomain securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = Assert.checkNotNullParam("mechanismSupplier", mechanismSupplier);
            return this;
        }

        @Deprecated
        Builder setHttpExchangeSupplier(ElytronHttpExchange httpExchange) {
            return this.setHttpExchange(httpExchange);
        }

        Builder setHttpExchange(ElytronHttpExchange httpExchange) {
            this.httpExchange = Assert.checkNotNullParam("httpExchange", httpExchange);
            return this;
        }

        Builder setIdentityCacheSupplier(Supplier<IdentityCache> identityCacheSupplier) {
            this.identityCacheSupplier = identityCacheSupplier;
            return this;
        }

        public SecurityContext build() {
            return new SecurityContextImpl(this);
        }
    }
}

