/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.HashSet;
import java.util.function.Function;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.AuthorizationFailureException;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;

class IdentityMapping {
    private static final String ANONYMOUS_PRINCIPAL = "anonymous";
    private static final String SERVLET = "servlet";
    private static final String EJB = "ejb";

    IdentityMapping() {
    }

    static SecurityIdentity mapIdentity(SecurityIdentity securityIdentity, SecurityDomain securityDomain, HttpServerExchange exchange, Function<String, RunAsIdentityMetaData> runAsMapper) {
        ServletChain servlet = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getCurrentServlet();
        RunAsIdentityMetaData runAsMetaData = runAsMapper.apply(servlet.getManagedServlet().getServletInfo().getName());
        return IdentityMapping.performMapping(securityIdentity, securityDomain, runAsMetaData);
    }

    static SecurityIdentity performMapping(SecurityIdentity securityIdentity, SecurityDomain securityDomain, RunAsIdentityMetaData runAsMetaData) {
        if (runAsMetaData != null) {
            SecurityIdentity newIdentity = securityIdentity != null ? securityIdentity : securityDomain.getAnonymousSecurityIdentity();
            String runAsPrincipal = runAsMetaData.getPrincipalName();
            if (runAsPrincipal.equals(ANONYMOUS_PRINCIPAL)) {
                try {
                    newIdentity = newIdentity.createRunAsAnonymous();
                }
                catch (AuthorizationFailureException ex) {
                    newIdentity = newIdentity.createRunAsAnonymous(false);
                }
            } else if (!IdentityMapping.runAsPrincipalExists(securityDomain, runAsPrincipal)) {
                newIdentity = securityDomain.createAdHocIdentity(runAsPrincipal);
            } else {
                try {
                    newIdentity = newIdentity.createRunAsIdentity(runAsPrincipal);
                }
                catch (AuthorizationFailureException ex) {
                    newIdentity = newIdentity.createRunAsIdentity(runAsPrincipal, false);
                }
            }
            HashSet<String> runAsRoleNames = new HashSet<String>(runAsMetaData.getRunAsRoles().size());
            runAsRoleNames.add(runAsMetaData.getRoleName());
            runAsRoleNames.addAll(runAsMetaData.getRunAsRoles());
            RoleMapper runAsRoleMaper = RoleMapper.constant(Roles.fromSet(runAsRoleNames));
            Roles servletRoles = newIdentity.getRoles(SERVLET);
            newIdentity = newIdentity.withRoleMapper(SERVLET, runAsRoleMaper.or(roles -> servletRoles));
            Roles ejbRoles = newIdentity.getRoles(EJB);
            newIdentity = newIdentity.withRoleMapper(EJB, runAsRoleMaper.or(roles -> ejbRoles));
            return newIdentity;
        }
        return securityIdentity;
    }

    static boolean runAsPrincipalExists(SecurityDomain securityDomain, String runAsPrincipal) {
        RealmIdentity realmIdentity = null;
        try {
            realmIdentity = securityDomain.getIdentity(runAsPrincipal);
            boolean bl = realmIdentity.exists();
            return bl;
        }
        catch (RealmUnavailableException e) {
            throw new IllegalStateException(String.format("Unable to obtain identity for name %s", runAsPrincipal), e);
        }
        finally {
            if (realmIdentity != null) {
                realmIdentity.dispose();
            }
        }
    }
}

