/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.wildfly.elytron.web.undertow.server.SecurityContextImpl;
import org.wildfly.elytron.web.undertow.server.servlet.CleanUpTask;
import org.wildfly.elytron.web.undertow.server.servlet.RequestResponseAccessor;
import org.wildfly.security.auth.jaspi.impl.JaspiAuthenticationContext;
import org.wildfly.security.auth.jaspi.impl.ServletMessageInfo;
import org.wildfly.security.cache.CachedIdentity;

public class ServletSecurityContextImpl
extends SecurityContextImpl {
    private static final Logger log = Logger.getLogger("org.wildfly.security.http.servlet");
    private static final String AUTH_TYPE = "javax.servlet.http.authType";
    private static final String DEFAULT_JASPI_MECHANISM = "JASPI";
    private static final String MANDATORY = "javax.security.auth.message.MessagePolicy.isMandatory";
    private static final String REGISTER_SESSION = "javax.servlet.http.registerSession";
    private static final String SERVLET_MESSAGE_LAYER = "HttpServlet";
    private static final String IDENTITY_KEY = IdentityContainer.class.getName();
    private final boolean enableJaspi;
    private final boolean integratedJaspi;
    private final String applicationContext;
    private final RequestResponseAccessor requestResponseAccessor;

    ServletSecurityContextImpl(Builder builder) {
        super(builder);
        this.enableJaspi = builder.enableJaspi;
        this.integratedJaspi = builder.integratedJaspi;
        this.applicationContext = builder.applicationContext;
        this.requestResponseAccessor = builder.requestResponseAccessor;
        log.tracef("Created ServletSecurityContextImpl enableJapi=%b, integratedJaspi=%b, applicationContext=%s", (Object)this.enableJaspi, (Object)this.integratedJaspi, (Object)this.applicationContext);
    }

    @Override
    public boolean authenticate() {
        if (this.isAuthenticated()) {
            return true;
        }
        if (this.enableJaspi) {
            AuthConfigFactory authConfigFactory = ServletSecurityContextImpl.getAuthConfigFactory();
            if (authConfigFactory != null) {
                AuthConfigProvider configProvider = authConfigFactory.getConfigProvider(SERVLET_MESSAGE_LAYER, this.applicationContext, null);
                if (configProvider != null) {
                    try {
                        return this.authenticate(configProvider);
                    }
                    catch (SecurityException | AuthException e) {
                        log.trace((Object)"Authentication failed.", e);
                        this.exchange.setStatusCode(500);
                        return false;
                    }
                }
                log.tracef("No AuthConfigProvider for layer=%s, appContext=%s", (Object)SERVLET_MESSAGE_LAYER, (Object)this.applicationContext);
            } else {
                log.trace("No AuthConfigFactory available.");
            }
        }
        log.trace("JASPIC Unavailable, using HTTP authentication.");
        return super.authenticate();
    }

    private static AuthConfigFactory getAuthConfigFactory() {
        try {
            if (System.getSecurityManager() != null) {
                return ServletSecurityContextImpl.doPrivileged(AuthConfigFactory::getFactory);
            }
            return AuthConfigFactory.getFactory();
        }
        catch (Exception e) {
            log.trace((Object)"Unable to get AuthConfigFactory", e);
            return null;
        }
    }

    private boolean authenticate(AuthConfigProvider authConfigProvider) throws AuthException, SecurityException {
        boolean registerSession;
        final HttpServletRequest httpServletRequest = this.requestResponseAccessor.getHttpServletRequest();
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            IdentityContainer identityContainer = (IdentityContainer)session.getAttribute(IDENTITY_KEY);
            if (identityContainer != null) {
                CachedIdentity securityIdentity = identityContainer.getSecurityIdentity();
                String authType = identityContainer.getAuthType();
                if (securityIdentity != null) {
                    log.trace("SecurityIdentity restored from HttpSession");
                    this.authenticationComplete(securityIdentity.getSecurityIdentity(), authType != null ? authType : this.getMechanismName());
                    return true;
                }
            } else {
                session.removeAttribute(IDENTITY_KEY);
            }
        }
        JaspiAuthenticationContext authenticationContext = ServletSecurityContextImpl.doPrivileged(() -> JaspiAuthenticationContext.newInstance(this.securityDomain, this.integratedJaspi));
        ServerAuthConfig serverAuthConfig = authConfigProvider.getServerAuthConfig(SERVLET_MESSAGE_LAYER, this.applicationContext, authenticationContext.createCallbackHandler());
        HttpServletResponse httpServletResponse = this.requestResponseAccessor.getHttpServletResponse();
        final ServletMessageInfo messageInfo = new ServletMessageInfo();
        messageInfo.setRequestMessage(httpServletRequest);
        messageInfo.setResponseMessage(httpServletResponse);
        if (this.isAuthenticationRequired()) {
            messageInfo.getMap().put(MANDATORY, Boolean.TRUE.toString());
        }
        Subject serverSubject = null;
        String authContextId = serverAuthConfig.getAuthContextID(messageInfo);
        final ServerAuthContext serverAuthContext = serverAuthConfig.getAuthContext(authContextId, null, Collections.emptyMap());
        if (serverAuthContext == null) {
            log.trace("No ServerAuthContext returned, JASPI authentication can not proceed.");
            return false;
        }
        final Subject clientSubject = new Subject();
        AuthStatus authStatus = serverAuthContext.validateRequest(messageInfo, clientSubject, serverSubject);
        log.tracef("ServerAuthContext.validateRequest returned AuthStatus=%s", (Object)authStatus);
        this.registerCleanUpTask(this.exchange, serverAuthContext, messageInfo, serverSubject);
        Map options = messageInfo.getMap();
        boolean bl = registerSession = options.containsKey(REGISTER_SESSION) && Boolean.parseBoolean(String.valueOf(options.get(REGISTER_SESSION)));
        if (authStatus == AuthStatus.SUCCESS || authStatus == AuthStatus.SEND_SUCCESS && registerSession) {
            CachedIdentity cachedIdentity;
            String authType = options.containsKey(AUTH_TYPE) ? String.valueOf(options.get(AUTH_TYPE)) : this.getMechanismName(DEFAULT_JASPI_MECHANISM);
            CachedIdentity cachedIdentity2 = cachedIdentity = authenticationContext.getAuthorizedIdentity() != null ? new CachedIdentity(DEFAULT_JASPI_MECHANISM, true, authenticationContext.getAuthorizedIdentity()) : null;
            if (registerSession) {
                log.trace("Storing SecurityIdentity in HttpSession");
                session = httpServletRequest.getSession(true);
                session.setAttribute(IDENTITY_KEY, new IdentityContainer(cachedIdentity, authType));
            }
            if (authStatus == AuthStatus.SUCCESS) {
                HttpServletResponse newHttpServletResponse;
                HttpServletRequest newHttpServletRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (httpServletRequest != newHttpServletRequest) {
                    this.requestResponseAccessor.setHttpServletRequest(newHttpServletRequest);
                }
                if (httpServletResponse != (newHttpServletResponse = (HttpServletResponse)messageInfo.getResponseMessage())) {
                    this.requestResponseAccessor.setHttpServletResponse(newHttpServletResponse);
                }
                boolean success = false;
                if (cachedIdentity != null) {
                    this.authenticationComplete(cachedIdentity.getSecurityIdentity(), authType);
                    success = true;
                }
                boolean bl2 = success = success || !this.isAuthenticationRequired();
                if (success) {
                    this.setLogoutHandler(new Runnable(){

                        @Override
                        public void run() {
                            HttpSession session = httpServletRequest.getSession(false);
                            if (session != null) {
                                session.removeAttribute(IDENTITY_KEY);
                            }
                            try {
                                serverAuthContext.cleanSubject(messageInfo, clientSubject);
                            }
                            catch (AuthException e) {
                                log.debug((Object)"Unable to cleanSubject", e);
                            }
                        }
                    });
                }
                return success;
            }
        }
        return false;
    }

    private String getMechanismName(String defaultMechanimsName) {
        String mechanimsName = super.getMechanismName();
        return this.getMechanismName() != null ? mechanimsName : defaultMechanimsName;
    }

    private void registerCleanUpTask(HttpServerExchange exchange, final ServerAuthContext serverAuthContext, final MessageInfo messageInfo, final Subject serviceSubject) {
        exchange.putAttachment(CleanUpTask.ATTACHMENT_KEY, new CleanUpTask(){

            @Override
            public void cleanUp(HttpServerExchange exchange) throws Exception {
                HttpServletResponse newHttpServletResponse;
                HttpServletRequest httpServletRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                HttpServletResponse httpServletResponse = (HttpServletResponse)messageInfo.getResponseMessage();
                serverAuthContext.secureResponse(messageInfo, serviceSubject);
                HttpServletRequest newHttpServletRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (httpServletRequest != newHttpServletRequest) {
                    ServletSecurityContextImpl.this.requestResponseAccessor.setHttpServletRequest(newHttpServletRequest);
                }
                if (httpServletResponse != (newHttpServletResponse = (HttpServletResponse)messageInfo.getResponseMessage())) {
                    ServletSecurityContextImpl.this.requestResponseAccessor.setHttpServletResponse(newHttpServletResponse);
                }
            }
        });
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    static Builder builder() {
        return new Builder();
    }

    public static class IdentityContainer
    implements Serializable {
        private static final long serialVersionUID = 812605442632466511L;
        private final CachedIdentity securityIdentity;
        private final String authType;

        public IdentityContainer(CachedIdentity securityIdentity, String authType) {
            this.securityIdentity = securityIdentity;
            this.authType = authType;
        }

        public CachedIdentity getSecurityIdentity() {
            return this.securityIdentity;
        }

        public String getAuthType() {
            return this.authType;
        }
    }

    static class Builder
    extends SecurityContextImpl.Builder {
        private boolean enableJaspi = true;
        private boolean integratedJaspi = true;
        private String applicationContext;
        private RequestResponseAccessor requestResponseAccessor;

        Builder() {
        }

        Builder setEnableJaspi(boolean enableJaspi) {
            this.enableJaspi = enableJaspi;
            return this;
        }

        Builder setIntegratedJaspi(boolean integratedJaspi) {
            this.integratedJaspi = integratedJaspi;
            return this;
        }

        Builder setApplicationContext(String applicationContext) {
            this.applicationContext = applicationContext;
            return this;
        }

        Builder setRequestResponseAccessor(RequestResponseAccessor requestResponseAccessor) {
            this.requestResponseAccessor = requestResponseAccessor;
            return this;
        }

        @Override
        public SecurityContext build() {
            return new ServletSecurityContextImpl(this);
        }
    }
}

