/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.jdbc;

import java.security.Principal;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.realm.jdbc.KeyMapper;
import org.wildfly.security.auth.realm.jdbc.QueryConfiguration;
import org.wildfly.security.auth.realm.jdbc._private.ElytronMessages;
import org.wildfly.security.auth.realm.jdbc.mapper.AttributeMapper;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class JdbcSecurityRealm
implements CacheableSecurityRealm {
    private final Supplier<Provider[]> providers;
    private final List<QueryConfiguration> queryConfiguration;

    public static JdbcSecurityRealmBuilder builder() {
        return new JdbcSecurityRealmBuilder();
    }

    JdbcSecurityRealm(List<QueryConfiguration> queryConfiguration, Supplier<Provider[]> providers) {
        this.queryConfiguration = queryConfiguration;
        this.providers = providers;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        if (!NamePrincipal.isConvertibleTo(principal)) {
            return RealmIdentity.NON_EXISTENT;
        }
        return new JdbcRealmIdentity(principal.getName());
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        Assert.checkNotNullParam("credentialType", credentialType);
        SupportLevel support = SupportLevel.UNSUPPORTED;
        for (QueryConfiguration configuration : this.queryConfiguration) {
            for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                SupportLevel mapperSupport = keyMapper.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
                if (support.compareTo(mapperSupport) >= 0) continue;
                support = mapperSupport;
            }
        }
        return support;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam("evidenceType", evidenceType);
        SupportLevel support = SupportLevel.UNSUPPORTED;
        for (QueryConfiguration configuration : this.queryConfiguration) {
            for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                SupportLevel mapperSupport = keyMapper.getEvidenceVerifySupport(evidenceType, algorithmName);
                if (support.compareTo(mapperSupport) >= 0) continue;
                support = mapperSupport;
            }
        }
        return support;
    }

    @Override
    public void registerIdentityChangeListener(Consumer<Principal> listener) {
    }

    private static interface ResultSetCallback<E> {
        public E handle(ResultSet var1) throws SQLException;
    }

    private class JdbcRealmIdentity
    implements RealmIdentity {
        private final String name;
        private boolean loaded = false;
        private JdbcIdentity identity;

        public JdbcRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            JdbcIdentity identity = this.getIdentity();
            if (identity != null) {
                return identity.identityCredentials.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.getCredential(credentialType, algorithmName, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            JdbcIdentity identity = this.getIdentity();
            if (identity != null) {
                return identity.identityCredentials.getCredential(credentialType, algorithmName);
            }
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidenceType", evidenceType);
            JdbcIdentity identity = this.getIdentity();
            if (identity != null) {
                return identity.identityCredentials.canVerify(evidenceType, algorithmName) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidence", evidence);
            JdbcIdentity identity = this.getIdentity();
            if (identity != null) {
                return identity.identityCredentials.verify(evidence);
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.getIdentity() != null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (!this.exists()) {
                return AuthorizationIdentity.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity(this.identity.attributes);
        }

        private JdbcIdentity getIdentity() throws RealmUnavailableException {
            if (!this.loaded && this.identity == null) {
                MapAttributes attributes = new MapAttributes();
                IdentityCredentials credentials = IdentityCredentials.NONE;
                boolean found = false;
                for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                    String sql = configuration.getSql();
                    ElytronMessages.log.tracef("Executing principalQuery %s with value %s", (Object)sql, (Object)this.name);
                    try {
                        Connection connection = this.getConnection(configuration);
                        try {
                            PreparedStatement preparedStatement = connection.prepareStatement(sql);
                            try {
                                preparedStatement.setString(1, this.name);
                                ResultSet resultSet = preparedStatement.executeQuery();
                                try {
                                    List<AttributeMapper> attributeMappers = configuration.getColumnMappers(AttributeMapper.class);
                                    List<KeyMapper> keyMappers = configuration.getColumnMappers(KeyMapper.class);
                                    while (resultSet.next()) {
                                        found = true;
                                        for (AttributeMapper attributeMapper : attributeMappers) {
                                            Object value = attributeMapper.map(resultSet, JdbcSecurityRealm.this.providers);
                                            if (value == null) continue;
                                            if (attributes.containsKey(attributeMapper.getName())) {
                                                attributes.get(attributeMapper.getName()).add(value.toString());
                                                continue;
                                            }
                                            attributes.addFirst(attributeMapper.getName(), value.toString());
                                        }
                                        for (KeyMapper keyMapper : keyMappers) {
                                            Object credential = keyMapper.map(resultSet, JdbcSecurityRealm.this.providers);
                                            if (credential == null) continue;
                                            credentials = credentials.withCredential((Credential)credential);
                                        }
                                    }
                                }
                                finally {
                                    if (resultSet == null) continue;
                                    resultSet.close();
                                }
                            }
                            finally {
                                if (preparedStatement == null) continue;
                                preparedStatement.close();
                            }
                        }
                        finally {
                            if (connection == null) continue;
                            connection.close();
                        }
                    }
                    catch (SQLException e) {
                        throw ElytronMessages.log.couldNotExecuteQuery(sql, e);
                    }
                    catch (Exception e) {
                        throw ElytronMessages.log.unexpectedErrorWhenProcessingAuthenticationQuery(sql, e);
                    }
                }
                this.identity = found ? new JdbcIdentity(attributes, credentials) : null;
                this.loaded = true;
            }
            return this.identity;
        }

        private Connection getConnection(QueryConfiguration configuration) throws RealmUnavailableException {
            try {
                DataSource dataSource = configuration.getDataSource();
                return dataSource.getConnection();
            }
            catch (Exception e) {
                throw ElytronMessages.log.couldNotOpenConnection(e);
            }
        }

        private class JdbcIdentity {
            private final Attributes attributes;
            private final IdentityCredentials identityCredentials;

            JdbcIdentity(Attributes attributes, IdentityCredentials identityCredentials) {
                this.attributes = attributes;
                this.identityCredentials = identityCredentials;
            }
        }
    }
}

