/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import javax.net.ssl.SSLContext;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.cloud.DiscoverableService;
import org.apache.camel.component.undertow.DefaultUndertowHttpBinding;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowHeaderFilterStrategy;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowProducer;
import org.apache.camel.component.undertow.handlers.CamelWebSocketHandler;
import org.apache.camel.component.undertow.spi.UndertowSecurityProvider;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

@UriEndpoint(firstVersion="2.16.0", scheme="undertow", title="Undertow", syntax="undertow:httpURI", category={Category.HTTP, Category.WEBSOCKET}, lenientProperties=true)
public class UndertowEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware,
DiscoverableService {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowEndpoint.class);
    private UndertowComponent component;
    private SSLContext sslContext;
    private OptionMap optionMap;
    private HttpHandlerRegistrationInfo registrationInfo;
    private CamelWebSocketHandler webSocketHttpHandler;
    private boolean isWebSocket;
    @UriPath
    @Metadata(required=true)
    private URI httpURI;
    @UriParam(label="common", defaultValue="false")
    private boolean useStreaming;
    @UriParam(label="advanced")
    private UndertowHttpBinding undertowHttpBinding;
    @UriParam(label="advanced")
    private AccessLogReceiver accessLogReceiver;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy = new UndertowHeaderFilterStrategy();
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="consumer")
    private String httpMethodRestrict;
    @UriParam(label="consumer", defaultValue="false")
    private Boolean matchOnUriPrefix = Boolean.FALSE;
    @UriParam(label="consumer", defaultValue="false")
    private Boolean accessLog = Boolean.FALSE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean throwExceptionOnFailure = Boolean.TRUE;
    @UriParam(label="producer", defaultValue="false")
    private Boolean transferException = Boolean.FALSE;
    @UriParam(label="consumer", defaultValue="false")
    private Boolean muteException = Boolean.FALSE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean keepAlive = Boolean.TRUE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean tcpNoDelay = Boolean.TRUE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean reuseAddresses = Boolean.TRUE;
    @UriParam(label="producer", prefix="option.", multiValue=true)
    private Map<String, Object> options;
    @UriParam(label="consumer")
    private boolean optionsEnabled;
    @UriParam(label="producer")
    private CookieHandler cookieHandler;
    @UriParam(label="producer,websocket")
    private Boolean sendToAll;
    @UriParam(label="producer,websocket", defaultValue="30000")
    private Integer sendTimeout = 30000;
    @UriParam(label="consumer,websocket", defaultValue="false")
    private boolean fireWebSocketChannelEvents;
    @UriParam(label="consumer,advanced", description="Specifies a comma-delimited set of io.undertow.server.HttpHandler instances to lookup in your Registry. These handlers are added to the Undertow handler chain (for example, to add security). Important: You can not use different handlers with different Undertow endpoints using the same port number. The handlers is associated to the port number. If you need different handlers, then use different port numbers.")
    private String handlers;
    @UriParam(label="producer", defaultValue="true", description="If the option is true, UndertowProducer will set the Host header to the value contained in the current exchange Host header, useful in reverse proxy applications where you want the Host header received by the downstream server to reflect the URL called by the upstream client, this allows applications which use the Host header to generate accurate URL's for a proxied service.")
    private boolean preserveHostHeader = true;
    @UriParam(label="security", description="OConfiguration used by UndertowSecurityProvider. Security configuration object for use from UndertowSecurityProvider. Configuration is UndertowSecurityProvider specific. Each provider decides whether accepts configuration.")
    private Object securityConfiguration;
    @UriParam(label="security", description="Configuration used by UndertowSecurityProvider. Comma separated list of allowed roles.")
    private String allowedRoles;
    @UriParam(label="security", description="Security provider allows plug in the provider, which will be used to secure requests. SPI approach could be used too (endpoint then finds security provider using SPI).")
    private UndertowSecurityProvider securityProvider;

    public UndertowEndpoint(String uri, UndertowComponent component) {
        super(uri, component);
        this.component = component;
    }

    @Override
    public UndertowComponent getComponent() {
        return this.component;
    }

    public UndertowSecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(UndertowSecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new UndertowProducer(this, this.optionMap);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new UndertowConsumer(this, processor);
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        throw new UnsupportedOperationException("This component does not support polling consumer");
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    @Override
    public Map<String, String> getServiceProperties() {
        return CollectionHelper.immutableMapOf("service.port", Integer.toString(this.httpURI.getPort()), "service.path", this.httpURI.getPath(), "service.protocol", this.httpURI.getScheme());
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public URI getHttpURI() {
        return this.httpURI;
    }

    public void setHttpURI(URI httpURI) {
        this.httpURI = UndertowHelper.makeHttpURI(httpURI);
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public Boolean getMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public boolean isMatchOnUriPrefix() {
        return this.matchOnUriPrefix != null && this.matchOnUriPrefix != false;
    }

    public void setMatchOnUriPrefix(Boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(Boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public Boolean getTransferException() {
        return this.transferException;
    }

    public void setTransferException(Boolean transferException) {
        this.transferException = transferException;
    }

    public Boolean getMuteException() {
        return this.muteException;
    }

    public void setMuteException(Boolean muteException) {
        this.muteException = muteException;
    }

    public UndertowHttpBinding getUndertowHttpBinding() {
        if (this.undertowHttpBinding == null) {
            this.undertowHttpBinding = new DefaultUndertowHttpBinding(this.useStreaming);
            this.undertowHttpBinding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.undertowHttpBinding.setTransferException(this.getTransferException());
            this.undertowHttpBinding.setMuteException(this.getMuteException());
        }
        return this.undertowHttpBinding;
    }

    public void setUndertowHttpBinding(UndertowHttpBinding undertowHttpBinding) {
        this.undertowHttpBinding = undertowHttpBinding;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public Boolean getReuseAddresses() {
        return this.reuseAddresses;
    }

    public void setReuseAddresses(Boolean reuseAddresses) {
        this.reuseAddresses = reuseAddresses;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public boolean isOptionsEnabled() {
        return this.optionsEnabled;
    }

    public void setOptionsEnabled(boolean optionsEnabled) {
        this.optionsEnabled = optionsEnabled;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    public Boolean getSendToAll() {
        return this.sendToAll;
    }

    public void setSendToAll(Boolean sendToAll) {
        this.sendToAll = sendToAll;
    }

    public Integer getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(Integer sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public void setUseStreaming(boolean useStreaming) {
        this.useStreaming = useStreaming;
    }

    public boolean isFireWebSocketChannelEvents() {
        return this.fireWebSocketChannelEvents;
    }

    public void setFireWebSocketChannelEvents(boolean fireWebSocketChannelEvents) {
        this.fireWebSocketChannelEvents = fireWebSocketChannelEvents;
    }

    public void setPreserveHostHeader(boolean preserveHostHeader) {
        this.preserveHostHeader = preserveHostHeader;
    }

    public boolean isPreserveHostHeader() {
        return this.preserveHostHeader;
    }

    public Object getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(Object securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public String getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setAllowedRoles(String allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    @Override
    protected void doInit() throws Exception {
        OptionMap.Builder builder;
        String scheme;
        super.doInit();
        if (this.securityProvider == null) {
            this.initSecurityProvider();
        }
        boolean bl = this.isWebSocket = "ws".equalsIgnoreCase(scheme = this.httpURI.getScheme()) || "wss".equalsIgnoreCase(scheme);
        if (this.sslContextParameters != null) {
            this.sslContext = this.sslContextParameters.createSSLContext(this.getCamelContext());
        }
        if (this.options != null && !this.options.isEmpty()) {
            ClassLoader cl = this.getComponent().getCamelContext().getApplicationContextClassLoader();
            if (cl == null) {
                cl = Options.class.getClassLoader();
            }
            OptionMap.Builder builder2 = OptionMap.builder();
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                key = key.toUpperCase(Locale.ENGLISH).replace('-', '_');
                key = Options.class.getName() + "." + key;
                Option<?> option = Option.fromString(key, cl);
                value = option.parseValue(value.toString(), cl);
                LOG.trace("Parsed option {}={}", (Object)option.getName(), value);
                builder2.set(option, value);
            }
            this.optionMap = builder2.getMap();
        } else {
            this.optionMap = OptionMap.EMPTY;
        }
        if (this.keepAlive != null && !this.optionMap.contains(Options.KEEP_ALIVE)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.KEEP_ALIVE, this.keepAlive);
            this.optionMap = builder.getMap();
        }
        if (this.tcpNoDelay != null && !this.optionMap.contains(Options.TCP_NODELAY)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.TCP_NODELAY, this.tcpNoDelay);
            this.optionMap = builder.getMap();
        }
        if (this.reuseAddresses != null && !this.optionMap.contains(Options.REUSE_ADDRESSES)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.REUSE_ADDRESSES, this.reuseAddresses);
            this.optionMap = builder.getMap();
        }
    }

    private void initSecurityProvider() throws Exception {
        Object securityConfiguration = this.getSecurityConfiguration();
        if (securityConfiguration != null) {
            ServiceLoader<UndertowSecurityProvider> securityProvider = ServiceLoader.load(UndertowSecurityProvider.class);
            Iterator<UndertowSecurityProvider> iter = securityProvider.iterator();
            LinkedList<String> providers = new LinkedList<String>();
            while (iter.hasNext()) {
                UndertowSecurityProvider security = iter.next();
                if (security.acceptConfiguration(securityConfiguration, this.getEndpointUri())) {
                    this.securityProvider = security;
                    LOG.info("Security provider found {}", (Object)securityProvider.getClass().getName());
                    break;
                }
                providers.add(security.getClass().getName());
            }
            if (this.securityProvider == null) {
                LOG.info("Security provider for configuration {} not found {}", securityConfiguration, providers);
            }
        }
        if (this.securityProvider == null) {
            this.securityProvider = this.getComponent().getSecurityProvider();
        }
    }

    public boolean isWebSocket() {
        return this.isWebSocket;
    }

    public HttpHandlerRegistrationInfo getHttpHandlerRegistrationInfo() {
        if (this.registrationInfo == null) {
            this.registrationInfo = new HttpHandlerRegistrationInfo(this.getHttpURI(), this.getHttpMethodRestrict(), this.getMatchOnUriPrefix());
        }
        return this.registrationInfo;
    }

    public CamelWebSocketHandler getWebSocketHttpHandler() {
        if (this.webSocketHttpHandler == null) {
            this.webSocketHttpHandler = new CamelWebSocketHandler();
        }
        return this.webSocketHttpHandler;
    }

    public Boolean getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(Boolean accessLog) {
        this.accessLog = accessLog;
    }

    public AccessLogReceiver getAccessLogReceiver() {
        return this.accessLogReceiver;
    }

    public void setAccessLogReceiver(AccessLogReceiver accessLogReceiver) {
        this.accessLogReceiver = accessLogReceiver;
    }

    public String getHandlers() {
        return this.handlers;
    }

    public void setHandlers(String handlers) {
        this.handlers = handlers;
    }
}

