/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;

public class RollbackProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private boolean markRollbackOnly;
    private boolean markRollbackOnlyLast;
    private String message;

    public RollbackProcessor() {
    }

    public RollbackProcessor(String message) {
        this.message = message;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.isMarkRollbackOnlyLast()) {
            exchange.setRollbackOnlyLast(true);
        } else {
            exchange.setRollbackOnly(true);
        }
        if (this.markRollbackOnly || this.markRollbackOnlyLast) {
            callback.done(true);
            return true;
        }
        if (this.message != null) {
            exchange.setException(new RollbackExchangeException(this.message, exchange));
        } else {
            exchange.setException(new RollbackExchangeException(exchange));
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "rollback";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isMarkRollbackOnly() {
        return this.markRollbackOnly;
    }

    public void setMarkRollbackOnly(boolean markRollbackOnly) {
        this.markRollbackOnly = markRollbackOnly;
    }

    public boolean isMarkRollbackOnlyLast() {
        return this.markRollbackOnlyLast;
    }

    public void setMarkRollbackOnlyLast(boolean markRollbackOnlyLast) {
        this.markRollbackOnlyLast = markRollbackOnlyLast;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

