/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class SynchronousDelegateProducer
extends ServiceSupport
implements Producer {
    private final Producer producer;

    public SynchronousDelegateProducer(Producer producer) {
        this.producer = producer;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.producer.process(exchange);
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.producer);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.producer);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.producer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producer);
    }

    @Override
    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService(this.producer);
    }

    @Override
    protected void doResume() throws Exception {
        ServiceHelper.resumeService(this.producer);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.producer);
    }

    @Override
    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    public String toString() {
        return this.producer.toString();
    }
}

