/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronAccount;
import org.wildfly.elytron.web.undertow.server.ScopeSessionListener;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.Scope;
import org.xnio.SslClientAuthMode;

public class ElytronHttpExchange
implements HttpExchangeSpi {
    private static final AttachmentKey<HttpScope> HTTP_SCOPE_ATTACHMENT_KEY = AttachmentKey.create(HttpScope.class);
    private static final FormParserFactory FORM_PARSER_FACTORY = FormParserFactory.builder().build();
    private final HttpServerExchange httpServerExchange;
    private final Map<Scope, Function<HttpServerExchange, HttpScope>> scopeResolvers;
    private final ScopeSessionListener scopeSessionListener;
    protected Map<String, List<String>> requestParameters;

    protected ElytronHttpExchange(HttpServerExchange httpServerExchange, Map<Scope, Function<HttpServerExchange, HttpScope>> scopeResolvers, ScopeSessionListener scopeSessionListener) {
        this.httpServerExchange = Assert.checkNotNullParam("httpServerExchange", httpServerExchange);
        this.scopeResolvers = scopeResolvers;
        this.scopeSessionListener = scopeSessionListener;
    }

    protected ElytronHttpExchange(HttpServerExchange httpServerExchange) {
        this(httpServerExchange, Collections.emptyMap(), null);
    }

    @Override
    public List<String> getRequestHeaderValues(String headerName) {
        return this.httpServerExchange.getRequestHeaders().get(headerName);
    }

    @Override
    public void addResponseHeader(String headerName, String headerValue) {
        HttpString headerString = Headers.fromCache(headerName);
        this.httpServerExchange.getResponseHeaders().add(headerString != null ? headerString : new HttpString(headerName), headerValue);
    }

    @Override
    public SSLSession getSSLSession() {
        SSLSessionInfo sessionInfo = this.httpServerExchange.getConnection().getSslSessionInfo();
        if (sessionInfo != null) {
            return sessionInfo.getSSLSession();
        }
        return null;
    }

    @Override
    public Certificate[] getPeerCertificates(boolean renegotiate) {
        SSLSessionInfo info = this.httpServerExchange.getConnection().getSslSessionInfo();
        if (info == null) {
            return null;
        }
        try {
            Certificate[] peerCertificates = info.getPeerCertificates();
            if (peerCertificates != null || !renegotiate) {
                return peerCertificates;
            }
        }
        catch (RenegotiationRequiredException | SSLPeerUnverifiedException exception) {
            // empty catch block
        }
        try {
            info.renegotiate(this.httpServerExchange, SslClientAuthMode.REQUESTED);
            return this.httpServerExchange.getConnection().getSslSessionInfo().getPeerCertificates();
        }
        catch (RenegotiationRequiredException | IOException exception) {
            return null;
        }
    }

    @Override
    public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
        SecurityContext securityContext = this.httpServerExchange.getSecurityContext();
        if (securityContext != null) {
            securityContext.authenticationComplete(new ElytronAccount(securityIdentity), mechanismName, false);
        }
    }

    @Override
    public void authenticationFailed(String message, String mechanismName) {
        SecurityContext securityContext = this.httpServerExchange.getSecurityContext();
        if (securityContext != null) {
            securityContext.authenticationFailed(message, mechanismName);
        }
    }

    @Override
    public void badRequest(HttpAuthenticationException error, String mechanismName) {
    }

    @Override
    public String getRequestMethod() {
        return this.httpServerExchange.getRequestMethod().toString();
    }

    @Override
    public URI getRequestURI() {
        String query = this.httpServerExchange.getQueryString();
        try {
            String path;
            int port;
            String host;
            String scheme;
            if (this.httpServerExchange.isHostIncludedInRequestURI()) {
                URI tempUri = new URI(this.httpServerExchange.getRequestURI());
                scheme = tempUri.getScheme();
                host = tempUri.getHost();
                port = tempUri.getPort();
                path = tempUri.getPath();
            } else {
                scheme = this.httpServerExchange.getRequestScheme();
                host = this.httpServerExchange.getHostName();
                port = this.httpServerExchange.getHostPort();
                path = this.httpServerExchange.getRequestURI();
            }
            return new URI(scheme, null, host, "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443 ? -1 : port, path, query == null || "".equals(query) ? null : query, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String getRequestPath() {
        return this.httpServerExchange.getRelativePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getRequestParameters() {
        if (this.requestParameters == null) {
            ElytronHttpExchange elytronHttpExchange = this;
            synchronized (elytronHttpExchange) {
                if (this.requestParameters == null) {
                    HashMap parameters = new HashMap();
                    Map<String, Deque<String>> queryParameters = this.httpServerExchange.getQueryParameters();
                    FormDataParser parser = FORM_PARSER_FACTORY.createParser(this.httpServerExchange);
                    if (parser != null) {
                        try {
                            FormData data = parser.parseBlocking();
                            for (Map.Entry<String, Deque<String>> queryParametersEntry : queryParameters.entrySet()) {
                                ArrayList values2 = new ArrayList(queryParametersEntry.getValue());
                                if (data.contains(queryParametersEntry.getKey())) {
                                    Deque<FormData.FormValue> formValues = data.get(queryParametersEntry.getKey());
                                    formValues.stream().filter(fv -> !fv.isFile()).forEach(fv -> values2.add(fv.getValue()));
                                }
                                parameters.put(queryParametersEntry.getKey(), Collections.unmodifiableList(values2));
                            }
                            StreamSupport.stream(data.spliterator(), false).filter(s -> !parameters.containsKey(s)).forEach(s -> parameters.put((String)s, Collections.unmodifiableList(data.get((String)s).stream().filter(v -> !v.isFile()).map(fv -> fv.getValue()).collect(Collectors.toList()))));
                        }
                        catch (IOException iOException) {}
                    } else {
                        queryParameters.forEach((name, values) -> parameters.put((String)name, Collections.unmodifiableList(new ArrayList(values))));
                    }
                    this.requestParameters = Collections.unmodifiableMap(parameters);
                }
            }
        }
        return this.requestParameters;
    }

    @Override
    public List<HttpServerCookie> getCookies() {
        Map<String, Cookie> cookies = this.httpServerExchange.getRequestCookies();
        return cookies.values().stream().map(cookie -> new HttpServerCookie((Cookie)cookie){
            final /* synthetic */ Cookie val$cookie;
            {
                this.val$cookie = cookie;
            }

            @Override
            public String getName() {
                return this.val$cookie.getName();
            }

            @Override
            public String getValue() {
                return this.val$cookie.getValue();
            }

            @Override
            public String getDomain() {
                return this.val$cookie.getDomain();
            }

            @Override
            public int getMaxAge() {
                return this.val$cookie.getMaxAge();
            }

            @Override
            public String getPath() {
                return this.val$cookie.getPath();
            }

            @Override
            public boolean isSecure() {
                return this.val$cookie.isSecure();
            }

            @Override
            public int getVersion() {
                return this.val$cookie.getVersion();
            }

            @Override
            public boolean isHttpOnly() {
                return this.val$cookie.isHttpOnly();
            }
        }).collect(Collectors.toList());
    }

    @Override
    public InputStream getRequestInputStream() {
        return this.httpServerExchange.getInputStream();
    }

    @Override
    public InetSocketAddress getSourceAddress() {
        return this.httpServerExchange.getSourceAddress();
    }

    @Override
    public void setResponseCookie(HttpServerCookie cookie) {
        CookieImpl actualCookie = new CookieImpl(cookie.getName(), cookie.getValue());
        actualCookie.setDomain(cookie.getDomain());
        actualCookie.setMaxAge(cookie.getMaxAge());
        actualCookie.setHttpOnly(cookie.isHttpOnly());
        actualCookie.setSecure(cookie.isSecure());
        actualCookie.setPath(cookie.getPath());
        this.httpServerExchange.setResponseCookie(actualCookie);
    }

    @Override
    public OutputStream getResponseOutputStream() {
        return this.httpServerExchange.getOutputStream();
    }

    @Override
    public HttpScope getScope(Scope scope) {
        if (this.scopeResolvers.containsKey((Object)scope)) {
            return this.scopeResolvers.get((Object)scope).apply(this.httpServerExchange);
        }
        switch (scope) {
            case APPLICATION: {
                final SessionManager sessionManager = this.getSessionManager();
                if (sessionManager == null) {
                    return null;
                }
                return new HttpScope(){

                    @Override
                    public String getID() {
                        return sessionManager.getDeploymentName();
                    }
                };
            }
            case CONNECTION: {
                return this.getScope(this.httpServerExchange.getConnection());
            }
            case EXCHANGE: {
                return this.getScope(this.httpServerExchange);
            }
            case GLOBAL: {
                return null;
            }
            case SESSION: {
                return this.toScope(null);
            }
            case SSL_SESSION: {
                return this.getScope(this.getSSLSession());
            }
        }
        return null;
    }

    @Override
    public Collection<String> getScopeIds(Scope scope) {
        if (scope == Scope.SESSION) {
            SessionManager sessionManager = this.getSessionManager();
            return sessionManager.getAllSessions();
        }
        return null;
    }

    @Override
    public HttpScope getScope(Scope scope, String id) {
        if (scope == Scope.SESSION) {
            return this.toScope(id);
        }
        return null;
    }

    @Override
    public void setStatusCode(int statusCode) {
        if (!this.httpServerExchange.isResponseStarted()) {
            this.httpServerExchange.setStatusCode(statusCode);
        }
    }

    public String getRemoteUser() {
        return this.httpServerExchange.getAttachment(HttpServerExchange.REMOTE_USER);
    }

    protected SessionManager getSessionManager() {
        return this.httpServerExchange.getAttachment(SessionManager.ATTACHMENT_KEY);
    }

    protected SessionConfig getSessionConfig() {
        return this.httpServerExchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
    }

    private HttpScope toScope(final String id) {
        final SessionManager sessionManager = this.getSessionManager();
        final SessionConfig sessionConfig = this.getSessionConfig();
        if (sessionManager == null || sessionConfig == null) {
            return null;
        }
        return new HttpScope(){
            private Session session;
            {
                this.session = id == null ? sessionManager.getSession(ElytronHttpExchange.this.httpServerExchange, sessionConfig) : sessionManager.getSession(id);
            }

            @Override
            public String getID() {
                if (this.exists()) {
                    return this.session.getId();
                }
                return null;
            }

            @Override
            public boolean exists() {
                return this.session != null;
            }

            @Override
            public boolean create() {
                if (this.exists()) {
                    return false;
                }
                this.session = sessionManager.createSession(ElytronHttpExchange.this.httpServerExchange, sessionConfig);
                return this.session != null;
            }

            @Override
            public boolean supportsAttachments() {
                return this.exists();
            }

            @Override
            public void setAttachment(String key, Object value) {
                if (this.supportsAttachments()) {
                    this.session.setAttribute(key, value);
                }
            }

            @Override
            public Object getAttachment(String key) {
                if (this.supportsAttachments()) {
                    return this.session.getAttribute(key);
                }
                return null;
            }

            @Override
            public boolean supportsInvalidation() {
                return this.exists();
            }

            @Override
            public boolean invalidate() {
                if (this.supportsInvalidation()) {
                    this.session.invalidate(ElytronHttpExchange.this.httpServerExchange);
                    return true;
                }
                return false;
            }

            @Override
            public boolean supportsNotifications() {
                return this.exists() && ElytronHttpExchange.this.scopeSessionListener != null;
            }

            @Override
            public void registerForNotification(Consumer<HttpScopeNotification> notificationConsumer) {
                if (this.supportsNotifications()) {
                    ElytronHttpExchange.this.scopeSessionListener.registerListener(this.session.getId(), notificationConsumer);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpScope getScope(AbstractAttachable attachable) {
        HttpScope httpScope = attachable.getAttachment(HTTP_SCOPE_ATTACHMENT_KEY);
        if (httpScope == null) {
            AbstractAttachable abstractAttachable = attachable;
            synchronized (abstractAttachable) {
                httpScope = attachable.getAttachment(HTTP_SCOPE_ATTACHMENT_KEY);
                if (httpScope == null) {
                    final HashMap storageMap = new HashMap();
                    httpScope = new HttpScope(){

                        @Override
                        public boolean exists() {
                            return true;
                        }

                        @Override
                        public boolean create() {
                            return false;
                        }

                        @Override
                        public boolean supportsAttachments() {
                            return true;
                        }

                        @Override
                        public void setAttachment(String key, Object value) {
                            if (value != null) {
                                storageMap.put(key, value);
                            } else {
                                storageMap.remove(key);
                            }
                        }

                        @Override
                        public Object getAttachment(String key) {
                            return storageMap.get(key);
                        }
                    };
                    attachable.putAttachment(HTTP_SCOPE_ATTACHMENT_KEY, httpScope);
                }
            }
        }
        return httpScope;
    }

    private HttpScope getScope(final SSLSession sslSession) {
        if (sslSession == null) {
            return null;
        }
        return new HttpScope(){

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public boolean create() {
                return false;
            }

            @Override
            public boolean supportsAttachments() {
                return true;
            }

            @Override
            public void setAttachment(String key, Object value) {
                sslSession.putValue(key, value);
            }

            @Override
            public Object getAttachment(String key) {
                return sslSession.getValue(key);
            }
        };
    }
}

