/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfig;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.jaspi.impl.AuthenticationModuleDefinition;
import org.wildfly.security.auth.jaspi.impl.ElytronServerAuthConfig;

public class ElytronAuthConfigProvider
implements AuthConfigProvider {
    private static ClientAuthConfig EMPTY_CLIENT_AUTH_CONFIG = new EmptyClientAuthConfig();
    private static ServerAuthConfig EMPTY_SERVER_AUTH_CONFIG = new EmptyServerAuthConfig();
    private final String messageLayer;
    private final String applicationContext;
    private final List<AuthenticationModuleDefinition> serverAuthModuleDefinitions;

    public ElytronAuthConfigProvider(String messageLayer, String applicationContext, List<AuthenticationModuleDefinition> serverAuthModuleDefinitions) {
        this.messageLayer = messageLayer;
        this.applicationContext = applicationContext;
        this.serverAuthModuleDefinitions = Assert.checkNotNullParam("serverAuthModuleDefinitions", serverAuthModuleDefinitions);
    }

    @Override
    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException, SecurityException {
        return EMPTY_CLIENT_AUTH_CONFIG;
    }

    @Override
    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) throws AuthException, SecurityException {
        Assert.checkNotNullParam("layer", layer);
        Assert.checkNotNullParam("appContext", appContext);
        if (!(this.serverAuthModuleDefinitions.isEmpty() || this.messageLayer != null && !this.messageLayer.equals(layer) || this.applicationContext != null && !this.applicationContext.equals(appContext))) {
            return new ElytronServerAuthConfig(this.messageLayer, this.applicationContext, callbackHandler, this.serverAuthModuleDefinitions);
        }
        return EMPTY_SERVER_AUTH_CONFIG;
    }

    @Override
    public void refresh() {
    }

    static class EmptyServerAuthConfig
    extends EmptyAuthConfig
    implements ServerAuthConfig {
        EmptyServerAuthConfig() {
        }

        @Override
        public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
            return null;
        }
    }

    static class EmptyClientAuthConfig
    extends EmptyAuthConfig
    implements ClientAuthConfig {
        EmptyClientAuthConfig() {
        }

        @Override
        public ClientAuthContext getAuthContext(String authContextID, Subject clientSubject, Map properties) throws AuthException {
            return null;
        }
    }

    static class EmptyAuthConfig
    implements AuthConfig {
        EmptyAuthConfig() {
        }

        @Override
        public String getAppContext() {
            return null;
        }

        @Override
        public String getMessageLayer() {
            return null;
        }

        @Override
        public String getAuthContextID(MessageInfo messageInfo) {
            return null;
        }

        @Override
        public boolean isProtected() {
            return false;
        }

        @Override
        public void refresh() {
        }
    }
}

