/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.wildfly.common.Assert;
import org.wildfly.security.authz.jacc.ElytronMessages;

class ElytronPolicyConfiguration
implements PolicyConfiguration {
    private final String contextId;
    private final Map<String, Permissions> rolePermissions = Collections.synchronizedMap(new HashMap());
    private State state = State.OPEN;
    private volatile Permissions uncheckedPermissions = new Permissions();
    private volatile Permissions excludedPermissions = new Permissions();
    private volatile Set<PolicyConfiguration> linkedPolicies = Collections.synchronizedSet(new LinkedHashSet());

    ElytronPolicyConfiguration(String contextID) {
        Assert.checkNotNullParam("contextID", contextID);
        this.contextId = contextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        Assert.checkNotNullParam("permission", permission);
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            this.checkIfInOpenState();
            this.excludedPermissions.add(permission);
        }
    }

    @Override
    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        Assert.checkNotNullParam("permissions", permissions);
        Enumeration<Permission> elements = permissions.elements();
        while (elements.hasMoreElements()) {
            this.addToExcludedPolicy(elements.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        Assert.checkNotNullParam("roleName", roleName);
        Assert.checkNotNullParam("permission", permission);
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            this.checkIfInOpenState();
            this.rolePermissions.computeIfAbsent(roleName, s -> new Permissions()).add(permission);
        }
    }

    @Override
    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        Assert.checkNotNullParam("roleName", roleName);
        Assert.checkNotNullParam("permissions", permissions);
        Enumeration<Permission> elements = permissions.elements();
        while (elements.hasMoreElements()) {
            this.addToRole(roleName, elements.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        Assert.checkNotNullParam("permission", permission);
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            this.checkIfInOpenState();
            this.uncheckedPermissions.add(permission);
        }
    }

    @Override
    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        Assert.checkNotNullParam("permissions", permissions);
        Enumeration<Permission> elements = permissions.elements();
        while (elements.hasMoreElements()) {
            this.addToUncheckedPolicy(elements.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws PolicyContextException {
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            if (this.isDeleted()) {
                throw ElytronMessages.log.authzInvalidStateForOperation(this.state.name());
            }
            this.transitionTo(State.IN_SERVICE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws PolicyContextException {
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            this.transitionTo(State.DELETED);
            this.uncheckedPermissions = new Permissions();
            this.excludedPermissions = new Permissions();
            this.rolePermissions.clear();
            this.linkedPolicies.remove(this);
        }
    }

    @Override
    public String getContextID() throws PolicyContextException {
        return this.contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inService() {
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            return State.IN_SERVICE.equals((Object)this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        Assert.checkNotNullParam("link", link);
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            this.checkIfInOpenState();
            if (this.getContextID().equals(link.getContextID())) {
                throw ElytronMessages.log.authzLinkSamePolicyConfiguration(this.getContextID());
            }
            this.linkedPolicies.add(this);
            if (!this.linkedPolicies.add(link)) {
                return;
            }
            ElytronPolicyConfiguration linkedPolicyConfiguration = (ElytronPolicyConfiguration)link;
            linkedPolicyConfiguration.linkConfiguration(this);
            this.linkedPolicies = linkedPolicyConfiguration.getLinkedPolicies();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExcludedPolicy() throws PolicyContextException {
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            this.checkIfInOpenState();
            this.excludedPermissions = new Permissions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(String roleName) throws PolicyContextException {
        Assert.checkNotNullParam("roleName", roleName);
        Assert.checkNotNullParam("roleName", roleName);
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            this.checkIfInOpenState();
            this.rolePermissions.remove(roleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUncheckedPolicy() throws PolicyContextException {
        ElytronPolicyConfiguration elytronPolicyConfiguration = this;
        synchronized (elytronPolicyConfiguration) {
            this.checkIfInOpenState();
            this.uncheckedPermissions = new Permissions();
        }
    }

    Set<PolicyConfiguration> getLinkedPolicies() {
        return this.linkedPolicies;
    }

    Permissions getUncheckedPermissions() {
        return this.uncheckedPermissions;
    }

    Permissions getExcludedPermissions() {
        return this.excludedPermissions;
    }

    Map<String, Permissions> getRolePermissions() {
        return this.rolePermissions;
    }

    void transitionTo(State state) {
        this.state = state;
    }

    private void checkIfInOpenState() {
        if (!State.OPEN.equals((Object)this.state)) {
            throw ElytronMessages.log.authzInvalidStateForOperation(this.state.name());
        }
    }

    private boolean isDeleted() {
        return State.DELETED.equals((Object)this.state);
    }

    static enum State {
        OPEN,
        IN_SERVICE,
        DELETED;

    }
}

