/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import java.util.Map;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.jacc.ElytronPolicyConfigurationFactory;

public class SecurityIdentityHandler
implements PolicyContextHandler {
    static final String KEY = SecurityIdentity.class.getName();
    private final Map<String, SecurityDomain> securityDomains;

    public SecurityIdentityHandler(Map<String, SecurityDomain> securityDomains) {
        Assert.checkNotNullParam("securityDomains", securityDomains);
        this.securityDomains = securityDomains;
    }

    @Override
    public Object getContext(String key, Object data) throws PolicyContextException {
        Object policyConfiguration;
        SecurityDomain securityDomain;
        if (this.supports(key) && (securityDomain = this.securityDomains.get((policyConfiguration = ElytronPolicyConfigurationFactory.getCurrentPolicyConfiguration()).getContextID())) != null) {
            return securityDomain.getCurrentSecurityIdentity();
        }
        return null;
    }

    @Override
    public String[] getKeys() throws PolicyContextException {
        return new String[]{KEY};
    }

    @Override
    public boolean supports(String key) throws PolicyContextException {
        return KEY.equalsIgnoreCase(key);
    }
}

