/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.requests.EtcdKeyDeleteRequest;
import mousio.etcd4j.requests.EtcdKeyGetRequest;
import mousio.etcd4j.requests.EtcdKeyPutRequest;
import mousio.etcd4j.requests.EtcdRequest;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.component.etcd.AbstractEtcdProducer;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdKeysEndpoint;
import org.apache.camel.component.etcd.EtcdNamespace;
import org.apache.camel.util.ObjectHelper;

public class EtcdKeysProducer
extends AbstractEtcdProducer {
    private final EtcdConfiguration configuration;

    public EtcdKeysProducer(EtcdKeysEndpoint endpoint, EtcdConfiguration configuration, EtcdNamespace namespace, String path) {
        super((Endpoint)endpoint, configuration, namespace, path);
        this.configuration = configuration;
    }

    public void process(Exchange exchange) throws Exception {
        String action = (String)exchange.getIn().getHeader("CamelEtcdAction", String.class);
        String path = (String)exchange.getIn().getHeader("CamelEtcdPath", String.class);
        if (path == null) {
            path = this.getPath();
        }
        ObjectHelper.notEmpty((String)path, (String)"CamelEtcdPath");
        ObjectHelper.notEmpty((String)action, (String)"CamelEtcdAction");
        switch (action) {
            case "set": {
                this.processSet(this.getClient(), path, exchange);
                break;
            }
            case "get": {
                this.processGet(this.getClient(), path, exchange);
                break;
            }
            case "delete": {
                this.processDel(this.getClient(), path, false, exchange);
                break;
            }
            case "deleteDir": {
                this.processDel(this.getClient(), path, true, exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action " + action);
            }
        }
    }

    private void processSet(EtcdClient client, String path, Exchange exchange) throws Exception {
        EtcdKeyPutRequest request = client.put(path, (String)exchange.getIn().getBody(String.class));
        this.setRequestTimeToLive(request, exchange);
        this.setRequestTimeout(request, exchange);
        try {
            exchange.getIn().setHeader("CamelEtcdNamespace", (Object)this.getNamespace());
            exchange.getIn().setBody((Object)request.send().get());
        }
        catch (TimeoutException e) {
            throw new ExchangeTimedOutException(exchange, this.configuration.getTimeout().longValue());
        }
    }

    private void processGet(EtcdClient client, String path, Exchange exchange) throws Exception {
        EtcdKeyGetRequest request = client.get(path);
        this.setRequestTimeout(request, exchange);
        this.setRequestRecursive(request, exchange);
        try {
            exchange.getIn().setHeader("CamelEtcdNamespace", (Object)this.getNamespace());
            exchange.getIn().setBody((Object)request.send().get());
        }
        catch (TimeoutException e) {
            throw new ExchangeTimedOutException(exchange, this.configuration.getTimeout().longValue());
        }
    }

    private void processDel(EtcdClient client, String path, boolean dir, Exchange exchange) throws Exception {
        EtcdKeyDeleteRequest request = client.delete(path);
        this.setRequestTimeout(request, exchange);
        this.setRequestRecursive(request, exchange);
        if (dir) {
            request.dir();
        }
        try {
            exchange.getIn().setHeader("CamelEtcdNamespace", (Object)this.getNamespace());
            exchange.getIn().setBody((Object)request.send().get());
        }
        catch (TimeoutException e) {
            throw new ExchangeTimedOutException(exchange, this.configuration.getTimeout().longValue());
        }
    }

    private void setRequestTimeout(EtcdRequest<?> request, Exchange exchange) {
        Long timeout = (Long)exchange.getIn().getHeader("CamelEtcdTimeout", Long.class);
        if (timeout != null) {
            request.timeout(timeout, TimeUnit.MILLISECONDS);
        } else if (this.configuration.getTimeout() != null) {
            request.timeout(this.configuration.getTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void setRequestTimeToLive(EtcdKeyPutRequest request, Exchange exchange) {
        Integer ttl = (Integer)exchange.getIn().getHeader("CamelEtcdTtl", Integer.class);
        if (ttl != null) {
            request.ttl(ttl);
        } else if (this.configuration.getTimeToLive() != null) {
            request.ttl(this.configuration.getTimeToLive());
        }
    }

    private void setRequestRecursive(EtcdKeyGetRequest request, Exchange exchange) {
        if (this.isRecursive(exchange)) {
            request.recursive();
        }
    }

    private void setRequestRecursive(EtcdKeyDeleteRequest request, Exchange exchange) {
        if (this.isRecursive(exchange)) {
            request.recursive();
        }
    }

    private boolean isRecursive(Exchange exchange) {
        Boolean recursive = (Boolean)exchange.getIn().getHeader("CamelEtcdRecursive", Boolean.class);
        if (recursive != null) {
            return recursive;
        }
        return this.configuration.isRecursive();
    }
}

