/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.cloud;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import mousio.client.promises.ResponsePromise;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdHelper;
import org.apache.camel.component.etcd.cloud.EtcdServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdWatchServiceDiscovery
extends EtcdServiceDiscovery
implements ResponsePromise.IsSimplePromiseResponseHandler<EtcdKeysResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdWatchServiceDiscovery.class);
    private final AtomicReference<List<ServiceDefinition>> serversRef = new AtomicReference();
    private final AtomicLong index = new AtomicLong(0L);
    private final String servicePath;

    public EtcdWatchServiceDiscovery(EtcdConfiguration configuration) throws Exception {
        super(configuration);
        this.servicePath = (String)ObjectHelper.notNull((Object)configuration.getServicePath(), (String)"servicePath");
    }

    public List<ServiceDefinition> getServices(String name) {
        List<ServiceDefinition> servers = this.serversRef.get();
        if (servers == null) {
            this.serversRef.set(this.getServices());
            this.watch();
        }
        return this.serversRef.get().stream().filter(s -> name.equalsIgnoreCase(s.getName())).collect(Collectors.toList());
    }

    @Override
    public void onResponse(ResponsePromise<EtcdKeysResponse> promise) {
        if (!this.isRunAllowed()) {
            return;
        }
        Throwable throwable = promise.getException();
        if (throwable instanceof EtcdException) {
            EtcdException exception = (EtcdException)throwable;
            if (EtcdHelper.isOutdatedIndexException(exception)) {
                LOGGER.debug("Outdated index, key={}, cause={}", (Object)this.servicePath, (Object)exception.etcdCause);
                this.index.set(exception.index + 1L);
            }
        } else {
            try {
                EtcdKeysResponse response = promise.get();
                EtcdHelper.setIndex(this.index, response);
                this.serversRef.set(this.getServices());
            }
            catch (TimeoutException e) {
                LOGGER.debug("Timeout watching for {}", (Object)this.getConfiguration().getServicePath());
                throwable = null;
            }
            catch (Exception e) {
                throwable = e;
            }
        }
        if (throwable != null) {
            throw new RuntimeCamelException(throwable);
        }
        this.watch();
    }

    private void watch() {
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            this.getClient().get(this.servicePath).recursive().waitForChange(this.index.get()).timeout(1L, TimeUnit.SECONDS).send().addListener(this);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

