/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.policy;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import mousio.client.promises.ResponsePromise;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdHelper;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Route policy using Etcd as clustered lock")
public class EtcdRoutePolicy
extends RoutePolicySupport
implements ResponsePromise.IsSimplePromiseResponseHandler<EtcdKeysResponse>,
CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdRoutePolicy.class);
    private final Object lock = new Object();
    private final AtomicBoolean leader = new AtomicBoolean(false);
    private final Set<Route> suspendedRoutes = new HashSet<Route>();
    private final AtomicLong index = new AtomicLong(0L);
    private int ttl = 60;
    private int watchTimeout = 20;
    private boolean shouldStopConsumer = true;
    private Route route;
    private CamelContext camelContext;
    private String serviceName;
    private String servicePath;
    private EtcdClient client;
    private boolean managedClient;
    private String clientUris = "http://localhost:2379,http://localhost:4001";

    public EtcdRoutePolicy() {
        this.client = null;
        this.managedClient = false;
    }

    public EtcdRoutePolicy(EtcdConfiguration configuration) throws Exception {
        this.client = configuration.createClient();
        this.managedClient = true;
    }

    public EtcdRoutePolicy(EtcdClient client) {
        this(client, false);
    }

    public EtcdRoutePolicy(EtcdClient client, boolean managedClient) {
        this.client = client;
        this.managedClient = managedClient;
    }

    public EtcdRoutePolicy(String clientUris) {
        this.clientUris = clientUris;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void onInit(Route route) {
        super.onInit(route);
        this.route = route;
    }

    public void onStart(Route route) {
        if (!this.leader.get() && this.shouldStopConsumer) {
            this.stopConsumer(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop(Route route) {
        Object object = this.lock;
        synchronized (object) {
            this.suspendedRoutes.remove(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onSuspend(Route route) {
        Object object = this.lock;
        synchronized (object) {
            this.suspendedRoutes.remove(route);
        }
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)this.clientUris, (String)"clientUris");
        if (this.client == null) {
            this.client = new EtcdClient(EtcdHelper.resolveURIs(this.camelContext, this.clientUris));
            this.managedClient = true;
        }
        this.setLeader(this.tryTakeLeadership());
        this.watch();
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.managedClient) {
            this.client.close();
        }
        super.doStop();
    }

    protected void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOGGER.info("Leadership taken (path={}, name={})", (Object)this.servicePath, (Object)this.serviceName);
            this.startAllStoppedConsumers();
        } else if (!this.leader.getAndSet(isLeader) && isLeader) {
            LOGGER.info("Leadership lost (path={}, name={})", (Object)this.servicePath, (Object)this.serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConsumer(Route route) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.suspendedRoutes.contains(route)) {
                    this.startConsumer(route.getConsumer());
                    this.suspendedRoutes.remove(route);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConsumer(Route route) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.suspendedRoutes.contains(route)) {
                    LOGGER.debug("Stopping consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                    this.stopConsumer(route.getConsumer());
                    this.suspendedRoutes.add(route);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAllStoppedConsumers() {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Route route : this.suspendedRoutes) {
                    LOGGER.debug("Starting consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                    this.startConsumer(route.getConsumer());
                }
                this.suspendedRoutes.clear();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public EtcdClient getClient() {
        return this.client;
    }

    @ManagedAttribute(description="The route id")
    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    @ManagedAttribute(description="The consumer endpoint", mask=true)
    public String getEndpointUrl() {
        if (this.route != null && this.route.getConsumer() != null && this.route.getConsumer().getEndpoint() != null) {
            return this.route.getConsumer().getEndpoint().toString();
        }
        return null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @ManagedAttribute(description="The etcd service name")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @ManagedAttribute(description="The etcd service path")
    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    @ManagedAttribute(description="The time to live (seconds)")
    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    @ManagedAttribute(description="The watch timeout (seconds)")
    public int getWatchTimeout() {
        return this.watchTimeout;
    }

    public void setWatchTimeout(int watchTimeout) {
        this.watchTimeout = watchTimeout;
    }

    @ManagedAttribute(description="Whether to stop consumer when starting up and failed to become master")
    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }

    @ManagedAttribute(description="Is this route the master or a slave")
    public boolean isLeader() {
        return this.leader.get();
    }

    @ManagedAttribute(description="Etcd endpoints")
    public String getClientUris() {
        return this.clientUris;
    }

    public void setClientUris(String clientUris) {
        this.clientUris = clientUris;
    }

    @Override
    public void onResponse(ResponsePromise<EtcdKeysResponse> promise) {
        if (!this.isRunAllowed()) {
            return;
        }
        Throwable throwable = promise.getException();
        if (throwable instanceof EtcdException) {
            EtcdException exception = (EtcdException)throwable;
            if (EtcdHelper.isOutdatedIndexException(exception)) {
                LOGGER.debug("Outdated index, key={}, cause={}", (Object)this.servicePath, (Object)exception.etcdCause);
                this.index.set(exception.index + 1L);
                throwable = null;
            }
        } else {
            try {
                EtcdKeysResponse response = promise.get();
                EtcdHelper.setIndex(this.index, response);
                if (response.node.value == null) {
                    this.setLeader(this.tryTakeLeadership());
                } else if (!ObjectHelper.equal((Object)this.serviceName, (Object)response.node.value) && this.leader.get()) {
                    this.setLeader(false);
                }
            }
            catch (TimeoutException e) {
                LOGGER.debug("Timeout watching for {}", (Object)this.servicePath);
                throwable = null;
            }
            catch (Exception e1) {
                throwable = e1;
            }
        }
        if (throwable != null) {
            throw new RuntimeCamelException(throwable);
        }
        this.watch();
    }

    private void watch() {
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            if (this.leader.get()) {
                EtcdHelper.setIndex(this.index, this.client.refresh(this.servicePath, this.ttl).send().get());
            }
            LOGGER.debug("Watch (path={}, isLeader={}, index={})", new Object[]{this.servicePath, this.leader.get(), this.index.get()});
            this.client.get(this.servicePath).waitForChange(this.index.get()).timeout(this.watchTimeout, TimeUnit.SECONDS).send().addListener(this);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private boolean tryTakeLeadership() throws Exception {
        boolean result;
        block2: {
            result = false;
            try {
                EtcdKeysResponse response = this.getClient().put(this.servicePath, this.serviceName).prevExist(false).ttl(this.ttl).send().get();
                result = ObjectHelper.equal((Object)this.serviceName, (Object)response.node.value);
                EtcdHelper.setIndex(this.index, response);
            }
            catch (EtcdException e) {
                if (e.isErrorCode(105)) break block2;
                throw e;
            }
        }
        return result;
    }
}

