/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.op;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.DeleteRangeRequest;
import io.etcd.jetcd.api.PutRequest;
import io.etcd.jetcd.api.RangeRequest;
import io.etcd.jetcd.api.RequestOp;
import io.etcd.jetcd.api.TxnRequest;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.OptionsUtil;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.shaded.com.google.protobuf.ByteString;

public abstract class Op {
    protected final Type type;
    protected final ByteString key;

    protected Op(Type type, ByteString key) {
        this.type = type;
        this.key = key;
    }

    abstract RequestOp toRequestOp(ByteSequence var1);

    public static PutOp put(ByteSequence key, ByteSequence value, PutOption option) {
        return new PutOp(ByteString.copyFrom(key.getBytes()), ByteString.copyFrom(value.getBytes()), option);
    }

    public static GetOp get(ByteSequence key, GetOption option) {
        return new GetOp(ByteString.copyFrom(key.getBytes()), option);
    }

    public static DeleteOp delete(ByteSequence key, DeleteOption option) {
        return new DeleteOp(ByteString.copyFrom(key.getBytes()), option);
    }

    public static TxnOp txn(Cmp[] cmps, Op[] thenOps, Op[] elseOps) {
        return new TxnOp(cmps, thenOps, elseOps);
    }

    public static final class TxnOp
    extends Op {
        private Cmp[] cmps;
        private Op[] thenOps;
        private Op[] elseOps;

        protected TxnOp(Cmp[] cmps, Op[] thenOps, Op[] elseOps) {
            super(Type.TXN, null);
            this.cmps = cmps;
            this.thenOps = thenOps;
            this.elseOps = elseOps;
        }

        @Override
        RequestOp toRequestOp(ByteSequence namespace) {
            TxnRequest.Builder txn = TxnRequest.newBuilder();
            if (this.cmps != null) {
                for (Cmp cmp : this.cmps) {
                    txn.addCompare(cmp.toCompare(namespace));
                }
            }
            if (this.thenOps != null) {
                for (Op thenOp : this.thenOps) {
                    txn.addSuccess(thenOp.toRequestOp(namespace));
                }
            }
            if (this.elseOps != null) {
                for (Op elseOp : this.elseOps) {
                    txn.addFailure(elseOp.toRequestOp(namespace));
                }
            }
            return RequestOp.newBuilder().setRequestTxn(txn).build();
        }
    }

    public static final class DeleteOp
    extends Op {
        private final DeleteOption option;

        protected DeleteOp(ByteString key, DeleteOption option) {
            super(Type.DELETE_RANGE, key);
            this.option = option;
        }

        @Override
        RequestOp toRequestOp(ByteSequence namespace) {
            DeleteRangeRequest.Builder delete = DeleteRangeRequest.newBuilder().setKey(Util.prefixNamespace(this.key, namespace)).setPrevKv(this.option.isPrevKV());
            this.option.getEndKey().map(endKey -> Util.prefixNamespaceToRangeEnd(ByteString.copyFrom(endKey.getBytes()), namespace)).ifPresent(delete::setRangeEnd);
            return RequestOp.newBuilder().setRequestDeleteRange(delete).build();
        }
    }

    public static final class GetOp
    extends Op {
        private final GetOption option;

        protected GetOp(ByteString key, GetOption option) {
            super(Type.RANGE, key);
            this.option = option;
        }

        @Override
        RequestOp toRequestOp(ByteSequence namespace) {
            RangeRequest.Builder range = RangeRequest.newBuilder().setKey(Util.prefixNamespace(this.key, namespace)).setCountOnly(this.option.isCountOnly()).setLimit(this.option.getLimit()).setRevision(this.option.getRevision()).setKeysOnly(this.option.isKeysOnly()).setSerializable(this.option.isSerializable()).setSortOrder(OptionsUtil.toRangeRequestSortOrder(this.option.getSortOrder())).setSortTarget(OptionsUtil.toRangeRequestSortTarget(this.option.getSortField()));
            this.option.getEndKey().map(endKey -> Util.prefixNamespaceToRangeEnd(ByteString.copyFrom(endKey.getBytes()), namespace)).ifPresent(range::setRangeEnd);
            return RequestOp.newBuilder().setRequestRange(range).build();
        }
    }

    public static final class PutOp
    extends Op {
        private final ByteString value;
        private final PutOption option;

        protected PutOp(ByteString key, ByteString value, PutOption option) {
            super(Type.PUT, key);
            this.value = value;
            this.option = option;
        }

        @Override
        RequestOp toRequestOp(ByteSequence namespace) {
            PutRequest put = PutRequest.newBuilder().setKey(Util.prefixNamespace(this.key, namespace)).setValue(this.value).setLease(this.option.getLeaseId()).setPrevKv(this.option.getPrevKV()).build();
            return RequestOp.newBuilder().setRequestPut(put).build();
        }
    }

    public static enum Type {
        PUT,
        RANGE,
        DELETE_RANGE,
        TXN;

    }
}

