/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import io.etcd.jetcd.shaded.net.jodah.failsafe.AbstractExecution;
import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionResult;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FailsafeFuture;
import io.etcd.jetcd.shaded.net.jodah.failsafe.Fallback;
import io.etcd.jetcd.shaded.net.jodah.failsafe.PolicyExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.internal.EventListener;
import io.etcd.jetcd.shaded.net.jodah.failsafe.util.concurrent.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class FallbackExecutor
extends PolicyExecutor<Fallback> {
    private final EventListener failedAttemptListener;

    FallbackExecutor(Fallback fallback, AbstractExecution execution, EventListener failedAttemptListener) {
        super(fallback, execution);
        this.failedAttemptListener = failedAttemptListener;
    }

    @Override
    protected Supplier<ExecutionResult> supply(Supplier<ExecutionResult> supplier, Scheduler scheduler) {
        return () -> {
            ExecutionResult result = (ExecutionResult)supplier.get();
            if (this.isFailure(result)) {
                try {
                    result = this.policy == Fallback.VOID ? result.withNonResult() : result.withResult(((Fallback)this.policy).apply(result.getResult(), result.getFailure(), this.execution.copy()));
                }
                catch (Throwable t2) {
                    result = ExecutionResult.failure(t2);
                }
            }
            return this.postExecute(result);
        };
    }

    @Override
    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, FailsafeFuture<Object> future) {
        return () -> ((CompletableFuture)supplier.get()).thenCompose(result -> {
            if (this.isFailure((ExecutionResult)result)) {
                CompletableFuture promise = new CompletableFuture();
                Callable<Object> callable = () -> {
                    try {
                        CompletableFuture<Object> fallback = ((Fallback)this.policy).applyStage(result.getResult(), result.getFailure(), this.execution.copy());
                        fallback.whenComplete((innerResult, failure) -> {
                            if (failure instanceof CompletionException) {
                                failure = failure.getCause();
                            }
                            ExecutionResult r = failure == null ? result.withResult(innerResult) : ExecutionResult.failure(failure);
                            promise.complete(r);
                        });
                    }
                    catch (Throwable t2) {
                        promise.complete(ExecutionResult.failure(t2));
                    }
                    return null;
                };
                try {
                    if (!((Fallback)this.policy).isAsync()) {
                        callable.call();
                    } else {
                        future.inject(scheduler.schedule(callable, result.getWaitNanos(), TimeUnit.NANOSECONDS));
                    }
                }
                catch (Throwable t2) {
                    promise.completeExceptionally(t2);
                }
                return promise.thenCompose(ss -> this.postExecuteAsync((ExecutionResult)ss, scheduler, future));
            }
            return this.postExecuteAsync((ExecutionResult)result, scheduler, future);
        });
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        if (this.failedAttemptListener != null) {
            this.failedAttemptListener.handle(result, this.execution);
        }
        return result;
    }
}

