/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import io.etcd.jetcd.api.AuthenticateRequest;
import io.etcd.jetcd.api.VertxAuthGrpc;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.MetadataUtils;
import java.util.ArrayList;
import java.util.concurrent.Executor;

class AuthCredential
extends CallCredentials {
    public static final Metadata.Key<String> TOKEN = Metadata.Key.of("token", Metadata.ASCII_STRING_MARSHALLER);
    private final ClientConnectionManager manager;
    private volatile Metadata meta;

    public AuthCredential(ClientConnectionManager manager) {
        this.manager = manager;
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        Metadata meta = this.meta;
        if (meta != null) {
            applier.apply(meta);
        } else {
            this.authenticate(applier);
        }
    }

    @Override
    public void thisUsesUnstableApi() {
    }

    public void refresh() {
        this.meta = null;
    }

    private void authenticate(CallCredentials.MetadataApplier applier) {
        Preconditions.checkArgument(!this.manager.builder().user().isEmpty(), "username can not be empty.");
        Preconditions.checkArgument(!this.manager.builder().password().isEmpty(), "password can not be empty.");
        VertxAuthGrpc.AuthVertxStub authFutureStub = VertxAuthGrpc.newVertxStub(this.manager.getChannel());
        ArrayList<ClientInterceptor> interceptorsChain = new ArrayList<ClientInterceptor>();
        if (this.manager.builder().authHeaders() != null) {
            Metadata metadata = new Metadata();
            this.manager.builder().authHeaders().forEach(metadata::put);
            interceptorsChain.add(MetadataUtils.newAttachHeadersInterceptor(metadata));
        }
        if (this.manager.builder().authInterceptors() != null) {
            interceptorsChain.addAll(this.manager.builder().authInterceptors());
        }
        if (!interceptorsChain.isEmpty()) {
            authFutureStub = (VertxAuthGrpc.AuthVertxStub)authFutureStub.withInterceptors(interceptorsChain.toArray(new ClientInterceptor[0]));
        }
        ByteString user = ByteString.copyFrom(this.manager.builder().user().getBytes());
        ByteString pass = ByteString.copyFrom(this.manager.builder().password().getBytes());
        AuthenticateRequest request = AuthenticateRequest.newBuilder().setNameBytes(user).setPasswordBytes(pass).build();
        try {
            authFutureStub.authenticate(request).onFailure(t2 -> applier.fail(Status.UNAUTHENTICATED.withCause((Throwable)t2))).onSuccess(h2 -> {
                Metadata meta = new Metadata();
                meta.put(TOKEN, h2.getToken());
                this.meta = meta;
                applier.apply(this.meta);
            });
        }
        catch (Exception e) {
            applier.fail(Status.UNAUTHENTICATED.withCause(e));
        }
    }
}

