/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogDelegate
implements LogDelegate {
    private static final String FQCN = Logger.class.getCanonicalName();
    private final org.slf4j.Logger logger;

    SLF4JLogDelegate(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public SLF4JLogDelegate(Object logger) {
        this.logger = (org.slf4j.Logger)logger;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void fatal(Object message) {
        this.log(40, message);
    }

    @Override
    public void fatal(Object message, Throwable t2) {
        this.log(40, message, t2);
    }

    @Override
    public void error(Object message) {
        this.log(40, message);
    }

    @Override
    public void error(Object message, Object ... params) {
        this.log(40, message, null, params);
    }

    @Override
    public void error(Object message, Throwable t2) {
        this.log(40, message, t2);
    }

    @Override
    public void error(Object message, Throwable t2, Object ... params) {
        this.log(40, message, t2, params);
    }

    @Override
    public void warn(Object message) {
        this.log(30, message);
    }

    @Override
    public void warn(Object message, Object ... params) {
        this.log(30, message, null, params);
    }

    @Override
    public void warn(Object message, Throwable t2) {
        this.log(30, message, t2);
    }

    @Override
    public void warn(Object message, Throwable t2, Object ... params) {
        this.log(30, message, t2, params);
    }

    @Override
    public void info(Object message) {
        this.log(20, message);
    }

    @Override
    public void info(Object message, Object ... params) {
        this.log(20, message, null, params);
    }

    @Override
    public void info(Object message, Throwable t2) {
        this.log(20, message, t2);
    }

    @Override
    public void info(Object message, Throwable t2, Object ... params) {
        this.log(20, message, t2, params);
    }

    @Override
    public void debug(Object message) {
        this.log(10, message);
    }

    @Override
    public void debug(Object message, Object ... params) {
        this.log(10, message, null, params);
    }

    @Override
    public void debug(Object message, Throwable t2) {
        this.log(10, message, t2);
    }

    @Override
    public void debug(Object message, Throwable t2, Object ... params) {
        this.log(10, message, t2, params);
    }

    @Override
    public void trace(Object message) {
        this.log(0, message);
    }

    @Override
    public void trace(Object message, Object ... params) {
        this.log(0, message, null, params);
    }

    @Override
    public void trace(Object message, Throwable t2) {
        this.log(0, message, t2);
    }

    @Override
    public void trace(Object message, Throwable t2, Object ... params) {
        this.log(0, message, t2, params);
    }

    private void log(int level, Object message) {
        this.log(level, message, null);
    }

    private void log(int level, Object message, Throwable t2) {
        this.log(level, message, t2, null);
    }

    private void log(int level, Object message, Throwable t2, Object ... params) {
        String msg = message == null ? "NULL" : message.toString();
        Object[] parameters = params;
        if (params != null && t2 != null) {
            parameters = new Object[params.length + 1];
            System.arraycopy(params, 0, parameters, 0, params.length);
            parameters[params.length] = t2;
        } else if (params == null && t2 != null) {
            parameters = new Object[]{t2};
        }
        if (this.logger instanceof LocationAwareLogger) {
            if (level == 0 && this.logger.isTraceEnabled() || level == 10 && this.logger.isDebugEnabled() || level == 20 && this.logger.isInfoEnabled() || level == 30 && this.logger.isWarnEnabled() || level == 40 && this.logger.isErrorEnabled()) {
                LocationAwareLogger l = (LocationAwareLogger)this.logger;
                FormattingTuple ft = MessageFormatter.arrayFormat((String)msg, (Object[])parameters);
                l.log(null, FQCN, level, ft.getMessage(), null, ft.getThrowable());
            }
        } else {
            switch (level) {
                case 0: {
                    this.logger.trace(msg, parameters);
                    break;
                }
                case 10: {
                    this.logger.debug(msg, parameters);
                    break;
                }
                case 20: {
                    this.logger.info(msg, parameters);
                    break;
                }
                case 30: {
                    this.logger.warn(msg, parameters);
                    break;
                }
                case 40: {
                    this.logger.error(msg, parameters);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown log level " + level);
                }
            }
        }
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

