/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd3;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.etcd3.Etcd3Component;
import org.apache.camel.component.etcd3.Etcd3Configuration;
import org.apache.camel.component.etcd3.Etcd3Constants;
import org.apache.camel.component.etcd3.Etcd3Consumer;
import org.apache.camel.component.etcd3.Etcd3Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.19.0", scheme="etcd3", title="Etcd v3", syntax="etcd3:path", category={Category.CLUSTERING, Category.DATABASE}, headersClass=Etcd3Constants.class)
public class Etcd3Endpoint
extends DefaultEndpoint {
    @UriPath(label="common", description="The path the endpoint refers to")
    private final String path;
    @UriParam
    private final Etcd3Configuration configuration;

    public Etcd3Endpoint(String uri, Etcd3Component component, Etcd3Configuration configuration, String path) {
        super(uri, component);
        this.path = path;
        this.configuration = configuration;
    }

    public Etcd3Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Producer createProducer() {
        return new Etcd3Producer(this, this.configuration, this.path);
    }

    @Override
    public Consumer createConsumer(Processor processor) {
        return new Etcd3Consumer(this, processor, this.configuration, this.path);
    }
}

