/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.saga;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.saga.SagaCompletionMode;
import org.apache.camel.processor.saga.SagaProcessor;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;

public class NotSupportedSagaProcessor
extends SagaProcessor {
    public NotSupportedSagaProcessor(CamelContext camelContext, Processor childProcessor, CamelSagaService sagaService, SagaCompletionMode completionMode, CamelSagaStep step) {
        super(camelContext, childProcessor, sagaService, completionMode, step);
        if (!step.isEmpty()) {
            throw new IllegalArgumentException("Saga configuration is not allowed when propagation is set to NOT_SUPPORTED");
        }
        if (completionMode != null && completionMode != SagaCompletionMode.defaultCompletionMode()) {
            throw new IllegalArgumentException("CompletionMode cannot be specified when propagation is NOT_SUPPORTED");
        }
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.getCurrentSagaCoordinator(exchange).whenComplete((coordinator, ex) -> this.ifNotException((Throwable)ex, exchange, callback, () -> {
            this.setCurrentSagaCoordinator(exchange, null);
            super.process(exchange, doneSync -> {
                this.setCurrentSagaCoordinator(exchange, (CamelSagaCoordinator)coordinator);
                callback.done(false);
            });
        }));
        return false;
    }
}

