/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.IOException;
import java.util.List;

public class FacebookException
extends Exception {
    private static final long serialVersionUID = 8394133786720654641L;
    private int statusCode = -1;
    private HttpResponse response;
    private String errorType;
    private String errorMessage;
    private int errorCode = -1;

    public FacebookException(String message, Throwable cause) {
        super(message, cause);
        this.decode(message);
    }

    public FacebookException(String message, HttpResponse res) {
        this(message);
        this.response = res;
        this.statusCode = res.getStatusCode();
    }

    public FacebookException(String message) {
        this(message, (Throwable)null);
    }

    public FacebookException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    public FacebookException(String message, Throwable cause, int statusCode) {
        this(message, cause);
        this.statusCode = statusCode;
    }

    private void decode(String str) {
        if (str != null && str.startsWith("{")) {
            try {
                JSONObject json = new JSONObject(str);
                if (!json.isNull("error")) {
                    JSONObject error = json.getJSONObject("error");
                    this.errorType = error.getString("type");
                    this.errorMessage = error.getString("message");
                    this.errorCode = error.getInt("code");
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseHeader(String name) {
        List<String> header;
        String value = null;
        if (this.response != null && (header = this.response.getResponseHeaderFields().get(name)).size() > 0) {
            value = header.get(0);
        }
        return value;
    }

    public boolean isCausedByNetworkIssue() {
        return this.getCause() instanceof IOException;
    }

    public boolean resourceNotFound() {
        return this.statusCode == 404;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.errorCode;
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.errorType == null ? 0 : this.errorType.hashCode());
        result = 31 * result + (this.response == null ? 0 : this.response.hashCode());
        result = 31 * result + this.statusCode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FacebookException other = (FacebookException)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.errorType == null ? other.errorType != null : !this.errorType.equals(other.errorType)) {
            return false;
        }
        if (this.response == null ? other.response != null : !this.response.equals(other.response)) {
            return false;
        }
        return this.statusCode == other.statusCode;
    }

    public String toString() {
        return "FacebookException [statusCode=" + this.statusCode + ", response=" + this.response + ", errorType=" + this.errorType + ", errorMessage=" + this.errorMessage + ", errorCode=" + this.errorCode + "]";
    }
}

