/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.Account;
import facebook4j.Achievement;
import facebook4j.Activity;
import facebook4j.Album;
import facebook4j.AlbumCreate;
import facebook4j.Book;
import facebook4j.Checkin;
import facebook4j.CheckinCreate;
import facebook4j.Comment;
import facebook4j.Domain;
import facebook4j.Event;
import facebook4j.EventUpdate;
import facebook4j.Facebook;
import facebook4j.FacebookAPIMonitor;
import facebook4j.FacebookBaseImpl;
import facebook4j.FacebookException;
import facebook4j.Family;
import facebook4j.Friend;
import facebook4j.FriendRequest;
import facebook4j.Friendlist;
import facebook4j.Game;
import facebook4j.GeoLocation;
import facebook4j.Group;
import facebook4j.GroupDoc;
import facebook4j.GroupMember;
import facebook4j.Inbox;
import facebook4j.InboxResponseList;
import facebook4j.Insight;
import facebook4j.Interest;
import facebook4j.Like;
import facebook4j.Link;
import facebook4j.Location;
import facebook4j.Media;
import facebook4j.Message;
import facebook4j.Movie;
import facebook4j.Music;
import facebook4j.Note;
import facebook4j.Notification;
import facebook4j.Paging;
import facebook4j.Permission;
import facebook4j.Photo;
import facebook4j.PictureSize;
import facebook4j.Place;
import facebook4j.Poke;
import facebook4j.Post;
import facebook4j.PostUpdate;
import facebook4j.Question;
import facebook4j.QuestionVotes;
import facebook4j.RSVPStatus;
import facebook4j.Reading;
import facebook4j.ResponseList;
import facebook4j.Score;
import facebook4j.Subscribedto;
import facebook4j.Subscriber;
import facebook4j.Tag;
import facebook4j.TagUpdate;
import facebook4j.Television;
import facebook4j.TestUser;
import facebook4j.User;
import facebook4j.Video;
import facebook4j.auth.Authorization;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacebookImpl
extends FacebookBaseImpl
implements Facebook {
    private static final long serialVersionUID = 6277119018105563020L;

    FacebookImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
    }

    private String buildURL(String id) {
        return this.buildURL(id, null, null);
    }

    private String buildURL(String id, Reading reading) {
        return this.buildURL(id, null, reading);
    }

    private String buildURL(String id, String connection) {
        return this.buildURL(id, connection, null);
    }

    private String buildURL(String id, String connection, Reading reading) {
        StringBuilder url = new StringBuilder().append(this.conf.getRestBaseURL() + id).append(connection == null ? "" : "/" + connection).append(reading == null ? "" : "?" + reading.getQuery());
        return url.toString();
    }

    private String buildVideoURL(String id, String connection) {
        return this.buildVideoURL(id, connection, null);
    }

    private String buildVideoURL(String id, String connection, Reading reading) {
        StringBuilder url = new StringBuilder().append(this.conf.getVideoBaseURL() + id).append(connection == null ? "" : "/" + connection).append(reading == null ? "" : "?" + reading.getQuery());
        return url.toString();
    }

    private String buildSearchURL(String query, String objectType, Reading reading) {
        String q = null;
        if (query != null) {
            q = HttpParameter.encode(query);
        }
        StringBuilder url = new StringBuilder().append(this.buildURL("search")).append(objectType == null ? "" : "?type=" + objectType).append(q == null ? "" : (objectType == null ? "?q=" + q : "&q=" + q)).append(reading == null ? "" : "&" + reading.getQuery());
        return url.toString();
    }

    @Override
    public User getMe() throws FacebookException {
        return this.getMe(null);
    }

    @Override
    public User getMe(Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        User user = this.factory.createUser(this.get(this.buildURL("me", reading)));
        return user;
    }

    @Override
    public User getUser(String userId) throws FacebookException {
        return this.getUser(userId, null);
    }

    @Override
    public User getUser(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        User user = this.factory.createUser(this.get(this.buildURL(userId, reading)));
        return user;
    }

    @Override
    public URL getPictureURL() throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.getPictureURL("me");
    }

    @Override
    public URL getPictureURL(PictureSize size) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.getPictureURL("me", size);
    }

    @Override
    public URL getPictureURL(String userId) throws FacebookException {
        return this.getPictureURL(userId, null);
    }

    @Override
    public URL getPictureURL(String userId, PictureSize size) throws FacebookException {
        String url = this.buildURL(userId, "picture");
        HttpResponse res = size != null ? this.get(url, new HttpParameter[]{new HttpParameter("type", size.toString())}) : this.get(url);
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    @Override
    public List<User> getUsers(String ... ids) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createUserArray(this.get(this.conf.getRestBaseURL(), new HttpParameter[]{new HttpParameter("ids", z_F4JInternalStringUtil.join(ids))}));
    }

    @Override
    public ResponseList<Account> getAccounts() throws FacebookException {
        return this.getAccounts("me", null);
    }

    @Override
    public ResponseList<Account> getAccounts(Reading reading) throws FacebookException {
        return this.getAccounts("me", reading);
    }

    @Override
    public ResponseList<Account> getAccounts(String userId) throws FacebookException {
        return this.getAccounts(userId, null);
    }

    @Override
    public ResponseList<Account> getAccounts(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAccountList(this.get(this.buildURL(userId, "accounts", reading)));
    }

    @Override
    public ResponseList<Achievement> getAchievements() throws FacebookException {
        return this.getAchievements("me", null);
    }

    @Override
    public ResponseList<Achievement> getAchievements(Reading reading) throws FacebookException {
        return this.getAchievements("me", reading);
    }

    @Override
    public ResponseList<Achievement> getAchievements(String userId) throws FacebookException {
        return this.getAchievements(userId, null);
    }

    @Override
    public ResponseList<Achievement> getAchievements(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAchievementList(this.get(this.buildURL(userId, "achievements", reading)));
    }

    @Override
    public String postAchievement(URL achievementURL) throws FacebookException {
        return this.postAchievement("me", achievementURL);
    }

    @Override
    public String postAchievement(String userId, URL achievementURL) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(userId, "achievements"), new HttpParameter[]{new HttpParameter("achievement", achievementURL.toString())}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public boolean deleteAchievement(URL achievementURL) throws FacebookException {
        return this.deleteAchievement("me", achievementURL);
    }

    @Override
    public boolean deleteAchievement(String userId, URL achievementURL) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(userId, "achievements"), new HttpParameter[]{new HttpParameter("achievement", achievementURL.toString())});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Activity> getActivities() throws FacebookException {
        return this.getActivities("me", null);
    }

    @Override
    public ResponseList<Activity> getActivities(Reading reading) throws FacebookException {
        return this.getActivities("me", reading);
    }

    @Override
    public ResponseList<Activity> getActivities(String userId) throws FacebookException {
        return this.getActivities(userId, null);
    }

    @Override
    public ResponseList<Activity> getActivities(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createActivityList(this.get(this.buildURL(userId, "activities", reading)));
    }

    @Override
    public ResponseList<Album> getAlbums() throws FacebookException {
        return this.getAlbums("me", null);
    }

    @Override
    public ResponseList<Album> getAlbums(Reading reading) throws FacebookException {
        return this.getAlbums("me", reading);
    }

    @Override
    public ResponseList<Album> getAlbums(String userId) throws FacebookException {
        return this.getAlbums(userId, null);
    }

    @Override
    public ResponseList<Album> getAlbums(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAlbumList(this.get(this.buildURL(userId, "albums", reading)));
    }

    @Override
    public Album getAlbum(String albumId) throws FacebookException {
        return this.getAlbum(albumId, null);
    }

    @Override
    public Album getAlbum(String albumId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAlbum(this.get(this.buildURL(albumId, reading)));
    }

    @Override
    public String createAlbum(AlbumCreate albumCreate) throws FacebookException {
        return this.createAlbum("me", albumCreate);
    }

    @Override
    public String createAlbum(String userId, AlbumCreate albumCreate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(userId, "albums"), albumCreate.asHttpParameterArray()).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public ResponseList<Photo> getAlbumPhotos(String albumId) throws FacebookException {
        return this.getAlbumPhotos(albumId, null);
    }

    @Override
    public ResponseList<Photo> getAlbumPhotos(String albumId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhotoList(this.get(this.buildURL(albumId, "photos", reading)));
    }

    @Override
    public String addAlbumPhoto(String albumId, Media source) throws FacebookException {
        return this.addAlbumPhoto(albumId, source, null);
    }

    @Override
    public String addAlbumPhoto(String albumId, Media source, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(source.asHttpParameter("source"));
        if (message != null) {
            httpParams.add(new HttpParameter("message", message));
        }
        JSONObject json = this.post(this.buildURL(albumId, "photos"), httpParams.toArray(new HttpParameter[httpParams.size()])).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public ResponseList<Comment> getAlbumComments(String albumId) throws FacebookException {
        return this.getAlbumComments(albumId, null);
    }

    @Override
    public ResponseList<Comment> getAlbumComments(String albumId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(albumId, reading);
    }

    @Override
    public String commentAlbum(String albumId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(albumId, message);
    }

    @Override
    public ResponseList<Like> getAlbumLikes(String albumId) throws FacebookException {
        return this.getAlbumLikes(albumId, null);
    }

    @Override
    public ResponseList<Like> getAlbumLikes(String albumId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildURL(albumId, "likes", reading)));
    }

    @Override
    public boolean likeAlbum(String albumId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(albumId);
    }

    @Override
    public boolean unlikeAlbum(String albumId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(albumId);
    }

    @Override
    public URL getAlbumCoverPhoto(String albumId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildURL(albumId, "picture"));
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    @Override
    public ResponseList<Book> getBooks() throws FacebookException {
        return this.getBooks("me", null);
    }

    @Override
    public ResponseList<Book> getBooks(Reading reading) throws FacebookException {
        return this.getBooks("me", reading);
    }

    @Override
    public ResponseList<Book> getBooks(String userId) throws FacebookException {
        return this.getBooks(userId, null);
    }

    @Override
    public ResponseList<Book> getBooks(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createBookList(this.get(this.buildURL(userId, "books", reading)));
    }

    @Override
    public ResponseList<Checkin> getCheckins() throws FacebookException {
        return this.getCheckins("me", null);
    }

    @Override
    public ResponseList<Checkin> getCheckins(Reading reading) throws FacebookException {
        return this.getCheckins("me", reading);
    }

    @Override
    public ResponseList<Checkin> getCheckins(String userId) throws FacebookException {
        return this.getCheckins(userId, null);
    }

    @Override
    public ResponseList<Checkin> getCheckins(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createCheckinList(this.get(this.buildURL(userId, "checkins", reading)));
    }

    @Override
    public String checkin(CheckinCreate checkinCreate) throws FacebookException {
        return this.checkin("me", checkinCreate);
    }

    @Override
    public String checkin(String userId, CheckinCreate checkinCreate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(userId, "checkins"), checkinCreate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public Checkin getCheckin(String checkinId) throws FacebookException {
        return this.getCheckin(checkinId, null);
    }

    @Override
    public Checkin getCheckin(String checkinId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createCheckin(this.get(this.buildURL(checkinId, reading)));
    }

    @Override
    public ResponseList<Comment> getCheckinComments(String checkinId) throws FacebookException {
        return this.getCheckinComments(checkinId, null);
    }

    @Override
    public ResponseList<Comment> getCheckinComments(String checkinId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(checkinId, reading);
    }

    @Override
    public String commentCheckin(String checkinId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(checkinId, message);
    }

    @Override
    public ResponseList<Like> getCheckinLikes(String checkinId) throws FacebookException {
        return this.getCheckinLikes(checkinId, null);
    }

    @Override
    public ResponseList<Like> getCheckinLikes(String checkinId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildURL(checkinId, "likes", reading)));
    }

    @Override
    public boolean likeCheckin(String checkinId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(checkinId);
    }

    @Override
    public boolean unlikeCheckin(String checkinId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(checkinId);
    }

    @Override
    public Domain getDomain(String domainId) throws FacebookException {
        return this.factory.createDomain(this.get(this.buildURL(domainId)));
    }

    @Override
    public Domain getDomainByName(String domainName) throws FacebookException {
        return this.factory.createDomain(this.get(this.conf.getRestBaseURL(), new HttpParameter[]{new HttpParameter("domain", domainName)}));
    }

    @Override
    public List<Domain> getDomainsByName(String ... domainName) throws FacebookException {
        String domainNames = z_F4JInternalStringUtil.join(domainName);
        return this.factory.createDomainArray(this.get(this.conf.getRestBaseURL(), new HttpParameter[]{new HttpParameter("domains", domainNames)}));
    }

    @Override
    public ResponseList<Event> getEvents() throws FacebookException {
        return this.getEvents("me", null);
    }

    @Override
    public ResponseList<Event> getEvents(Reading reading) throws FacebookException {
        return this.getEvents("me", reading);
    }

    @Override
    public ResponseList<Event> getEvents(String userId) throws FacebookException {
        return this.getEvents(userId, null);
    }

    @Override
    public ResponseList<Event> getEvents(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createEventList(this.get(this.buildURL(userId, "events", reading)));
    }

    @Override
    public String createEvent(EventUpdate eventUpdate) throws FacebookException {
        return this.createEvent("me", eventUpdate);
    }

    @Override
    public String createEvent(String userId, EventUpdate eventUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(userId, "events"), eventUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public Event getEvent(String eventId) throws FacebookException {
        return this.getEvent(eventId, null);
    }

    @Override
    public Event getEvent(String eventId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildURL(eventId, reading));
        String resStr = res.asString().trim();
        if (resStr.equals("false")) {
            return null;
        }
        return this.factory.createEvent(res);
    }

    @Override
    public boolean editEvent(String eventId, EventUpdate eventUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(eventId), eventUpdate.asHttpParameterArray());
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deleteEvent(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(eventId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Post> getEventFeed(String eventId) throws FacebookException {
        return this.getEventFeed(eventId, null);
    }

    @Override
    public ResponseList<Post> getEventFeed(String eventId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildURL(eventId, reading)));
    }

    @Override
    public String postEventFeed(String eventId, PostUpdate postUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postFeed(eventId, postUpdate);
    }

    @Override
    public String postEventLink(String eventId, URL link) throws FacebookException {
        return this.postEventLink(eventId, link, null);
    }

    @Override
    public String postEventLink(String eventId, URL link, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink(eventId, link, message);
    }

    @Override
    public String postEventStatusMessage(String eventId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postStatusMessage(eventId, message);
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusAsNoreply(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "noreply")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusAsNoreply(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "noreply/" + userId)));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusAsInvited(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "invited")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusAsInvited(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "invited/" + userId)));
    }

    @Override
    public boolean inviteToEvent(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(eventId, "invited/" + userId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean inviteToEvent(String eventId, String[] userIds) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(eventId, "invited"), new HttpParameter[]{new HttpParameter("users", z_F4JInternalStringUtil.join(userIds))});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean uninviteFromEvent(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(eventId, "invited/" + userId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInAttending(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "attnding")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInAttending(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "attending/" + userId)));
    }

    @Override
    public boolean rsvpEventAsAttending(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(eventId, "attending"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInMaybe(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "maybe")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInMaybe(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "maybe/" + userId)));
    }

    @Override
    public boolean rsvpEventAsMaybe(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(eventId, "maybe"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInDeclined(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "declined")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInDeclined(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildURL(eventId, "declined/" + userId)));
    }

    @Override
    public boolean rsvpEventAsDeclined(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(eventId, "declined"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public URL getEventPictureURL(String eventId) throws FacebookException {
        return this.getEventPictureURL(eventId, null);
    }

    @Override
    public URL getEventPictureURL(String eventId, PictureSize size) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getPictureURL(eventId, "picture", size);
    }

    @Override
    public boolean updateEventPicture(String eventId, Media source) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(eventId, "picture"), new HttpParameter[]{source.asHttpParameter("source")});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deleteEventPicture(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(eventId, "picture"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Photo> getEventPhotos(String eventId) throws FacebookException {
        return this.getEventPhotos(eventId, null);
    }

    @Override
    public ResponseList<Photo> getEventPhotos(String eventId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhotoList(this.get(this.buildURL(eventId, "photos", reading)));
    }

    @Override
    public String postEventPhoto(String eventId, Media source) throws FacebookException {
        return this.postEventPhoto(eventId, source, null);
    }

    @Override
    public String postEventPhoto(String eventId, Media source, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpParameter[] httpParameters = new HttpParameter[]{source.asHttpParameter("source")};
        if (message != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("message", message)});
        }
        JSONObject json = this.post(this.buildURL(eventId, "photos"), httpParameters).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public ResponseList<Video> getEventVideos(String eventId) throws FacebookException {
        return this.getEventVideos(eventId, null);
    }

    @Override
    public ResponseList<Video> getEventVideos(String eventId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createVideoList(this.get(this.buildURL(eventId, "videos", reading)));
    }

    @Override
    public String postEventVideo(String eventId, Media source) throws FacebookException {
        return this.postEventVideo(eventId, source, null, null);
    }

    @Override
    public String postEventVideo(String eventId, Media source, String title, String description) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpParameter[] httpParameters = new HttpParameter[]{source.asHttpParameter("source")};
        if (title != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("title", title)});
        }
        if (description != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("description", description)});
        }
        JSONObject json = this.post(this.buildVideoURL(eventId, "videos"), httpParameters).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public ResponseList<Family> getFamily() throws FacebookException {
        return this.getFamily("me", null);
    }

    @Override
    public ResponseList<Family> getFamily(Reading reading) throws FacebookException {
        return this.getFamily("me", reading);
    }

    @Override
    public ResponseList<Family> getFamily(String userId) throws FacebookException {
        return this.getFamily(userId, null);
    }

    @Override
    public ResponseList<Family> getFamily(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFamilyList(this.get(this.buildURL(userId, "family", reading)));
    }

    @Override
    public ResponseList<Post> getFeed() throws FacebookException {
        return this.getFeed("me", null);
    }

    @Override
    public ResponseList<Post> getFeed(Reading reading) throws FacebookException {
        return this.getFeed("me", reading);
    }

    @Override
    public ResponseList<Post> getFeed(String userId) throws FacebookException {
        return this.getFeed(userId, null);
    }

    @Override
    public ResponseList<Post> getFeed(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildURL(userId, "feed", reading)));
    }

    @Override
    public ResponseList<Post> getHome() throws FacebookException {
        return this.getHome(null);
    }

    @Override
    public ResponseList<Post> getHome(Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildURL("me", "home", reading)));
    }

    @Override
    public ResponseList<Post> getPosts() throws FacebookException {
        return this.getPosts("me", null);
    }

    @Override
    public ResponseList<Post> getPosts(Reading reading) throws FacebookException {
        return this.getPosts("me", reading);
    }

    @Override
    public ResponseList<Post> getPosts(String userId) throws FacebookException {
        return this.getPosts(userId, null);
    }

    @Override
    public ResponseList<Post> getPosts(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildURL(userId, "posts", reading)));
    }

    @Override
    public ResponseList<Post> getStatuses() throws FacebookException {
        return this.getStatuses("me", null);
    }

    @Override
    public ResponseList<Post> getStatuses(Reading reading) throws FacebookException {
        return this.getStatuses("me", reading);
    }

    @Override
    public ResponseList<Post> getStatuses(String userId) throws FacebookException {
        return this.getStatuses(userId, null);
    }

    @Override
    public ResponseList<Post> getStatuses(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildURL(userId, "statuses", reading)));
    }

    @Override
    public Post getPost(String postId) throws FacebookException {
        return this.getPost(postId, null);
    }

    @Override
    public Post getPost(String postId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPost(this.get(this.buildURL(postId, reading)));
    }

    @Override
    public boolean deletePost(String postId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(postId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Comment> getPostComments(String postId) throws FacebookException {
        return this.getPostComments(postId, null);
    }

    @Override
    public ResponseList<Comment> getPostComments(String postId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(postId, reading);
    }

    @Override
    public String commentPost(String postId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(postId, message);
    }

    @Override
    public ResponseList<Like> getPostLikes(String postId) throws FacebookException {
        return this.getPostLikes(postId, null);
    }

    @Override
    public ResponseList<Like> getPostLikes(String postId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildURL(postId, "likes", reading)));
    }

    @Override
    public boolean likePost(String postId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(postId);
    }

    @Override
    public boolean unlikePost(String postId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(postId);
    }

    public ResponseList<Insight> getPostInsights(String postId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInsightList(this.get(this.buildURL(postId, "insights")));
    }

    @Override
    public String postFeed(PostUpdate postUpdate) throws FacebookException {
        return this.postFeed("me", postUpdate);
    }

    @Override
    public String postFeed(String userId, PostUpdate postUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postFeed(userId, postUpdate);
    }

    @Override
    public String postStatusMessage(String message) throws FacebookException {
        return this.postStatusMessage("me", message);
    }

    @Override
    public String postStatusMessage(String userId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postStatusMessage(userId, message);
    }

    @Override
    public ResponseList<Post> getTagged() throws FacebookException {
        return this.getTagged("me", null);
    }

    @Override
    public ResponseList<Post> getTagged(Reading reading) throws FacebookException {
        return this.getTagged("me", reading);
    }

    @Override
    public ResponseList<Post> getTagged(String userId) throws FacebookException {
        return this.getTagged(userId, null);
    }

    @Override
    public ResponseList<Post> getTagged(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildURL(userId, "tagged", reading)));
    }

    @Override
    public ResponseList<Friendlist> getFriendlists() throws FacebookException {
        return this.getFriendlists("me", null);
    }

    @Override
    public ResponseList<Friendlist> getFriendlists(Reading reading) throws FacebookException {
        return this.getFriendlists("me", reading);
    }

    @Override
    public ResponseList<Friendlist> getFriendlists(String userId) throws FacebookException {
        return this.getFriendlists(userId, null);
    }

    @Override
    public ResponseList<Friendlist> getFriendlists(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendlistList(this.get(this.buildURL(userId, "friendlists", reading)));
    }

    @Override
    public ResponseList<FriendRequest> getFriendRequests() throws FacebookException {
        return this.getFriendRequests("me", null);
    }

    @Override
    public ResponseList<FriendRequest> getFriendRequests(Reading reading) throws FacebookException {
        return this.getFriendRequests("me", reading);
    }

    @Override
    public ResponseList<FriendRequest> getFriendRequests(String userId) throws FacebookException {
        return this.getFriendRequests(userId, null);
    }

    @Override
    public ResponseList<FriendRequest> getFriendRequests(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendRequestList(this.get(this.buildURL(userId, "friendrequests", reading)));
    }

    @Override
    public ResponseList<Friend> getFriends() throws FacebookException {
        return this.getFriends("me", null);
    }

    @Override
    public ResponseList<Friend> getFriends(Reading reading) throws FacebookException {
        return this.getFriends("me", reading);
    }

    @Override
    public ResponseList<Friend> getFriends(String userId) throws FacebookException {
        return this.getFriends(userId, null);
    }

    @Override
    public ResponseList<Friend> getFriends(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendList(this.get(this.buildURL(userId, "friends", reading)));
    }

    @Override
    public ResponseList<Friend> getMutualFriends(String friendUserId) throws FacebookException {
        return this.getMutualFriends("me", friendUserId, null);
    }

    @Override
    public ResponseList<Friend> getMutualFriends(String friendUserId, Reading reading) throws FacebookException {
        return this.getMutualFriends("me", friendUserId, reading);
    }

    @Override
    public ResponseList<Friend> getMutualFriends(String userId1, String userId2) throws FacebookException {
        return this.getMutualFriends(userId1, userId2, null);
    }

    @Override
    public ResponseList<Friend> getMutualFriends(String userId1, String userId2, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendList(this.get(this.buildURL(userId1, "mutualfriends/" + userId2, reading)));
    }

    @Override
    public String createFriendlist(String friendlistName) throws FacebookException {
        return this.createFriendlist("me", friendlistName);
    }

    @Override
    public String createFriendlist(String userId, String friendlistName) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(userId, "friendlists"), new HttpParameter[]{new HttpParameter("name", friendlistName)}).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public boolean deleteFriendlist(String friendlistId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(friendlistId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean addFriendlistMember(String friendlistId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(friendlistId + "/members/" + userId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean removeFriendlistMember(String friendlistId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(friendlistId + "/members/" + userId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public Friendlist getFriendlist(String friendlistId) throws FacebookException {
        return this.getFriendlist(friendlistId, null);
    }

    @Override
    public Friendlist getFriendlist(String friendlistId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendlist(this.get(this.buildURL(friendlistId, reading)));
    }

    @Override
    public ResponseList<Friend> getFriendlistMembers(String friendlistId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendList(this.get(this.buildURL(friendlistId)));
    }

    @Override
    public ResponseList<Friend> getBelongsFriend(String friendId) throws FacebookException {
        return this.getBelongsFriend("me", friendId);
    }

    @Override
    public ResponseList<Friend> getBelongsFriend(String friendId, Reading reading) throws FacebookException {
        return this.getBelongsFriend("me", friendId, reading);
    }

    @Override
    public ResponseList<Friend> getBelongsFriend(String userId, String friendId) throws FacebookException {
        return this.getBelongsFriend(userId, friendId, null);
    }

    @Override
    public ResponseList<Friend> getBelongsFriend(String userId, String friendId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendList(this.get(this.buildURL(userId, "friends/" + friendId, reading)));
    }

    @Override
    public ResponseList<Game> getGames() throws FacebookException {
        return this.getGames("me", null);
    }

    @Override
    public ResponseList<Game> getGames(Reading reading) throws FacebookException {
        return this.getGames("me", reading);
    }

    @Override
    public ResponseList<Game> getGames(String userId) throws FacebookException {
        return this.getGames(userId, null);
    }

    @Override
    public ResponseList<Game> getGames(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGameList(this.get(this.buildURL(userId, "games", reading)));
    }

    @Override
    public ResponseList<Movie> getMovies() throws FacebookException {
        return this.getMovies("me", null);
    }

    @Override
    public ResponseList<Movie> getMovies(Reading reading) throws FacebookException {
        return this.getMovies("me", reading);
    }

    @Override
    public ResponseList<Movie> getMovies(String userId) throws FacebookException {
        return this.getMovies(userId, null);
    }

    @Override
    public ResponseList<Movie> getMovies(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMovieList(this.get(this.buildURL(userId, "movies", reading)));
    }

    @Override
    public ResponseList<Music> getMusic() throws FacebookException {
        return this.getMusic("me", null);
    }

    @Override
    public ResponseList<Music> getMusic(Reading reading) throws FacebookException {
        return this.getMusic("me", reading);
    }

    @Override
    public ResponseList<Music> getMusic(String userId) throws FacebookException {
        return this.getMusic(userId, null);
    }

    @Override
    public ResponseList<Music> getMusic(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMusicList(this.get(this.buildURL(userId, "music", reading)));
    }

    @Override
    public ResponseList<Television> getTelevision() throws FacebookException {
        return this.getTelevision("me", null);
    }

    @Override
    public ResponseList<Television> getTelevision(Reading reading) throws FacebookException {
        return this.getTelevision("me", reading);
    }

    @Override
    public ResponseList<Television> getTelevision(String userId) throws FacebookException {
        return this.getTelevision(userId, null);
    }

    @Override
    public ResponseList<Television> getTelevision(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createTelevisionList(this.get(this.buildURL(userId, "television", reading)));
    }

    @Override
    public ResponseList<Interest> getInterests() throws FacebookException {
        return this.getInterests("me", null);
    }

    @Override
    public ResponseList<Interest> getInterests(Reading reading) throws FacebookException {
        return this.getInterests("me", reading);
    }

    @Override
    public ResponseList<Interest> getInterests(String userId) throws FacebookException {
        return this.getInterests(userId, null);
    }

    @Override
    public ResponseList<Interest> getInterests(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInterestList(this.get(this.buildURL(userId, "interests", reading)));
    }

    @Override
    public ResponseList<Group> getGroups() throws FacebookException {
        return this.getGroups("me", null);
    }

    @Override
    public ResponseList<Group> getGroups(Reading reading) throws FacebookException {
        return this.getGroups("me", reading);
    }

    @Override
    public ResponseList<Group> getGroups(String userId) throws FacebookException {
        return this.getGroups(userId, null);
    }

    @Override
    public ResponseList<Group> getGroups(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGroupList(this.get(this.buildURL(userId, "groups", reading)));
    }

    @Override
    public Group getGroup(String groupId) throws FacebookException {
        return this.getGroup(groupId, null);
    }

    @Override
    public Group getGroup(String groupId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGroup(this.get(this.buildURL(groupId, reading)));
    }

    @Override
    public ResponseList<Post> getGroupFeed(String groupId) throws FacebookException {
        return this.getGroupFeed(groupId, null);
    }

    @Override
    public ResponseList<Post> getGroupFeed(String groupId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildURL(groupId, "feed", reading)));
    }

    @Override
    public ResponseList<GroupMember> getGroupMembers(String groupId) throws FacebookException {
        return this.getGroupMembers(groupId, null);
    }

    @Override
    public ResponseList<GroupMember> getGroupMembers(String groupId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGroupMemberList(this.get(this.buildURL(groupId, "members", reading)));
    }

    @Override
    public URL getGroupPictureURL(String groupId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildURL(groupId, "picture"));
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    @Override
    public ResponseList<GroupDoc> getGroupDocs(String groupId) throws FacebookException {
        return this.getGroupDocs(groupId, null);
    }

    @Override
    public ResponseList<GroupDoc> getGroupDocs(String groupId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGroupDocList(this.get(this.buildURL(groupId, "docs", reading)));
    }

    @Override
    public String postGroupLink(String groupId, URL linkURL) throws FacebookException {
        return this.postGroupLink(groupId, linkURL, null);
    }

    @Override
    public String postGroupLink(String groupId, URL linkURL, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpParameter[] httpParameters = new HttpParameter[]{new HttpParameter("link", linkURL.toString())};
        if (message != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("message", message)});
        }
        JSONObject json = this.post(this.buildURL(groupId, "feed"), httpParameters).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public String postGroupFeed(String groupId, PostUpdate postUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(groupId, "feed"), postUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public String postGroupStatusMessage(String groupId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(groupId, "feed"), new HttpParameter[]{new HttpParameter("message", message)}).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public InboxResponseList<Inbox> getInbox() throws FacebookException {
        return this.getInbox("me", null);
    }

    @Override
    public InboxResponseList<Inbox> getInbox(Reading reading) throws FacebookException {
        return this.getInbox("me", reading);
    }

    @Override
    public InboxResponseList<Inbox> getInbox(String userId) throws FacebookException {
        return this.getInbox(userId, null);
    }

    @Override
    public InboxResponseList<Inbox> getInbox(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInboxList(this.get(this.buildURL(userId, "inbox", reading)));
    }

    @Override
    public ResponseList<Message> getOutbox() throws FacebookException {
        return this.getOutbox("me", null);
    }

    @Override
    public ResponseList<Message> getOutbox(Reading reading) throws FacebookException {
        return this.getOutbox("me", reading);
    }

    @Override
    public ResponseList<Message> getOutbox(String userId) throws FacebookException {
        return this.getOutbox(userId, null);
    }

    @Override
    public ResponseList<Message> getOutbox(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMessageList(this.get(this.buildURL(userId, "outbox", reading)));
    }

    @Override
    public ResponseList<Message> getUpdates() throws FacebookException {
        return this.getUpdates("me", null);
    }

    @Override
    public ResponseList<Message> getUpdates(Reading reading) throws FacebookException {
        return this.getUpdates("me", reading);
    }

    @Override
    public ResponseList<Message> getUpdates(String userId) throws FacebookException {
        return this.getUpdates(userId, null);
    }

    @Override
    public ResponseList<Message> getUpdates(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMessageList(this.get(this.buildURL(userId, "updates", reading)));
    }

    @Override
    public Message getMessage(String messageId) throws FacebookException {
        return this.getMessage(messageId, null);
    }

    @Override
    public Message getMessage(String messageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMessage(this.get(this.buildURL(messageId, reading)));
    }

    @Override
    public ResponseList<Like> getUserLikes() throws FacebookException {
        return this._getLikes("me", null);
    }

    @Override
    public ResponseList<Like> getUserLikes(Reading reading) throws FacebookException {
        return this._getLikes("me", reading);
    }

    @Override
    public ResponseList<Like> getUserLikes(String userId) throws FacebookException {
        return this._getLikes(userId, null);
    }

    @Override
    public ResponseList<Like> getUserLikes(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildURL(userId, "likes", reading)));
    }

    public ResponseList<Like> getLikesBelongs(String pageId) throws FacebookException {
        return this.getLikesBelongs("me", pageId, null);
    }

    public ResponseList<Like> getLikesBelongs(String pageId, Reading reading) throws FacebookException {
        return this.getLikesBelongs("me", pageId, reading);
    }

    public ResponseList<Like> getLikesBelongs(String userId, String pageId) throws FacebookException {
        return this.getLikesBelongs(userId, pageId, null);
    }

    public ResponseList<Like> getLikesBelongs(String userId, String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildURL(userId, "likes/" + pageId, reading)));
    }

    @Override
    public Comment getComment(String commentId) throws FacebookException {
        return this.factory.createComment(this.get(this.buildURL(commentId)));
    }

    @Override
    public boolean deleteComment(String commentId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(commentId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Like> getCommentLikes(String commentId) throws FacebookException {
        return this.getCommentLikes(commentId, null);
    }

    @Override
    public ResponseList<Like> getCommentLikes(String commentId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildURL(commentId, "likes", reading)));
    }

    @Override
    public boolean likeComment(String commentId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(commentId);
    }

    @Override
    public boolean unlikeComment(String commentId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(commentId);
    }

    @Override
    public ResponseList<Link> getLinks() throws FacebookException {
        return this.getLinks("me", null);
    }

    @Override
    public ResponseList<Link> getLinks(Reading reading) throws FacebookException {
        return this.getLinks("me", reading);
    }

    @Override
    public ResponseList<Link> getLinks(String userId) throws FacebookException {
        return this.getLinks(userId, null);
    }

    @Override
    public ResponseList<Link> getLinks(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLinkList(this.get(this.buildURL(userId, "links", reading)));
    }

    @Override
    public Link getLink(String linkId) throws FacebookException {
        return this.getLink(linkId, null);
    }

    @Override
    public Link getLink(String linkId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLink(this.get(this.buildURL(linkId, reading)));
    }

    @Override
    public ResponseList<Comment> getLinkComments(String linkId) throws FacebookException {
        return this.getLinkComments(linkId, null);
    }

    @Override
    public ResponseList<Comment> getLinkComments(String linkId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(linkId, reading);
    }

    @Override
    public String commentLink(String linkId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(linkId, message);
    }

    @Override
    public ResponseList<Like> getLinkLikes(String linkId) throws FacebookException {
        return this.getLinkLikes(linkId, null);
    }

    @Override
    public ResponseList<Like> getLinkLikes(String linkId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getLikes(linkId, reading);
    }

    @Override
    public boolean likeLink(String linkId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(linkId);
    }

    @Override
    public boolean unlikeLink(String linkId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(linkId);
    }

    @Override
    public String postLink(URL link) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink("me", link, null);
    }

    @Override
    public String postLink(URL link, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink("me", link, message);
    }

    @Override
    public String postLink(String userId, URL link) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink(userId, link, null);
    }

    @Override
    public String postLink(String userId, URL link, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink(userId, link, message);
    }

    @Override
    public ResponseList<Location> getLocations() throws FacebookException {
        return this.getLocations("me", null);
    }

    @Override
    public ResponseList<Location> getLocations(Reading reading) throws FacebookException {
        return this.getLocations("me", reading);
    }

    @Override
    public ResponseList<Location> getLocations(String userId) throws FacebookException {
        return this.getLocations(userId, null);
    }

    @Override
    public ResponseList<Location> getLocations(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLocationList(this.get(this.buildURL(userId, "locations", reading)));
    }

    @Override
    public ResponseList<Note> getNotes() throws FacebookException {
        return this.getNotes("me", null);
    }

    @Override
    public ResponseList<Note> getNotes(Reading reading) throws FacebookException {
        return this.getNotes("me", reading);
    }

    @Override
    public ResponseList<Note> getNotes(String userId) throws FacebookException {
        return this.getNotes(userId, null);
    }

    @Override
    public ResponseList<Note> getNotes(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createNoteList(this.get(this.buildURL(userId, "notes", reading)));
    }

    @Override
    public String createNote(String subject, String message) throws FacebookException {
        return this.createNote("me", subject, message);
    }

    @Override
    public String createNote(String userId, String subject, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(userId, "notes"), new HttpParameter[]{new HttpParameter("subject", subject), new HttpParameter("message", message)}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public Note getNote(String noteId) throws FacebookException {
        return this.getNote(noteId, null);
    }

    @Override
    public Note getNote(String noteId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createNote(this.get(this.buildURL(noteId, reading)));
    }

    @Override
    public ResponseList<Comment> getNoteComments(String noteId) throws FacebookException {
        return this.getNoteComments(noteId, null);
    }

    @Override
    public ResponseList<Comment> getNoteComments(String noteId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(noteId, reading);
    }

    @Override
    public String commentNote(String noteId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(noteId, message);
    }

    @Override
    public ResponseList<Like> getNoteLikes(String noteId) throws FacebookException {
        return this.getNoteLikes(noteId, null);
    }

    @Override
    public ResponseList<Like> getNoteLikes(String noteId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getLikes(noteId, reading);
    }

    @Override
    public boolean likeNote(String noteId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(noteId);
    }

    @Override
    public boolean unlikeNote(String noteId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(noteId);
    }

    @Override
    public ResponseList<Notification> getNotifications() throws FacebookException {
        return this.getNotifications("me", null);
    }

    @Override
    public ResponseList<Notification> getNotifications(boolean includeRead) throws FacebookException {
        return this.getNotifications("me", null, includeRead);
    }

    @Override
    public ResponseList<Notification> getNotifications(Reading reading) throws FacebookException {
        return this.getNotifications("me", reading);
    }

    @Override
    public ResponseList<Notification> getNotifications(Reading reading, boolean includeRead) throws FacebookException {
        return this.getNotifications("me", reading, includeRead);
    }

    @Override
    public ResponseList<Notification> getNotifications(String userId) throws FacebookException {
        return this.getNotifications(userId, null);
    }

    @Override
    public ResponseList<Notification> getNotifications(String userId, boolean includeRead) throws FacebookException {
        return this.getNotifications(userId, null, includeRead);
    }

    @Override
    public ResponseList<Notification> getNotifications(String userId, Reading reading) throws FacebookException {
        return this.getNotifications(userId, reading, false);
    }

    @Override
    public ResponseList<Notification> getNotifications(String userId, Reading reading, boolean includeRead) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String url = this.buildURL(userId, "notifications", reading);
        HttpResponse res = includeRead ? this.get(url, new HttpParameter[]{new HttpParameter("include_read", 1)}) : this.get(url);
        return this.factory.createNotificationList(res);
    }

    @Override
    public boolean markNotificationAsRead(String notificationId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(notificationId), new HttpParameter[]{new HttpParameter("unread", 0)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public List<Permission> getPermissions() throws FacebookException {
        return this.getPermissions("me");
    }

    @Override
    public List<Permission> getPermissions(String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPermissions(this.get(this.buildURL(userId, "permissions")));
    }

    @Override
    public boolean revokePermission(String permissionName) throws FacebookException {
        return this.revokePermission("me", permissionName);
    }

    @Override
    public boolean revokePermission(String userId, String permissionName) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(userId, "permissions/" + permissionName));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Photo> getPhotos() throws FacebookException {
        return this.getPhotos("me", null);
    }

    @Override
    public ResponseList<Photo> getPhotos(Reading reading) throws FacebookException {
        return this.getPhotos("me", reading);
    }

    @Override
    public ResponseList<Photo> getPhotos(String userId) throws FacebookException {
        return this.getPhotos(userId, null);
    }

    @Override
    public ResponseList<Photo> getPhotos(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhotoList(this.get(this.buildURL(userId, "photos", reading)));
    }

    @Override
    public Photo getPhoto(String photoId) throws FacebookException {
        return this.getPhoto(photoId, null);
    }

    @Override
    public Photo getPhoto(String photoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhoto(this.get(this.buildURL(photoId, reading)));
    }

    @Override
    public ResponseList<Comment> getPhotoComments(String photoId) throws FacebookException {
        return this.getPhotoComments(photoId, null);
    }

    @Override
    public ResponseList<Comment> getPhotoComments(String photoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(photoId, reading);
    }

    @Override
    public String commentPhoto(String photoId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(photoId, message);
    }

    @Override
    public ResponseList<Like> getPhotoLikes(String photoId) throws FacebookException {
        return this.getPhotoLikes(photoId, null);
    }

    @Override
    public ResponseList<Like> getPhotoLikes(String photoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getLikes(photoId, reading);
    }

    @Override
    public boolean likePhoto(String photoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(photoId);
    }

    @Override
    public boolean unlikePhoto(String photoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(photoId);
    }

    @Override
    public URL getPhotoURL(String photoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildURL(photoId, "picture"));
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    @Override
    public ResponseList<Tag> getTagsOnPhoto(String photoId) throws FacebookException {
        return this.getTagsOnPhoto(photoId, null);
    }

    @Override
    public ResponseList<Tag> getTagsOnPhoto(String photoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createTagList(this.get(this.buildURL(photoId, reading)));
    }

    @Override
    public boolean addTagToPhoto(String photoId, String toUserId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(photoId, "tags"), new HttpParameter[]{new HttpParameter("to", toUserId)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean addTagToPhoto(String photoId, TagUpdate tagUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(photoId, "tags"), tagUpdate.asHttpParameterArray());
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean addTagToPhoto(String photoId, List<String> toUserIds) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(photoId, "tags"), new HttpParameter[]{new HttpParameter("tags", new JSONArray(toUserIds).toString())});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean updateTagOnPhoto(String photoId, String toUserId) throws FacebookException {
        return this.addTagToPhoto(photoId, toUserId);
    }

    @Override
    public boolean updateTagOnPhoto(String photoId, TagUpdate tagUpdate) throws FacebookException {
        return this.addTagToPhoto(photoId, tagUpdate);
    }

    @Override
    public String postPhoto(Media source) throws FacebookException {
        return this.postPhoto("me", source);
    }

    @Override
    public String postPhoto(Media source, String message, String place, boolean noStory) throws FacebookException {
        return this.postPhoto("me", source, message, place, noStory);
    }

    @Override
    public String postPhoto(String userId, Media source) throws FacebookException {
        return this.postPhoto(userId, source, null, null, false);
    }

    @Override
    public String postPhoto(String userId, Media source, String message, String place, boolean noStory) throws FacebookException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(source.asHttpParameter("source"));
        if (message != null) {
            params.add(new HttpParameter("message", message));
        }
        if (place != null) {
            params.add(new HttpParameter("place", place));
        }
        if (noStory) {
            params.add(new HttpParameter("no_story", 1));
        }
        HttpParameter[] httpParameters = params.toArray(new HttpParameter[params.size()]);
        JSONObject json = this.post(this.buildURL(userId, "photos"), httpParameters).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public boolean deletePhoto(String photoId) throws FacebookException {
        HttpResponse res = this.delete(this.buildURL(photoId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Poke> getPokes() throws FacebookException {
        return this.getPokes("me", null);
    }

    @Override
    public ResponseList<Poke> getPokes(Reading reading) throws FacebookException {
        return this.getPokes("me", reading);
    }

    @Override
    public ResponseList<Poke> getPokes(String userId) throws FacebookException {
        return this.getPokes(userId, null);
    }

    @Override
    public ResponseList<Poke> getPokes(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPokeList(this.get(this.buildURL(userId, "pokes", reading)));
    }

    @Override
    public ResponseList<Question> getQuestions() throws FacebookException {
        return this.getQuestions("me", null);
    }

    @Override
    public ResponseList<Question> getQuestions(Reading reading) throws FacebookException {
        return this.getQuestions("me", reading);
    }

    @Override
    public ResponseList<Question> getQuestions(String userId) throws FacebookException {
        return this.getQuestions(userId, null);
    }

    @Override
    public ResponseList<Question> getQuestions(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createQuestionList(this.get(this.buildURL(userId, "questions", reading)));
    }

    @Override
    public Question getQuestion(String questionId) throws FacebookException {
        return this.getQuestion(questionId, null);
    }

    @Override
    public Question getQuestion(String questionId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createQuestion(this.get(this.buildURL(questionId, reading)));
    }

    @Override
    public String createQuestion(String question) throws FacebookException {
        return this.createQuestion(question, null, false);
    }

    @Override
    public String createQuestion(String userId, String question) throws FacebookException {
        return this.createQuestion(userId, question, null, false);
    }

    @Override
    public String createQuestion(String question, List<String> options, boolean allowNewOptions) throws FacebookException {
        return this.createQuestion("me", question, options, allowNewOptions);
    }

    @Override
    public String createQuestion(String userId, String question, List<String> options, boolean allowNewOptions) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpParameter[] httpParameters = new HttpParameter[]{new HttpParameter("question", question), new HttpParameter("allow_new_options", allowNewOptions)};
        if (options != null && options.size() != 0) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("options", new JSONArray(options).toString())});
        }
        JSONObject json = this.post(this.buildURL(userId, "questions"), httpParameters).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public boolean deleteQuestion(String questionId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(questionId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Question.Option> getQuestionOptions(String questionId) throws FacebookException {
        return this.getQuestionOptions(questionId, null);
    }

    @Override
    public ResponseList<Question.Option> getQuestionOptions(String questionId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createQuestionOptionList(this.get(this.buildURL(questionId, "options", reading)));
    }

    @Override
    public String addQuestionOption(String questionId, String optionDescription) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(questionId, "options"), new HttpParameter[]{new HttpParameter("option", optionDescription)}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public ResponseList<QuestionVotes> getQuestionOptionVotes(String questionId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        Reading reading = new Reading().fields("votes");
        return this.factory.createQuestionVotesList(this.get(this.buildURL(questionId, "options", reading)));
    }

    @Override
    public ResponseList<Score> getScores() throws FacebookException {
        return this.getScores("me", null);
    }

    @Override
    public ResponseList<Score> getScores(Reading reading) throws FacebookException {
        return this.getScores("me", reading);
    }

    @Override
    public ResponseList<Score> getScores(String userId) throws FacebookException {
        return this.getScores(userId, null);
    }

    @Override
    public ResponseList<Score> getScores(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createScoreList(this.get(this.buildURL(userId, "scores", reading)));
    }

    @Override
    public boolean postScore(int scoreValue) throws FacebookException {
        return this.postScore("me", scoreValue);
    }

    @Override
    public boolean postScore(String userId, int scoreValue) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(userId, "scores"), new HttpParameter[]{new HttpParameter("score", scoreValue)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deleteScore() throws FacebookException {
        return this.deleteScore("me");
    }

    @Override
    public boolean deleteScore(String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(userId, "scores"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Subscribedto> getSubscribedto() throws FacebookException {
        return this.getSubscribedto("me", null);
    }

    @Override
    public ResponseList<Subscribedto> getSubscribedto(Reading reading) throws FacebookException {
        return this.getSubscribedto("me", reading);
    }

    @Override
    public ResponseList<Subscribedto> getSubscribedto(String userId) throws FacebookException {
        return this.getSubscribedto(userId, null);
    }

    @Override
    public ResponseList<Subscribedto> getSubscribedto(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createSubscribedtoList(this.get(this.buildURL(userId, "subscribedto", reading)));
    }

    @Override
    public ResponseList<Subscriber> getSubscribers() throws FacebookException {
        return this.getSubscribers("me", null);
    }

    @Override
    public ResponseList<Subscriber> getSubscribers(Reading reading) throws FacebookException {
        return this.getSubscribers("me", reading);
    }

    @Override
    public ResponseList<Subscriber> getSubscribers(String userId) throws FacebookException {
        return this.getSubscribers(userId, null);
    }

    @Override
    public ResponseList<Subscriber> getSubscribers(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createSubscriberList(this.get(this.buildURL(userId, "subscribers", reading)));
    }

    @Override
    public ResponseList<Video> getVideos() throws FacebookException {
        return this.getVideos("me", null);
    }

    @Override
    public ResponseList<Video> getVideos(Reading reading) throws FacebookException {
        return this.getVideos("me", reading);
    }

    @Override
    public ResponseList<Video> getVideos(String userId) throws FacebookException {
        return this.getVideos(userId, null);
    }

    @Override
    public ResponseList<Video> getVideos(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createVideoList(this.get(this.buildURL(userId, "videos", reading)));
    }

    @Override
    public String postVideo(Media source) throws FacebookException {
        return this.postVideo("me", source);
    }

    @Override
    public String postVideo(Media source, String title, String description) throws FacebookException {
        return this.postVideo("me", source, title, description);
    }

    @Override
    public String postVideo(String userId, Media source) throws FacebookException {
        return this.postVideo(userId, source, null, null);
    }

    @Override
    public String postVideo(String userId, Media source, String title, String description) throws FacebookException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(source.asHttpParameter("source"));
        if (title != null) {
            params.add(new HttpParameter("title", title));
        }
        if (description != null) {
            params.add(new HttpParameter("description", description));
        }
        HttpParameter[] httpParameters = params.toArray(new HttpParameter[params.size()]);
        JSONObject json = this.post(this.buildVideoURL(userId, "videos"), httpParameters).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public Video getVideo(String videoId) throws FacebookException {
        return this.getVideo(videoId, null);
    }

    @Override
    public Video getVideo(String videoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createVideo(this.get(this.buildURL(videoId, reading)));
    }

    @Override
    public ResponseList<Like> getVideoLikes(String videoId) throws FacebookException {
        return this.getVideoLikes(videoId, null);
    }

    @Override
    public ResponseList<Like> getVideoLikes(String videoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getLikes(videoId, reading);
    }

    @Override
    public boolean likeVideo(String videoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(videoId);
    }

    @Override
    public boolean unlikeVideo(String videoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(videoId);
    }

    @Override
    public ResponseList<Comment> getVideoComments(String videoId) throws FacebookException {
        return this.getVideoComments(videoId, null);
    }

    @Override
    public ResponseList<Comment> getVideoComments(String videoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(videoId, reading);
    }

    @Override
    public String commentVideo(String videoId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(videoId, message);
    }

    @Override
    public URL getVideoCover(String videoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getPictureURL(videoId, "picture", null);
    }

    @Override
    public ResponseList<Insight> getInsights(String objectId, String metric) throws FacebookException {
        return this.getInsights(objectId, metric, null);
    }

    @Override
    public ResponseList<Insight> getInsights(String objectId, String metric, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInsightList(this.get(this.buildURL(objectId, "insights/" + metric, reading)));
    }

    @Override
    public ResponseList<Post> searchPosts(String query) throws FacebookException {
        return this.searchPosts(query, null);
    }

    @Override
    public ResponseList<Post> searchPosts(String query, Reading reading) throws FacebookException {
        return this.factory.createPostList(this.get(this.buildSearchURL(query, "post", reading)));
    }

    @Override
    public ResponseList<User> searchUsers(String query) throws FacebookException {
        return this.searchUsers(query, null);
    }

    @Override
    public ResponseList<User> searchUsers(String query, Reading reading) throws FacebookException {
        return this.factory.createUserList(this.get(this.buildSearchURL(query, "user", reading)));
    }

    @Override
    public ResponseList<Event> searchEvents(String query) throws FacebookException {
        return this.searchEvents(query, null);
    }

    @Override
    public ResponseList<Event> searchEvents(String query, Reading reading) throws FacebookException {
        return this.factory.createEventList(this.get(this.buildSearchURL(query, "event", reading)));
    }

    @Override
    public ResponseList<Group> searchGroups(String query) throws FacebookException {
        return this.searchGroups(query, null);
    }

    @Override
    public ResponseList<Group> searchGroups(String query, Reading reading) throws FacebookException {
        return this.factory.createGroupList(this.get(this.buildSearchURL(query, "group", reading)));
    }

    @Override
    public ResponseList<Place> searchPlaces(String query) throws FacebookException {
        return this.searchPlaces(query, null);
    }

    @Override
    public ResponseList<Place> searchPlaces(String query, Reading reading) throws FacebookException {
        return this.factory.createPlaceList(this.get(this.buildSearchURL(query, "place", reading)));
    }

    @Override
    public ResponseList<Place> searchPlaces(String query, GeoLocation center, int distance) throws FacebookException {
        return this.searchPlaces(query, center, distance, null);
    }

    @Override
    public ResponseList<Place> searchPlaces(String query, GeoLocation center, int distance, Reading reading) throws FacebookException {
        String url = this.buildSearchURL(query, "place", reading) + "&center=" + center.asParameterString() + "&distance=" + distance;
        return this.factory.createPlaceList(this.get(url));
    }

    @Override
    public ResponseList<Checkin> searchCheckins() throws FacebookException {
        return this.searchCheckins(null);
    }

    @Override
    public ResponseList<Checkin> searchCheckins(Reading reading) throws FacebookException {
        return this.factory.createCheckinList(this.get(this.buildSearchURL(null, "checkin", reading)));
    }

    @Override
    public ResponseList<Location> searchLocations(GeoLocation center, int distance) throws FacebookException {
        return this.searchLocations(center, distance, null);
    }

    @Override
    public ResponseList<Location> searchLocations(GeoLocation center, int distance, Reading reading) throws FacebookException {
        String url = this.buildSearchURL(null, "location", reading) + "&center=" + center.asParameterString() + "&distance=" + distance;
        return this.factory.createLocationList(this.get(url));
    }

    @Override
    public ResponseList<Location> searchLocations(String placeId) throws FacebookException {
        return this.searchLocations(placeId, null);
    }

    @Override
    public ResponseList<Location> searchLocations(String placeId, Reading reading) throws FacebookException {
        String url = this.buildSearchURL(null, "location", reading) + "&place=" + placeId;
        return this.factory.createLocationList(this.get(url));
    }

    @Override
    public ResponseList<JSONObject> search(String query) throws FacebookException {
        return this.search(query, null);
    }

    @Override
    public ResponseList<JSONObject> search(String query, Reading reading) throws FacebookException {
        String url = this.buildSearchURL(query, null, reading);
        return this.factory.createJSONObjectList(this.get(url));
    }

    @Override
    public JSONArray executeFQL(String query) throws FacebookException {
        return this.executeFQL(query, null);
    }

    @Override
    public JSONArray executeFQL(String query, Locale locale) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String url = "";
        try {
            url = this.conf.getRestBaseURL() + "fql?q=" + URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
        if (locale != null) {
            url = url + "&locale=" + HttpParameter.encode(locale.toString());
        }
        JSONObject json = this.get(url).asJSONObject();
        try {
            return json.getJSONArray("data");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public Map<String, JSONArray> executeMultiFQL(Map<String, String> queries) throws FacebookException {
        return this.executeMultiFQL(queries, null);
    }

    @Override
    public Map<String, JSONArray> executeMultiFQL(Map<String, String> queries, Locale locale) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String url = this.conf.getRestBaseURL() + "fql?q=" + this.convertQueriesToJson(queries);
        if (locale != null) {
            url = url + "&locale=" + HttpParameter.encode(locale.toString());
        }
        JSONObject json = this.get(url).asJSONObject();
        HashMap<String, JSONArray> result = new HashMap<String, JSONArray>();
        try {
            JSONArray jsonArray = json.getJSONArray("data");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String name = jsonObject.getString("name");
                JSONArray resultSets = jsonObject.getJSONArray("fql_result_set");
                result.put(name, resultSets);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
        return result;
    }

    private String convertQueriesToJson(Map<String, String> queries) {
        ArrayList<String> jsons = new ArrayList<String>();
        for (String name : queries.keySet()) {
            String json = "";
            try {
                json = "%22" + URLEncoder.encode(name, "UTF-8") + "%22" + ":" + "%22" + URLEncoder.encode(queries.get(name), "UTF-8") + "%22";
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
            jsons.add(json);
        }
        return "{" + z_F4JInternalStringUtil.join(jsons.toArray(new String[jsons.size()])) + "}";
    }

    @Override
    public TestUser createTestUser(String appId) throws FacebookException {
        return this.createTestUser(appId, null, null, null);
    }

    @Override
    public TestUser createTestUser(String appId, String name, String locale, String permissions) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String _locale = "en_US";
        if (locale != null) {
            _locale = locale;
        }
        return this.factory.createTestUser(this.post(this.conf.getRestBaseURL() + appId + "/accounts/test-users" + "?installed=true" + "&name=" + HttpParameter.encode(name) + "&locale=" + HttpParameter.encode(_locale) + "&permissions=" + HttpParameter.encode(permissions)));
    }

    @Override
    public List<TestUser> getTestUsers(String appId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.conf.getRestBaseURL() + appId + "/accounts/test-users");
        try {
            JSONArray data = res.asJSONObject().getJSONArray("data");
            ArrayList<TestUser> testUsers = new ArrayList<TestUser>();
            for (int i = 0; i < data.length(); ++i) {
                testUsers.add(this.factory.createTestUser(data.getJSONObject(i)));
            }
            return testUsers;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public boolean deleteTestUser(String testUserId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.conf.getRestBaseURL() + testUserId);
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean makeFriendTestUser(TestUser testUser1, TestUser testUser2) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(testUser1.getId(), "friends/" + testUser2.getId()), new HttpParameter[]{new HttpParameter("access_token", testUser1.getAccessToken())});
        if (!Boolean.valueOf(res.asString().trim()).booleanValue()) {
            return false;
        }
        res = this.post(this.buildURL(testUser2.getId(), "friends/" + testUser1.getId()), new HttpParameter[]{new HttpParameter("access_token", testUser2.getAccessToken())});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public <T> ResponseList<T> fetchNext(Paging<T> paging) throws FacebookException {
        this.ensureAuthorizationEnabled();
        URL url = paging.getNext();
        if (url == null) {
            return null;
        }
        return this.fetchPaging(url, paging.getJSONObjectType());
    }

    @Override
    public <T> ResponseList<T> fetchPrevious(Paging<T> paging) throws FacebookException {
        this.ensureAuthorizationEnabled();
        URL url = paging.getPrevious();
        if (url == null) {
            return null;
        }
        return this.fetchPaging(url, paging.getJSONObjectType());
    }

    private <T> ResponseList<T> fetchPaging(URL url, Class<T> jsonObjectType) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.getRaw(url.toString());
        return this.factory.createResponseList(res, jsonObjectType);
    }

    private ResponseList<Comment> _getComments(String objectId, Reading reading) throws FacebookException {
        return this.factory.createCommentList(this.get(this.buildURL(objectId, "comments", reading)));
    }

    private ResponseList<Like> _getLikes(String objectId, Reading reading) throws FacebookException {
        return this.factory.createLikeList(this.get(this.buildURL(objectId, "likes", reading)));
    }

    private URL _getPictureURL(String objectId, String connection, PictureSize size) throws FacebookException {
        String url = this.buildURL(objectId, connection);
        HttpResponse res = size != null ? this.get(url, new HttpParameter[]{new HttpParameter("type", size.toString())}) : this.get(url);
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    private String _comment(String objectId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(objectId, "comments"), new HttpParameter[]{new HttpParameter("message", message)}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    private boolean _like(String objectId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildURL(objectId, "likes"));
        return Boolean.valueOf(res.asString().trim());
    }

    private boolean _unlike(String objectId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildURL(objectId, "likes"));
        return Boolean.valueOf(res.asString().trim());
    }

    private String _postFeed(String objectId, PostUpdate postUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildURL(objectId, "feed"), postUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    private String _postLink(String objectId, URL link, String message) throws FacebookException {
        HttpParameter[] httpParameters = new HttpParameter[]{new HttpParameter("link", link.toString())};
        if (message != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("message", message)});
        }
        JSONObject json = this.post(this.buildURL(objectId, "feed"), httpParameters).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    private String _postStatusMessage(String objectId, String message) throws FacebookException {
        JSONObject json = this.post(this.buildURL(objectId, "feed"), new HttpParameter[]{new HttpParameter("message", message)}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url, HttpParameter[] parameters) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse getRaw(String url) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url, HttpParameter[] parameters) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse delete(String url) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse delete(String url, HttpParameter[] parameters) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, this.containsAccessToken(parameters) ? null : this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    private boolean isOk(HttpResponse response) {
        return response != null && response.getStatusCode() < 300;
    }

    private boolean containsAccessToken(HttpParameter[] parameters) throws FacebookException {
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals("access_token")) continue;
            return true;
        }
        return false;
    }
}

