/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Inbox;
import facebook4j.InboxResponseList;
import facebook4j.PagableList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.InboxResponseListImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InboxJSONImpl
extends FacebookResponseImpl
implements Inbox,
Serializable {
    private static final long serialVersionUID = -6689657536816020492L;
    private String id;
    private List<IdNameEntity> to;
    private Date updatedTime;
    private Integer unread;
    private Integer unseen;
    private PagableList<Comment> comments;

    InboxJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    InboxJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("to")) {
                this.to = new ArrayList<IdNameEntity>();
                JSONArray toJSONArray = json.getJSONObject("to").getJSONArray("data");
                for (int i = 0; i < toJSONArray.length(); ++i) {
                    this.to.add(new IdNameEntityJSONImpl(toJSONArray.getJSONObject(i)));
                }
            }
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            if (!json.isNull("unread")) {
                this.unread = z_F4JInternalParseUtil.getPrimitiveInt("unread", json);
            }
            if (!json.isNull("unseen")) {
                this.unseen = z_F4JInternalParseUtil.getPrimitiveInt("unseen", json);
            }
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                JSONArray list = commentsJSONObject.getJSONArray("data");
                int size = list.length();
                this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                for (int i = 0; i < size; ++i) {
                    CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                    this.comments.add(comment);
                }
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<IdNameEntity> getTo() {
        return this.to;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Integer getUnread() {
        return this.unread;
    }

    @Override
    public Integer getUnseen() {
        return this.unseen;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    static InboxResponseList<Inbox> createInboxList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            InboxResponseListImpl<Inbox> inboxes = new InboxResponseListImpl<Inbox>(size, json, new Inbox[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject inboxJSONObject = list.getJSONObject(i);
                InboxJSONImpl inbox = new InboxJSONImpl(inboxJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(inbox, inboxJSONObject);
                }
                inboxes.add(inbox);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(inboxes, list);
            }
            return inboxes;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InboxJSONImpl other = (InboxJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "InboxJSONImpl [id=" + this.id + ", to=" + this.to + ", updatedTime=" + this.updatedTime + ", unread=" + this.unread + ", unseen=" + this.unseen + ", comments=" + this.comments + "]";
    }
}

