/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.PagableList;
import facebook4j.QuestionVotes;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QuestionVotesJSONImpl
extends FacebookResponseImpl
implements QuestionVotes,
Serializable {
    private static final long serialVersionUID = -1051921085759549828L;
    private String id;
    private PagableList<IdNameEntity> votes;

    QuestionVotesJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    QuestionVotesJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("votes")) {
                JSONObject votesJSONObject = json.getJSONObject("votes");
                JSONArray votesArray = votesJSONObject.getJSONArray("data");
                int size = votesArray.length();
                this.votes = new PagableListImpl<IdNameEntity>(size, votesJSONObject, new IdNameEntity[0]);
                for (int i = 0; i < size; ++i) {
                    IdNameEntityJSONImpl vote = new IdNameEntityJSONImpl(votesArray.getJSONObject(i));
                    this.votes.add(vote);
                }
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PagableList<IdNameEntity> getVotes() {
        return this.votes;
    }

    static ResponseList<QuestionVotes> createQuestionVotesList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<QuestionVotes> questionVotesList = new ResponseListImpl<QuestionVotes>(size, json, new QuestionVotes[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject questionVotesJSONObject = list.getJSONObject(i);
                QuestionVotesJSONImpl questionVotes = new QuestionVotesJSONImpl(questionVotesJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(questionVotes, questionVotesJSONObject);
                }
                questionVotesList.add(questionVotes);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(questionVotesList, list);
            }
            return questionVotesList;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuestionVotesJSONImpl other = (QuestionVotesJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "QuestionVotesJSONImpl [id=" + this.id + ", votes=" + this.votes + "]";
    }
}

