/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Cover;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Picture;
import facebook4j.ResponseList;
import facebook4j.User;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CoverJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.PictureJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserJSONImpl
implements User,
Comparable<User>,
Serializable {
    private static final long serialVersionUID = 3839339196757459703L;
    private String id;
    private String name;
    private String firstName;
    private String middleName;
    private String lastName;
    private String gender;
    private Locale locale;
    private List<IdNameEntity> languages = new ArrayList<IdNameEntity>();
    private URL link;
    private String username;
    private String thirdPartyId;
    private Boolean installed;
    private Double timezone;
    private Date updatedTime;
    private Boolean verified;
    private String bio;
    private String birthday;
    private Cover cover;
    private List<User.Education> education = new ArrayList<User.Education>();
    private String email;
    private IdNameEntity hometown;
    private List<String> interestedIn = new ArrayList<String>();
    private IdNameEntity location;
    private String political;
    private List<IdNameEntity> favoriteAthletes = new ArrayList<IdNameEntity>();
    private List<IdNameEntity> favoriteTeams = new ArrayList<IdNameEntity>();
    private Picture picture;
    private String quotes;
    private String relationshipStatus;
    private String religion;
    private IdNameEntity significantOther;
    private User.VideoUploadLimits videoUploadLimits;
    private URL website;
    private List<User.Work> work = new ArrayList<User.Work>();

    UserJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    UserJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.firstName = z_F4JInternalParseUtil.getRawString("first_name", json);
            this.middleName = z_F4JInternalParseUtil.getRawString("middle_name", json);
            this.lastName = z_F4JInternalParseUtil.getRawString("last_name", json);
            this.gender = z_F4JInternalParseUtil.getRawString("gender", json);
            if (!json.isNull("locale")) {
                String[] _locale = z_F4JInternalParseUtil.getRawString("locale", json).split("_");
                String language = _locale[0];
                String country = _locale[1];
                this.locale = new Locale(language, country);
            }
            if (!json.isNull("languages")) {
                JSONArray languagesJSONArray = json.getJSONArray("languages");
                for (int i = 0; i < languagesJSONArray.length(); ++i) {
                    this.languages.add(new IdNameEntityJSONImpl(languagesJSONArray.getJSONObject(i)));
                }
            }
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            this.username = z_F4JInternalParseUtil.getRawString("username", json);
            this.thirdPartyId = z_F4JInternalParseUtil.getRawString("third_party_id", json);
            this.installed = z_F4JInternalParseUtil.getBoolean("installed", json);
            this.timezone = z_F4JInternalParseUtil.getDouble("timezone", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            this.verified = z_F4JInternalParseUtil.getBoolean("verified", json);
            this.bio = z_F4JInternalParseUtil.getRawString("bio", json);
            this.birthday = z_F4JInternalParseUtil.getRawString("birthday", json);
            if (!json.isNull("cover")) {
                JSONObject coverJSON = json.getJSONObject("cover");
                this.cover = new CoverJSONImpl(coverJSON);
            }
            if (!json.isNull("education")) {
                JSONArray educationJSONArray = json.getJSONArray("education");
                for (int i = 0; i < educationJSONArray.length(); ++i) {
                    this.education.add(new EducationJSONImpl(educationJSONArray.getJSONObject(i)));
                }
            }
            this.email = z_F4JInternalParseUtil.getRawString("email", json);
            if (!json.isNull("hometown")) {
                JSONObject hometownJSON = json.getJSONObject("hometown");
                this.hometown = new IdNameEntityJSONImpl(hometownJSON);
            }
            if (!json.isNull("interestedIn")) {
                JSONArray interestedInJSONArray = json.getJSONArray("interested_in");
                for (int i = 0; i < interestedInJSONArray.length(); ++i) {
                    this.interestedIn.add(interestedInJSONArray.getString(i));
                }
            }
            if (!json.isNull("location")) {
                JSONObject locationJSON = json.getJSONObject("location");
                this.location = new IdNameEntityJSONImpl(locationJSON);
            }
            this.political = z_F4JInternalParseUtil.getRawString("political", json);
            if (!json.isNull("favorite_athletes")) {
                JSONArray favoriteAthletesJSONArray = json.getJSONArray("favorite_athletes");
                for (int i = 0; i < favoriteAthletesJSONArray.length(); ++i) {
                    this.favoriteAthletes.add(new IdNameEntityJSONImpl(favoriteAthletesJSONArray.getJSONObject(i)));
                }
            }
            if (!json.isNull("favorite_teams")) {
                JSONArray favoriteTeamsJSONArray = json.getJSONArray("favorite_teams");
                for (int i = 0; i < favoriteTeamsJSONArray.length(); ++i) {
                    this.favoriteTeams.add(new IdNameEntityJSONImpl(favoriteTeamsJSONArray.getJSONObject(i)));
                }
            }
            if (!json.isNull("picture")) {
                String pictureRawString = z_F4JInternalParseUtil.getRawString("picture", json);
                if (pictureRawString.startsWith("{")) {
                    JSONObject pictureJSONObject = json.getJSONObject("picture");
                    this.picture = new PictureJSONImpl(pictureJSONObject);
                } else {
                    this.picture = new PictureJSONImpl(z_F4JInternalParseUtil.getURL("picture", json));
                }
            }
            this.quotes = z_F4JInternalParseUtil.getRawString("quotes", json);
            this.relationshipStatus = z_F4JInternalParseUtil.getRawString("relationship_status", json);
            this.religion = z_F4JInternalParseUtil.getRawString("religion", json);
            if (!json.isNull("significant_other")) {
                JSONObject significantOtherJSONObject = json.getJSONObject("significant_other");
                this.significantOther = new IdNameEntityJSONImpl(significantOtherJSONObject);
            }
            if (!json.isNull("video_upload_limits")) {
                JSONObject videoUploadLimitsJSONObject = json.getJSONObject("video_upload_limits");
                this.videoUploadLimits = new VideoUploadLimitsJSONImpl(videoUploadLimitsJSONObject);
            }
            this.website = z_F4JInternalParseUtil.getURL("website", json);
            if (!json.isNull("work")) {
                JSONArray workJSONArray = json.getJSONArray("work");
                for (int i = 0; i < workJSONArray.length(); ++i) {
                    this.work.add(new WorkJSONImpl(workJSONArray.getJSONObject(i)));
                }
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public List<IdNameEntity> getLanguages() {
        return this.languages;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getThirdPartyId() {
        return this.thirdPartyId;
    }

    @Override
    public Boolean isInstalled() {
        return this.installed;
    }

    @Override
    public Double getTimezone() {
        return this.timezone;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Boolean isVerified() {
        return this.verified;
    }

    @Override
    public String getBio() {
        return this.bio;
    }

    @Override
    public String getBirthday() {
        return this.birthday;
    }

    @Override
    public Cover getCover() {
        return this.cover;
    }

    @Override
    public List<User.Education> getEducation() {
        return this.education;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public IdNameEntity getHometown() {
        return this.hometown;
    }

    @Override
    public List<String> getInterestedIn() {
        return this.interestedIn;
    }

    @Override
    public IdNameEntity getLocation() {
        return this.location;
    }

    @Override
    public String getPolitical() {
        return this.political;
    }

    @Override
    public List<IdNameEntity> getFavoriteAthletes() {
        return this.favoriteAthletes;
    }

    @Override
    public List<IdNameEntity> getFavoriteTeams() {
        return this.favoriteTeams;
    }

    @Override
    public Picture getPicture() {
        return this.picture;
    }

    @Override
    public String getQuotes() {
        return this.quotes;
    }

    @Override
    public String getRelationshipStatus() {
        return this.relationshipStatus;
    }

    @Override
    public String getReligion() {
        return this.religion;
    }

    @Override
    public IdNameEntity getSignificantOther() {
        return this.significantOther;
    }

    @Override
    public User.VideoUploadLimits getVideoUploadLimits() {
        return this.videoUploadLimits;
    }

    @Override
    public URL getWebsite() {
        return this.website;
    }

    @Override
    public List<User.Work> getWork() {
        return this.work;
    }

    static ResponseList<User> createUserList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<User> users = new ResponseListImpl<User>(size, json, new User[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject userJSONObject = list.getJSONObject(i);
                UserJSONImpl user = new UserJSONImpl(userJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(user, userJSONObject);
                }
                users.add(user);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(users, list);
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    static List<User> createUserArray(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            ArrayList<User> users = new ArrayList<User>();
            Iterator ids = json.keys();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                UserJSONImpl user = new UserJSONImpl((JSONObject)json.get(id));
                users.add(user);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(users, json);
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public int compareTo(User that) {
        return this.id.compareTo(that.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).getId().equals(this.id);
    }

    public String toString() {
        return "UserJSONImpl [id=" + this.id + ", name=" + this.name + ", firstName=" + this.firstName + ", middleName=" + this.middleName + ", lastName=" + this.lastName + ", gender=" + this.gender + ", locale=" + this.locale + ", languages=" + this.languages + ", link=" + this.link + ", username=" + this.username + ", thirdPartyId=" + this.thirdPartyId + ", timezone=" + this.timezone + ", updatedTime=" + this.updatedTime + ", verified=" + this.verified + ", bio=" + this.bio + ", birthday=" + this.birthday + ", cover=" + this.cover + ", education=" + this.education + ", email=" + this.email + ", hometown=" + this.hometown + ", interestedIn=" + this.interestedIn + ", location=" + this.location + ", political=" + this.political + ", favoriteAthletes=" + this.favoriteAthletes + ", favoriteTeams=" + this.favoriteTeams + ", picture=" + this.picture + ", quotes=" + this.quotes + ", relationshipStatus=" + this.relationshipStatus + ", religion=" + this.religion + ", significantOther=" + this.significantOther + ", videoUploadLimits=" + this.videoUploadLimits + ", website=" + this.website + ", work=" + this.work + "]";
    }

    private class WorkJSONImpl
    implements User.Work,
    Serializable {
        private static final long serialVersionUID = 6240342669173650031L;
        private IdNameEntity employer;
        private IdNameEntity location;
        private IdNameEntity position;
        private String startDate;
        private String endDate;

        WorkJSONImpl(JSONObject json) throws FacebookException {
            try {
                if (!json.isNull("employer")) {
                    JSONObject employerJSONObject = json.getJSONObject("employer");
                    this.employer = new IdNameEntityJSONImpl(employerJSONObject);
                }
                if (!json.isNull("location")) {
                    JSONObject locationJSONObject = json.getJSONObject("location");
                    this.location = new IdNameEntityJSONImpl(locationJSONObject);
                }
                if (!json.isNull("position")) {
                    JSONObject positionJSONObject = json.getJSONObject("position");
                    this.position = new IdNameEntityJSONImpl(positionJSONObject);
                }
                this.startDate = z_F4JInternalParseUtil.getRawString("start_date", json);
                this.endDate = z_F4JInternalParseUtil.getRawString("end_date", json);
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone);
            }
        }

        public IdNameEntity getEmployer() {
            return this.employer;
        }

        public IdNameEntity getLocation() {
            return this.location;
        }

        public IdNameEntity getPosition() {
            return this.position;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.employer == null ? 0 : this.employer.hashCode());
            result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
            result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WorkJSONImpl other = (WorkJSONImpl)obj;
            if (this.employer == null ? other.employer != null : !this.employer.equals(other.employer)) {
                return false;
            }
            if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
                return false;
            }
            if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
                return false;
            }
            if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
                return false;
            }
            return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
        }

        public String toString() {
            return "WorkJSONImpl [employer=" + this.employer + ", location=" + this.location + ", position=" + this.position + ", startDate=" + this.startDate + ", endDate=" + this.endDate + "]";
        }
    }

    private final class VideoUploadLimitsJSONImpl
    implements User.VideoUploadLimits,
    Serializable {
        private static final long serialVersionUID = -4890967721976343047L;
        private final long length;
        private final long size;

        VideoUploadLimitsJSONImpl(JSONObject json) throws FacebookException {
            this.length = z_F4JInternalParseUtil.getLong("length", json);
            this.size = z_F4JInternalParseUtil.getLong("size", json);
        }

        public long getLength() {
            return this.length;
        }

        public long getSize() {
            return this.size;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VideoUploadLimitsJSONImpl other = (VideoUploadLimitsJSONImpl)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.size == other.size;
        }

        public String toString() {
            return "VideoUploadLimitsJSONImpl [length=" + this.length + ", size=" + this.size + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EducationClassJSONImpl
    implements User.EducationClass,
    Serializable {
        private static final long serialVersionUID = -3203070872491695934L;
        private List<IdNameEntity> with;
        private String description;

        EducationClassJSONImpl(JSONObject json) throws FacebookException {
            try {
                if (!json.isNull("with")) {
                    JSONArray withJSONArray = json.getJSONArray("with");
                    this.with = new ArrayList<IdNameEntity>();
                    for (int i = 0; i < withJSONArray.length(); ++i) {
                        this.with.add(new IdNameEntityJSONImpl(withJSONArray.getJSONObject(i)));
                    }
                }
                this.description = z_F4JInternalParseUtil.getRawString("description", json);
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone.getMessage() + ":" + json.toString(), jsone);
            }
        }

        @Override
        public List<IdNameEntity> getWith() {
            return this.with;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.with == null ? 0 : ((Object)this.with).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EducationClassJSONImpl other = (EducationClassJSONImpl)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            return !(this.with == null ? other.with != null : !((Object)this.with).equals(other.with));
        }

        public String toString() {
            return "EducationClassJSONImpl [with=" + this.with + ", description=" + this.description + "]";
        }

        private UserJSONImpl getOuterType() {
            return UserJSONImpl.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EducationJSONImpl
    implements User.Education,
    Serializable {
        private static final long serialVersionUID = -9136754110094129780L;
        private IdNameEntity year;
        private String type;
        private IdNameEntity school;
        private IdNameEntity degree;
        private List<IdNameEntity> concentration;
        private List<User.EducationClass> classes;
        private List<IdNameEntity> with;

        EducationJSONImpl(JSONObject json) throws FacebookException {
            try {
                int i;
                if (!json.isNull("year")) {
                    JSONObject yearJSON = json.getJSONObject("year");
                    this.year = new IdNameEntityJSONImpl(yearJSON);
                }
                this.type = z_F4JInternalParseUtil.getRawString("type", json);
                if (!json.isNull("school")) {
                    JSONObject schoolJSON = json.getJSONObject("school");
                    this.school = new IdNameEntityJSONImpl(schoolJSON);
                }
                if (!json.isNull("degree")) {
                    JSONObject degreeJSON = json.getJSONObject("degree");
                    this.degree = new IdNameEntityJSONImpl(degreeJSON);
                }
                if (!json.isNull("concentration")) {
                    JSONArray concentrationJSONArray = json.getJSONArray("concentration");
                    this.concentration = new ArrayList<IdNameEntity>();
                    for (i = 0; i < concentrationJSONArray.length(); ++i) {
                        this.concentration.add(new IdNameEntityJSONImpl(concentrationJSONArray.getJSONObject(i)));
                    }
                }
                if (!json.isNull("classes")) {
                    JSONArray classesJSONArray = json.getJSONArray("classes");
                    this.classes = new ArrayList<User.EducationClass>();
                    for (i = 0; i < classesJSONArray.length(); ++i) {
                        this.classes.add(new EducationClassJSONImpl(classesJSONArray.getJSONObject(i)));
                    }
                }
                if (!json.isNull("with")) {
                    JSONArray withJSONArray = json.getJSONArray("with");
                    this.with = new ArrayList<IdNameEntity>();
                    for (i = 0; i < withJSONArray.length(); ++i) {
                        this.with.add(new IdNameEntityJSONImpl(withJSONArray.getJSONObject(i)));
                    }
                }
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone);
            }
        }

        @Override
        public IdNameEntity getYear() {
            return this.year;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public IdNameEntity getSchool() {
            return this.school;
        }

        @Override
        public IdNameEntity getDegree() {
            return this.degree;
        }

        @Override
        public List<IdNameEntity> getConcentration() {
            return this.concentration;
        }

        @Override
        public List<User.EducationClass> getClasses() {
            return this.classes;
        }

        @Override
        public List<IdNameEntity> getWith() {
            return this.with;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.classes == null ? 0 : ((Object)this.classes).hashCode());
            result = 31 * result + (this.concentration == null ? 0 : ((Object)this.concentration).hashCode());
            result = 31 * result + (this.degree == null ? 0 : this.degree.hashCode());
            result = 31 * result + (this.school == null ? 0 : this.school.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.with == null ? 0 : ((Object)this.with).hashCode());
            result = 31 * result + (this.year == null ? 0 : this.year.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EducationJSONImpl other = (EducationJSONImpl)obj;
            if (this.classes == null ? other.classes != null : !((Object)this.classes).equals(other.classes)) {
                return false;
            }
            if (this.concentration == null ? other.concentration != null : !((Object)this.concentration).equals(other.concentration)) {
                return false;
            }
            if (this.degree == null ? other.degree != null : !this.degree.equals(other.degree)) {
                return false;
            }
            if (this.school == null ? other.school != null : !this.school.equals(other.school)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            if (this.with == null ? other.with != null : !((Object)this.with).equals(other.with)) {
                return false;
            }
            return !(this.year == null ? other.year != null : !this.year.equals(other.year));
        }

        public String toString() {
            return "EducationJSONImpl [year=" + this.year + ", type=" + this.type + ", school=" + this.school + ", degree=" + this.degree + ", concentration=" + this.concentration + ", classes=" + this.classes + ", with=" + this.with + "]";
        }
    }
}

