/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.facebook;

import facebook4j.Facebook;
import facebook4j.json.DataObjectFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.facebook.FacebookEndpoint;
import org.apache.camel.component.facebook.config.FacebookEndpointConfiguration;
import org.apache.camel.component.facebook.data.FacebookMethodsType;
import org.apache.camel.component.facebook.data.FacebookMethodsTypeHelper;
import org.apache.camel.component.facebook.data.FacebookPropertiesHelper;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacebookProducer
extends DefaultAsyncProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(FacebookProducer.class);
    private static ExecutorService executorService;
    private FacebookEndpoint endpoint;

    public FacebookProducer(FacebookEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final HashMap<String, Object> properties = new HashMap<String, Object>();
        FacebookPropertiesHelper.getEndpointProperties(this.endpoint.getConfiguration(), properties);
        FacebookPropertiesHelper.getExchangeProperties(exchange, properties);
        final FacebookMethodsType method = this.findMethod(exchange, properties);
        if (method == null) {
            callback.done(true);
            return true;
        }
        Runnable invocation = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object result;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Invoking method {} with {}", (Object)method.getName(), properties.keySet());
                    }
                    String rawJSON = null;
                    if (FacebookProducer.this.endpoint.getConfiguration().getJsonStoreEnabled() == null || !FacebookProducer.this.endpoint.getConfiguration().getJsonStoreEnabled().booleanValue()) {
                        result = FacebookMethodsTypeHelper.invokeMethod(FacebookProducer.this.endpoint.getConfiguration().getFacebook(), method, properties);
                    } else {
                        Facebook facebook;
                        Facebook facebook2 = facebook = FacebookProducer.this.endpoint.getConfiguration().getFacebook();
                        synchronized (facebook2) {
                            result = FacebookMethodsTypeHelper.invokeMethod(facebook, method, properties);
                            rawJSON = DataObjectFactory.getRawJSON(result);
                        }
                    }
                    exchange.getOut().setBody(result);
                    exchange.getOut().setHeaders(exchange.getIn().getHeaders());
                    if (rawJSON != null) {
                        exchange.getOut().setHeader("CamelFacebook.rawJSON", (Object)rawJSON);
                    }
                }
                catch (Throwable t) {
                    exchange.setException((Throwable)ObjectHelper.wrapRuntimeCamelException((Throwable)t));
                }
                finally {
                    callback.done(false);
                }
            }
        };
        FacebookProducer.getExecutorService(this.getEndpoint().getCamelContext()).submit(invocation);
        return false;
    }

    private FacebookMethodsType findMethod(Exchange exchange, Map<String, Object> properties) {
        FacebookMethodsType method = null;
        List<FacebookMethodsType> candidates = this.endpoint.getCandidates();
        if (this.processInBody(exchange, properties)) {
            Set<String> argNames = properties.keySet();
            List<FacebookMethodsType> filteredMethods = FacebookMethodsTypeHelper.filterMethods(candidates, FacebookMethodsTypeHelper.MatchType.SUPER_SET, argNames.toArray(new String[argNames.size()]));
            if (filteredMethods.isEmpty()) {
                Set<String> missing = FacebookMethodsTypeHelper.getMissingProperties(this.endpoint.getMethodName(), this.endpoint.getNameStyle(), argNames);
                throw new RuntimeCamelException(String.format("Missing properties for %s, need one or more from %s", this.endpoint.getMethodName(), missing));
            }
            if (filteredMethods.size() == 1) {
                method = filteredMethods.get(0);
            } else {
                method = FacebookMethodsTypeHelper.getHighestPriorityMethod(filteredMethods);
                LOG.warn("Calling highest priority method {} from methods {}", (Object)method, filteredMethods);
            }
        }
        return method;
    }

    private boolean processInBody(Exchange exchange, Map<String, Object> properties) {
        String inBodyProperty = this.endpoint.getInBody();
        if (inBodyProperty != null) {
            Object value = exchange.getIn().getBody();
            try {
                value = this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(FacebookEndpointConfiguration.class.getDeclaredField(inBodyProperty).getType(), exchange, value);
            }
            catch (Exception e) {
                exchange.setException((Throwable)new RuntimeCamelException(String.format("Error converting value %s to property %s: %s", value, inBodyProperty, e.getMessage()), (Throwable)e));
                return false;
            }
            LOG.debug("Property [{}] has message body value {}", (Object)inBodyProperty, value);
            properties.put(inBodyProperty, value);
        }
        return true;
    }

    protected static synchronized ExecutorService getExecutorService(CamelContext context) {
        if (executorService == null || executorService.isTerminated() || executorService.isShutdown()) {
            ExecutorServiceManager manager = context.getExecutorServiceManager();
            ThreadPoolProfile poolProfile = manager.getThreadPoolProfile("CamelFacebook");
            if (poolProfile == null) {
                poolProfile = manager.getDefaultThreadPoolProfile();
            }
            executorService = manager.newScheduledThreadPool(FacebookProducer.class, "CamelFacebook", poolProfile);
        }
        return executorService;
    }
}

