/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.conf.ConfigurationContext;
import facebook4j.internal.logging.Logger;
import facebook4j.management.APIStatistics;
import facebook4j.management.APIStatisticsMBean;
import facebook4j.management.APIStatisticsOpenMBean;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class FacebookAPIMonitor {
    private static final Logger logger = Logger.getLogger(FacebookAPIMonitor.class);
    private static final Pattern pattern = Pattern.compile("https?:\\/\\/[^\\/]+\\/\\d+\\/([a-zA-Z_\\.]*).*");
    private static final FacebookAPIMonitor SINGLETON = new FacebookAPIMonitor();
    private static final APIStatistics STATISTICS = new APIStatistics(100);

    private FacebookAPIMonitor() {
    }

    public static FacebookAPIMonitor getInstance() {
        return SINGLETON;
    }

    public APIStatisticsMBean getStatistics() {
        return STATISTICS;
    }

    void methodCalled(String twitterUrl, long elapsedTime, boolean success) {
        Matcher matcher = pattern.matcher(twitterUrl);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String method = matcher.group(1);
            STATISTICS.methodCalled(method, elapsedTime, success);
        }
    }

    static {
        boolean isJDK14orEarlier = false;
        try {
            String versionStr = System.getProperty("java.specification.version");
            if (versionStr != null) {
                boolean bl = isJDK14orEarlier = 1.5 > Double.parseDouble(versionStr);
            }
            if (ConfigurationContext.getInstance().isDalvik()) {
                System.setProperty("http.keepAlive", "false");
            }
        }
        catch (SecurityException ignore) {
            isJDK14orEarlier = true;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (isJDK14orEarlier) {
                ObjectName oName = new ObjectName("facebook4j.mbean:type=APIStatistics");
                mbs.registerMBean(STATISTICS, oName);
            } else {
                ObjectName oName = new ObjectName("facebook4j.mbean:type=APIStatisticsOpenMBean");
                APIStatisticsOpenMBean openMBean = new APIStatisticsOpenMBean(STATISTICS);
                mbs.registerMBean(openMBean, oName);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }
}

