/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.FacebookException;
import facebook4j.User;
import facebook4j.auth.AccessToken;
import facebook4j.auth.Authorization;
import facebook4j.auth.NullAuthorization;
import facebook4j.auth.OAuthAuthorization;
import facebook4j.auth.OAuthSupport;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpClientWrapper;
import facebook4j.internal.json.z_F4JInternalFactory;
import facebook4j.internal.json.z_F4JInternalJSONImplFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

abstract class FacebookBaseImpl
implements Serializable,
OAuthSupport {
    private static final long serialVersionUID = 5812835429308976884L;
    protected transient HttpClientWrapper http;
    protected z_F4JInternalFactory factory;
    protected Configuration conf;
    protected Authorization auth;
    protected transient String id;
    protected transient String name;
    protected transient String email;

    FacebookBaseImpl(Configuration conf, Authorization auth) {
        this.conf = conf;
        this.auth = auth;
        this.init();
    }

    private void init() {
        if (null == this.auth) {
            String consumerKey = this.conf.getOAuthAppId();
            String consumerSecret = this.conf.getOAuthAppSecret();
            if (consumerKey != null && consumerSecret != null) {
                OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
                String accessToken = this.conf.getOAuthAccessToken();
                if (accessToken != null) {
                    oauth.setOAuthAccessToken(new AccessToken(accessToken, null));
                }
                this.auth = oauth;
            } else {
                this.auth = NullAuthorization.getInstance();
            }
        }
        this.http = new HttpClientWrapper(this.conf);
        this.setFactory();
    }

    protected void setFactory() {
        this.factory = new z_F4JInternalJSONImplFactory(this.conf);
    }

    public String getId() throws FacebookException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth app ID/secret combination supplied");
        }
        if (this.id == null) {
            this.fillInIDAndNameAndEmail();
        }
        return this.id;
    }

    public String getName() throws FacebookException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth app ID/secret combination supplied");
        }
        if (this.name == null) {
            this.fillInIDAndNameAndEmail();
        }
        return this.name;
    }

    public String getEmail() throws FacebookException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth app ID/secret combination supplied");
        }
        if (this.email == null) {
            this.fillInIDAndNameAndEmail();
        }
        return this.email;
    }

    protected void fillInIDAndNameAndEmail() throws FacebookException {
        this.ensureAuthorizationEnabled();
        User me = this.factory.createUser(this.http.get(this.conf.getRestBaseURL() + "me", this.auth));
        this.id = me.getId();
        this.name = me.getName();
        this.email = me.getEmail();
    }

    public final Authorization getAuthorization() {
        return this.auth;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void shutdown() {
        if (this.http != null) {
            this.http.shutdown();
        }
    }

    protected final void ensureAuthorizationEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Authentication credentials are missing.");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.putFields();
        out.writeFields();
        out.writeObject(this.conf);
        out.writeObject(this.auth);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.readFields();
        this.conf = (Configuration)stream.readObject();
        this.auth = (Authorization)stream.readObject();
        this.http = new HttpClientWrapper(this.conf);
        this.setFactory();
    }

    public void setOAuthAppId(String appId, String appSecret) {
        if (appId == null) {
            throw new NullPointerException("app id is null");
        }
        if (appSecret == null) {
            throw new NullPointerException("app secret is null");
        }
        if (this.auth instanceof NullAuthorization) {
            OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
            oauth.setOAuthAppId(appId, appSecret);
            this.auth = oauth;
        } else if (this.auth instanceof OAuthAuthorization) {
            throw new IllegalStateException("app id/secret pair already set.");
        }
    }

    public void setOAuthPermissions(String permissions) {
        this.getOAuth().setOAuthPermissions(permissions);
    }

    public String getOAuthAuthorizationURL(String callbackURL) {
        return this.getOAuthAuthorizationURL(callbackURL, null);
    }

    public String getOAuthAuthorizationURL(String callbackURL, String state) {
        return this.getOAuth().getOAuthAuthorizationURL(callbackURL, state);
    }

    public AccessToken getOAuthAccessToken() {
        return this.getOAuth().getOAuthAccessToken();
    }

    public synchronized AccessToken getOAuthAccessToken(String oauthCode) throws FacebookException {
        return this.getOAuth().getOAuthAccessToken(oauthCode);
    }

    public AccessToken getOAuthAppAccessToken() throws FacebookException {
        return this.getOAuth().getOAuthAppAccessToken();
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.getOAuth().setOAuthAccessToken(accessToken);
    }

    private OAuthSupport getOAuth() {
        if (!(this.auth instanceof OAuthSupport)) {
            throw new IllegalStateException("OAuth app id/secret combination not supplied");
        }
        return (OAuthSupport)((Object)this.auth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FacebookBaseImpl other = (FacebookBaseImpl)obj;
        if (this.auth == null ? other.auth != null : !this.auth.equals(other.auth)) {
            return false;
        }
        if (this.conf == null ? other.conf != null : !this.conf.equals(other.conf)) {
            return false;
        }
        return !(this.http == null ? other.http != null : !this.http.equals(other.http));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.auth == null ? 0 : this.auth.hashCode());
        result = 31 * result + (this.conf == null ? 0 : this.conf.hashCode());
        result = 31 * result + (this.http == null ? 0 : this.http.hashCode());
        return result;
    }

    public String toString() {
        return "FacebookBaseImpl [http=" + this.http + ", conf=" + this.conf + ", auth=" + this.auth + "]";
    }
}

