/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.auth;

import facebook4j.FacebookException;
import facebook4j.internal.http.HttpResponse;
import java.io.Serializable;

public class AccessToken
implements Serializable {
    private static final long serialVersionUID = -1373191811934285453L;
    private String token;
    private Long expires;
    String[] responseStr = null;

    public AccessToken(HttpResponse res) throws FacebookException {
        this(res.asString());
    }

    public AccessToken(String string) {
        if (string.contains("access_token=")) {
            this.responseStr = string.split("&");
            this.token = this.getParameter("access_token");
            if (this.responseStr.length > 1) {
                this.expires = Long.valueOf(this.getParameter("expires"));
            }
        } else {
            this.token = string;
            this.expires = null;
        }
    }

    public AccessToken(String token, Long expires) {
        this.token = token;
        this.expires = expires;
    }

    public String getParameter(String parameter) {
        String value = null;
        for (String str : this.responseStr) {
            if (!str.startsWith(parameter + '=')) continue;
            value = str.split("=")[1].trim();
            break;
        }
        return value;
    }

    public String getToken() {
        return this.token;
    }

    public Long getExpires() {
        return this.expires;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessToken other = (AccessToken)obj;
        if (this.expires == null ? other.expires != null : !this.expires.equals(other.expires)) {
            return false;
        }
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expires == null ? 0 : this.expires.hashCode());
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public String toString() {
        return "AccessToken [token=" + this.token + ", expires=" + this.expires + "]";
    }
}

