/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Account;
import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AccountJSONImpl
extends FacebookResponseImpl
implements Account,
Serializable {
    private static final long serialVersionUID = 1311323662169212743L;
    private String name;
    private String accessToken;
    private String category;
    private String id;

    AccountJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    AccountJSONImpl(JSONObject json) {
        this.init(json);
    }

    private void init(JSONObject json) {
        this.name = z_F4JInternalParseUtil.getRawString("name", json);
        if (!json.isNull("access_token")) {
            this.accessToken = z_F4JInternalParseUtil.getRawString("access_token", json);
        }
        this.category = z_F4JInternalParseUtil.getRawString("category", json);
        this.id = z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getId() {
        return this.id;
    }

    static ResponseList<Account> createAccountList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Account> accounts = new ResponseListImpl<Account>(size, json, new Account[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject accountJSONObject = list.getJSONObject(i);
                AccountJSONImpl account = new AccountJSONImpl(accountJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(account, accountJSONObject);
                }
                accounts.add(account);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(accounts, list);
            }
            return accounts;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountJSONImpl other = (AccountJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "AccountJSONImpl [name=" + this.name + ", accessToken=" + this.accessToken + ", category=" + this.category + ", id=" + this.id + "]";
    }
}

