/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Album;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Like;
import facebook4j.PrivacyType;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.LikeJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AlbumJSONImpl
extends FacebookResponseImpl
implements Album,
Serializable {
    private static final long serialVersionUID = 4708626697445405636L;
    private String id;
    private IdNameEntity from;
    private String name;
    private String description;
    private String location;
    private URL link;
    private String coverPhoto;
    private PrivacyType privacy;
    private Integer count;
    private String type;
    private Date createdTime;
    private Date updatedTime;
    private Boolean canUpload;
    private List<Like> likes;

    AlbumJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    AlbumJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.description = z_F4JInternalParseUtil.getRawString("description", json);
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            this.coverPhoto = z_F4JInternalParseUtil.getRawString("cover_photo", json);
            this.privacy = PrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("privacy", json));
            this.count = z_F4JInternalParseUtil.getPrimitiveInt("count", json);
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            this.canUpload = z_F4JInternalParseUtil.getBoolean("can_upload", json);
            if (!json.isNull("likes")) {
                JSONObject likesJSONObject = json.getJSONObject("likes");
                JSONArray list = likesJSONObject.getJSONArray("data");
                int size = list.length();
                this.likes = new PagableListImpl<Like>(size, likesJSONObject, new Like[0]);
                for (int i = 0; i < size; ++i) {
                    LikeJSONImpl like = new LikeJSONImpl(list.getJSONObject(i));
                    this.likes.add(like);
                }
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public String getCoverPhoto() {
        return this.coverPhoto;
    }

    @Override
    public PrivacyType getPrivacy() {
        return this.privacy;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Boolean canUpload() {
        return this.canUpload;
    }

    @Override
    public List<Like> getLikes() {
        return this.likes;
    }

    static ResponseList<Album> createAlbumList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Album> albums = new ResponseListImpl<Album>(size, json, new Album[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject albumJSONObject = list.getJSONObject(i);
                AlbumJSONImpl album = new AlbumJSONImpl(albumJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(album, albumJSONObject);
                }
                albums.add(album);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(albums, list);
            }
            return albums;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlbumJSONImpl other = (AlbumJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "AlbumJSONImpl [id=" + this.id + ", from=" + this.from + ", name=" + this.name + ", description=" + this.description + ", location=" + this.location + ", link=" + this.link + ", coverPhoto=" + this.coverPhoto + ", privacy=" + (Object)((Object)this.privacy) + ", count=" + this.count + ", type=" + this.type + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", canUpload=" + this.canUpload + ", likes=" + this.likes + "]";
    }
}

