/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Event;
import facebook4j.EventPrivacyType;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EventJSONImpl
extends FacebookResponseImpl
implements Event,
Serializable {
    private static final long serialVersionUID = 6176123276059683967L;
    private String id;
    private IdNameEntity owner;
    private String name;
    private String description;
    private Date startTime;
    private Date endTime;
    private String location;
    private Event.Venue venue;
    private EventPrivacyType privacy;
    private Date updatedTime;
    private String rsvpStatus;

    EventJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    EventJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("owner")) {
                JSONObject ownerJSONObject = json.getJSONObject("owner");
                this.owner = new IdNameEntityJSONImpl(ownerJSONObject);
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.description = z_F4JInternalParseUtil.getRawString("description", json);
            this.startTime = z_F4JInternalParseUtil.getISO8601Datetime("start_time", json);
            this.endTime = z_F4JInternalParseUtil.getISO8601Datetime("end_time", json);
            this.location = z_F4JInternalParseUtil.getRawString("location", json);
            if (!json.isNull("venue")) {
                JSONObject venueJSONObject = json.getJSONObject("venue");
                this.venue = new VenueJSONImpl(venueJSONObject);
            }
            this.privacy = EventPrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("privacy", json));
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            this.rsvpStatus = z_F4JInternalParseUtil.getRawString("rsvp_status", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Event.Venue getVenue() {
        return this.venue;
    }

    @Override
    public EventPrivacyType getPrivacy() {
        return this.privacy;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public String getRsvpStatus() {
        return this.rsvpStatus;
    }

    static ResponseList<Event> createEventList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Event> events = new ResponseListImpl<Event>(size, json, new Event[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject eventJSONObject = list.getJSONObject(i);
                EventJSONImpl event = new EventJSONImpl(eventJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(event, eventJSONObject);
                }
                events.add(event);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(events, list);
            }
            return events;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventJSONImpl other = (EventJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "EventJSONImpl [id=" + this.id + ", owner=" + this.owner + ", name=" + this.name + ", description=" + this.description + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", location=" + this.location + ", venue=" + this.venue + ", privacy=" + (Object)((Object)this.privacy) + ", updatedTime=" + this.updatedTime + ", rsvpStatus=" + this.rsvpStatus + "]";
    }

    private final class VenueJSONImpl
    implements Event.Venue,
    Serializable {
        private static final long serialVersionUID = -8662557267558208918L;
        private final String id;
        private final String street;
        private final String city;
        private final String state;
        private final String country;
        private final Double latitude;
        private final Double longitude;

        VenueJSONImpl(JSONObject json) {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            this.street = z_F4JInternalParseUtil.getRawString("street", json);
            this.city = z_F4JInternalParseUtil.getRawString("city", json);
            this.state = z_F4JInternalParseUtil.getRawString("state", json);
            this.country = z_F4JInternalParseUtil.getRawString("country", json);
            this.latitude = z_F4JInternalParseUtil.getDouble("latitude", json);
            this.longitude = z_F4JInternalParseUtil.getDouble("longitude", json);
        }

        public String getId() {
            return this.id;
        }

        public String getStreet() {
            return this.street;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountry() {
            return this.country;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public String toString() {
            return "VenueJSONImpl [id=" + this.id + ", street=" + this.street + ", city=" + this.city + ", state=" + this.state + ", country=" + this.country + ", latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
        }
    }
}

