/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.GroupMember;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupMemberJSONImpl
implements GroupMember,
Serializable {
    private static final long serialVersionUID = 8912198140971501463L;
    private String id;
    private String name;
    private Boolean isAdministrator;

    GroupMemberJSONImpl(HttpResponse res) throws FacebookException {
        JSONObject json = res.asJSONObject();
        this.init(json);
    }

    GroupMemberJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.id = z_F4JInternalParseUtil.getRawString("id", json);
        this.name = z_F4JInternalParseUtil.getRawString("name", json);
        this.isAdministrator = z_F4JInternalParseUtil.getBoolean("administrator", json);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean isAdministrator() {
        return this.isAdministrator;
    }

    static ResponseList<GroupMember> createGroupMemberList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<GroupMember> members = new ResponseListImpl<GroupMember>(size, json, new GroupMember[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject groupMemberJSONObject = list.getJSONObject(i);
                GroupMemberJSONImpl member = new GroupMemberJSONImpl(groupMemberJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(member, groupMemberJSONObject);
                }
                members.add(member);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(members, list);
            }
            return members;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupMemberJSONImpl other = (GroupMemberJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "MemberEntityJSONImpl [id=" + this.id + ", name=" + this.name + ", isAdministrator=" + this.isAdministrator + "]";
    }
}

