/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Like;
import facebook4j.PagableList;
import facebook4j.Photo;
import facebook4j.Place;
import facebook4j.ResponseList;
import facebook4j.Tag;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.LikeJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.PlaceJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.TagJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PhotoJSONImpl
extends FacebookResponseImpl
implements Photo,
Serializable {
    private static final long serialVersionUID = -6530726368840036344L;
    private String id;
    private IdNameEntity from;
    private List<Tag> tags;
    private String name;
    private URL icon;
    private URL picture;
    private URL source;
    private Integer height;
    private Integer width;
    private List<Photo.Image> images;
    private URL link;
    private Place place;
    private Date createdTime;
    private Date updatedTime;
    private Integer position;
    private PagableList<Comment> comments;
    private PagableList<Like> likes;

    PhotoJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    PhotoJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            int i;
            int size;
            JSONArray list;
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            if (!json.isNull("tags")) {
                JSONObject tagsJSONObject = json.getJSONObject("tags");
                list = tagsJSONObject.getJSONArray("data");
                size = list.length();
                this.tags = new ArrayList<Tag>(size);
                for (i = 0; i < size; ++i) {
                    TagJSONImpl tag = new TagJSONImpl(list.getJSONObject(i));
                    this.tags.add(tag);
                }
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.icon = z_F4JInternalParseUtil.getURL("icon", json);
            this.picture = z_F4JInternalParseUtil.getURL("picture", json);
            this.source = z_F4JInternalParseUtil.getURL("source", json);
            if (!json.isNull("height")) {
                this.height = z_F4JInternalParseUtil.getPrimitiveInt("height", json);
            }
            if (!json.isNull("width")) {
                this.width = z_F4JInternalParseUtil.getPrimitiveInt("width", json);
            }
            if (!json.isNull("images")) {
                this.images = new ArrayList<Photo.Image>();
                JSONArray imagesJSONArray = json.getJSONArray("images");
                for (int i2 = 0; i2 < imagesJSONArray.length(); ++i2) {
                    JSONObject image = imagesJSONArray.getJSONObject(i2);
                    this.images.add(new ImageJSONImpl(image));
                }
            }
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            if (!json.isNull("place")) {
                JSONObject placeJSONObject = json.getJSONObject("place");
                this.place = new PlaceJSONImpl(placeJSONObject);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            if (!json.isNull("position")) {
                this.position = z_F4JInternalParseUtil.getPrimitiveInt("position", json);
            }
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                list = commentsJSONObject.getJSONArray("data");
                size = list.length();
                this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                for (i = 0; i < size; ++i) {
                    CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                    this.comments.add(comment);
                }
            }
            if (!json.isNull("likes")) {
                JSONObject likesJSONObject = json.getJSONObject("likes");
                list = likesJSONObject.getJSONArray("data");
                size = list.length();
                this.likes = new PagableListImpl<Like>(size, likesJSONObject, new Like[0]);
                for (i = 0; i < size; ++i) {
                    LikeJSONImpl like = new LikeJSONImpl(list.getJSONObject(i));
                    this.likes.add(like);
                }
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public Integer getHeight() {
        return this.height;
    }

    @Override
    public Integer getWidth() {
        return this.width;
    }

    @Override
    public List<Photo.Image> getImages() {
        return this.images;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    static ResponseList<Photo> createPhotoList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Photo> photos = new ResponseListImpl<Photo>(size, json, new Photo[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject photoJSONObject = list.getJSONObject(i);
                PhotoJSONImpl photo = new PhotoJSONImpl(photoJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(photo, photoJSONObject);
                }
                photos.add(photo);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(photos, list);
            }
            return photos;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhotoJSONImpl other = (PhotoJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "PhotoJSONImpl [id=" + this.id + ", from=" + this.from + ", tags=" + this.tags + ", name=" + this.name + ", icon=" + this.icon + ", picture=" + this.picture + ", source=" + this.source + ", height=" + this.height + ", width=" + this.width + ", images=" + this.images + ", link=" + this.link + ", place=" + this.place + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", position=" + this.position + ", comments=" + this.comments + ", likes=" + this.likes + "]";
    }

    private final class ImageJSONImpl
    implements Photo.Image,
    Serializable {
        private static final long serialVersionUID = 5512851070213770944L;
        private Integer height;
        private Integer width;
        private URL source;

        ImageJSONImpl(JSONObject json) {
            if (!json.isNull("height")) {
                this.height = z_F4JInternalParseUtil.getPrimitiveInt("height", json);
            }
            if (!json.isNull("width")) {
                this.width = z_F4JInternalParseUtil.getPrimitiveInt("width", json);
            }
            this.source = z_F4JInternalParseUtil.getURL("source", json);
        }

        public Integer getHeight() {
            return this.height;
        }

        public Integer getWidth() {
            return this.width;
        }

        public URL getSource() {
            return this.source;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.height == null ? 0 : this.height.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.width == null ? 0 : this.width.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageJSONImpl other = (ImageJSONImpl)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.height == null ? other.height != null : !this.height.equals(other.height)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return !(this.width == null ? other.width != null : !this.width.equals(other.width));
        }

        public String toString() {
            return "ImageJSONImpl [height=" + this.height + ", width=" + this.width + ", source=" + this.source + "]";
        }

        private PhotoJSONImpl getOuterType() {
            return PhotoJSONImpl.this;
        }
    }
}

