/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.PagableList;
import facebook4j.Question;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QuestionJSONImpl
extends FacebookResponseImpl
implements Question,
Serializable {
    private static final long serialVersionUID = 1143276967891229953L;
    private String id;
    private IdNameEntity from;
    private String question;
    private Date createdTime;
    private Date updatedTime;
    private PagableList<Question.Option> options;

    QuestionJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    QuestionJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            this.question = z_F4JInternalParseUtil.getRawString("question", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            if (!json.isNull("options")) {
                JSONObject optionsJSONObject = json.getJSONObject("options");
                this.options = QuestionJSONImpl.createOptionList(optionsJSONObject);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public String getQuestion() {
        return this.question;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public PagableList<Question.Option> getOptions() {
        return this.options;
    }

    static ResponseList<Question> createQuestionList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Question> questions = new ResponseListImpl<Question>(size, json, new Question[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject questionJSONObject = list.getJSONObject(i);
                QuestionJSONImpl question = new QuestionJSONImpl(questionJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(question, questionJSONObject);
                }
                questions.add(question);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(questions, list);
            }
            return questions;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuestionJSONImpl other = (QuestionJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "QuestionJSONImpl [id=" + this.id + ", from=" + this.from + ", question=" + this.question + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", options=" + this.options + "]";
    }

    static PagableList<Question.Option> createOptionList(JSONObject json) throws FacebookException {
        try {
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            PagableListImpl<Question.Option> options = new PagableListImpl<Question.Option>(size, json, new Question.Option[0]);
            for (int i = 0; i < size; ++i) {
                OptionJSONImpl option = new OptionJSONImpl(list.getJSONObject(i));
                options.add(option);
            }
            return options;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    static ResponseList<Question.Option> createOptionList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Question.Option> options = new ResponseListImpl<Question.Option>(size, json, new Question.Option[0]);
            for (int i = 0; i < size; ++i) {
                OptionJSONImpl option = new OptionJSONImpl(list.getJSONObject(i));
                options.add(option);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(options, json);
            }
            return options;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    static class OptionJSONImpl
    implements Question.Option,
    Serializable {
        private static final long serialVersionUID = -6022359823763655064L;
        private String id;
        private IdNameEntity from;
        private String name;
        private Integer voteCount;
        private Date createdTime;
        private Integer votes;

        OptionJSONImpl(JSONObject json) throws FacebookException {
            try {
                this.id = z_F4JInternalParseUtil.getRawString("id", json);
                if (!json.isNull("from")) {
                    JSONObject fromJSONObject = json.getJSONObject("from");
                    this.from = new IdNameEntityJSONImpl(fromJSONObject);
                }
                this.name = z_F4JInternalParseUtil.getRawString("name", json);
                this.voteCount = z_F4JInternalParseUtil.getPrimitiveInt("vote_count", json);
                this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
                this.votes = z_F4JInternalParseUtil.getPrimitiveInt("votes", json);
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone.getMessage(), jsone);
            }
        }

        public String getId() {
            return this.id;
        }

        public IdNameEntity getFrom() {
            return this.from;
        }

        public String getName() {
            return this.name;
        }

        public Integer getVoteCount() {
            return this.voteCount;
        }

        public Date getCreatedTime() {
            return this.createdTime;
        }

        public Integer getVotes() {
            return this.votes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OptionJSONImpl other = (OptionJSONImpl)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return "OptionJSONImpl [id=" + this.id + ", from=" + this.from + ", name=" + this.name + ", voteCount=" + this.voteCount + ", createdTime=" + this.createdTime + ", votes=" + this.votes + "]";
        }
    }
}

